/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.MapCodec;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.WorldChunkManager;

public class WorldChunkManagerHell
extends WorldChunkManager
implements BiomeManager.Provider {
    public static final MapCodec<WorldChunkManagerHell> CODEC = BiomeBase.CODEC.fieldOf("biome").xmap(WorldChunkManagerHell::new, var0 -> var0.biome).stable();
    private final Holder<BiomeBase> biome;

    public WorldChunkManagerHell(Holder<BiomeBase> var0) {
        this.biome = var0;
    }

    @Override
    protected Stream<Holder<BiomeBase>> collectPossibleBiomes() {
        return Stream.of(this.biome);
    }

    @Override
    protected MapCodec<? extends WorldChunkManager> codec() {
        return CODEC;
    }

    @Override
    public Holder<BiomeBase> getNoiseBiome(int var0, int var1, int var2, Climate.Sampler var3) {
        return this.biome;
    }

    @Override
    public Holder<BiomeBase> getNoiseBiome(int var0, int var1, int var2) {
        return this.biome;
    }

    @Override
    @Nullable
    public Pair<BlockPosition, Holder<BiomeBase>> findBiomeHorizontal(int var0, int var1, int var2, int var3, int var4, Predicate<Holder<BiomeBase>> var5, RandomSource var6, boolean var7, Climate.Sampler var8) {
        if (var5.test(this.biome)) {
            if (var7) {
                return Pair.of((Object)new BlockPosition(var0, var1, var2), this.biome);
            }
            return Pair.of((Object)new BlockPosition(var0 - var3 + var6.nextInt(var3 * 2 + 1), var1, var2 - var3 + var6.nextInt(var3 * 2 + 1)), this.biome);
        }
        return null;
    }

    @Override
    @Nullable
    public Pair<BlockPosition, Holder<BiomeBase>> findClosestBiome3d(BlockPosition var0, int var1, int var2, int var3, Predicate<Holder<BiomeBase>> var4, Climate.Sampler var5, IWorldReader var6) {
        return var4.test(this.biome) ? Pair.of((Object)var0, this.biome) : null;
    }

    @Override
    public Set<Holder<BiomeBase>> getBiomesWithin(int var0, int var1, int var2, int var3, Climate.Sampler var4) {
        return Sets.newHashSet(Set.of(this.biome));
    }
}

