/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Map;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSprawling;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;

public class BlockHugeMushroom
extends Block {
    public static final MapCodec<BlockHugeMushroom> CODEC = BlockHugeMushroom.simpleCodec(BlockHugeMushroom::new);
    public static final BlockStateBoolean NORTH = BlockSprawling.NORTH;
    public static final BlockStateBoolean EAST = BlockSprawling.EAST;
    public static final BlockStateBoolean SOUTH = BlockSprawling.SOUTH;
    public static final BlockStateBoolean WEST = BlockSprawling.WEST;
    public static final BlockStateBoolean UP = BlockSprawling.UP;
    public static final BlockStateBoolean DOWN = BlockSprawling.DOWN;
    private static final Map<EnumDirection, BlockStateBoolean> PROPERTY_BY_DIRECTION = BlockSprawling.PROPERTY_BY_DIRECTION;

    public MapCodec<BlockHugeMushroom> codec() {
        return CODEC;
    }

    public BlockHugeMushroom(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(NORTH, true)).setValue(EAST, true)).setValue(SOUTH, true)).setValue(WEST, true)).setValue(UP, true)).setValue(DOWN, true));
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        World var1 = var0.getLevel();
        BlockPosition var2 = var0.getClickedPos();
        return (IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.defaultBlockState().setValue(DOWN, !var1.getBlockState(var2.below()).is(this))).setValue(UP, !var1.getBlockState(var2.above()).is(this))).setValue(NORTH, !var1.getBlockState(var2.north()).is(this))).setValue(EAST, !var1.getBlockState(var2.east()).is(this))).setValue(SOUTH, !var1.getBlockState(var2.south()).is(this))).setValue(WEST, !var1.getBlockState(var2.west()).is(this));
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, IWorldReader var1, ScheduledTickAccess var2, BlockPosition var3, EnumDirection var4, BlockPosition var5, IBlockData var6, RandomSource var7) {
        if (var6.is(this)) {
            return (IBlockData)var0.setValue(PROPERTY_BY_DIRECTION.get(var4), false);
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    @Override
    protected IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        return (IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)var0.setValue(PROPERTY_BY_DIRECTION.get(var1.rotate(EnumDirection.NORTH)), var0.getValue(NORTH))).setValue(PROPERTY_BY_DIRECTION.get(var1.rotate(EnumDirection.SOUTH)), var0.getValue(SOUTH))).setValue(PROPERTY_BY_DIRECTION.get(var1.rotate(EnumDirection.EAST)), var0.getValue(EAST))).setValue(PROPERTY_BY_DIRECTION.get(var1.rotate(EnumDirection.WEST)), var0.getValue(WEST))).setValue(PROPERTY_BY_DIRECTION.get(var1.rotate(EnumDirection.UP)), var0.getValue(UP))).setValue(PROPERTY_BY_DIRECTION.get(var1.rotate(EnumDirection.DOWN)), var0.getValue(DOWN));
    }

    @Override
    protected IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        return (IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)var0.setValue(PROPERTY_BY_DIRECTION.get(var1.mirror(EnumDirection.NORTH)), var0.getValue(NORTH))).setValue(PROPERTY_BY_DIRECTION.get(var1.mirror(EnumDirection.SOUTH)), var0.getValue(SOUTH))).setValue(PROPERTY_BY_DIRECTION.get(var1.mirror(EnumDirection.EAST)), var0.getValue(EAST))).setValue(PROPERTY_BY_DIRECTION.get(var1.mirror(EnumDirection.WEST)), var0.getValue(WEST))).setValue(PROPERTY_BY_DIRECTION.get(var1.mirror(EnumDirection.UP)), var0.getValue(UP))).setValue(PROPERTY_BY_DIRECTION.get(var1.mirror(EnumDirection.DOWN)), var0.getValue(DOWN));
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(UP, DOWN, NORTH, EAST, SOUTH, WEST);
    }
}

