/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Arrays;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SignApplicator;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyWood;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public abstract class BlockSign
extends BlockTileEntity
implements IBlockWaterlogged {
    public static final BlockStateBoolean WATERLOGGED = BlockProperties.WATERLOGGED;
    private static final VoxelShape SHAPE = Block.column(8.0, 0.0, 16.0);
    private final BlockPropertyWood type;

    protected BlockSign(BlockPropertyWood var0, BlockBase.Info var1) {
        super(var1);
        this.type = var0;
    }

    protected abstract MapCodec<? extends BlockSign> codec();

    @Override
    protected IBlockData updateShape(IBlockData var0, IWorldReader var1, ScheduledTickAccess var2, BlockPosition var3, EnumDirection var4, BlockPosition var5, IBlockData var6, RandomSource var7) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            var2.scheduleTick(var3, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(var1));
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPE;
    }

    @Override
    public boolean isPossibleToRespawnInThis(IBlockData var0) {
        return true;
    }

    @Override
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new TileEntitySign(var0, var1);
    }

    @Override
    protected EnumInteractionResult useItemOn(ItemStack var0, IBlockData var1, World var2, BlockPosition var3, EntityHuman var4, EnumHand var5, MovingObjectPositionBlock var6) {
        SignApplicator var9;
        TileEntity tileEntity = var2.getBlockEntity(var3);
        if (!(tileEntity instanceof TileEntitySign)) {
            return EnumInteractionResult.PASS;
        }
        TileEntitySign var7 = (TileEntitySign)tileEntity;
        Item item = var0.getItem();
        SignApplicator var8 = item instanceof SignApplicator ? (var9 = (SignApplicator)((Object)item)) : null;
        boolean bl = var9 = var8 != null && var4.mayBuild();
        if (!(var2 instanceof WorldServer)) {
            return var9 || var7.isWaxed() ? EnumInteractionResult.SUCCESS : EnumInteractionResult.CONSUME;
        }
        WorldServer var10 = (WorldServer)var2;
        if (!var9 || var7.isWaxed() || this.otherPlayerIsEditingSign(var4, var7)) {
            return EnumInteractionResult.TRY_WITH_EMPTY_HAND;
        }
        boolean var11 = var7.isFacingFrontText(var4);
        if (var8.canApplyToSign(var7.getText(var11), var4) && var8.tryApplyToSign(var10, var7, var11, var4)) {
            var7.executeClickCommandsIfPresent(var10, var4, var3, var11);
            var4.awardStat(StatisticList.ITEM_USED.get(var0.getItem()));
            var10.gameEvent(GameEvent.BLOCK_CHANGE, var7.getBlockPos(), GameEvent.a.of(var4, var7.getBlockState()));
            var0.consume(1, var4);
            return EnumInteractionResult.SUCCESS;
        }
        return EnumInteractionResult.TRY_WITH_EMPTY_HAND;
    }

    @Override
    protected EnumInteractionResult useWithoutItem(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, MovingObjectPositionBlock var4) {
        TileEntity tileEntity = var1.getBlockEntity(var2);
        if (!(tileEntity instanceof TileEntitySign)) {
            return EnumInteractionResult.PASS;
        }
        TileEntitySign var5 = (TileEntitySign)tileEntity;
        if (!(var1 instanceof WorldServer)) {
            SystemUtils.pauseInIde(new IllegalStateException("Expected to only call this on server"));
            return EnumInteractionResult.CONSUME;
        }
        WorldServer var6 = (WorldServer)var1;
        boolean var7 = var5.isFacingFrontText(var3);
        boolean var8 = var5.executeClickCommandsIfPresent(var6, var3, var2, var7);
        if (var5.isWaxed()) {
            var6.playSound(null, var5.getBlockPos(), var5.getSignInteractionFailedSoundEvent(), SoundCategory.BLOCKS);
            return EnumInteractionResult.SUCCESS_SERVER;
        }
        if (var8) {
            return EnumInteractionResult.SUCCESS_SERVER;
        }
        if (!this.otherPlayerIsEditingSign(var3, var5) && var3.mayBuild() && this.hasEditableText(var3, var5, var7)) {
            this.openTextEdit(var3, var5, var7);
            return EnumInteractionResult.SUCCESS_SERVER;
        }
        return EnumInteractionResult.PASS;
    }

    private boolean hasEditableText(EntityHuman var02, TileEntitySign var1, boolean var2) {
        SignText var3 = var1.getText(var2);
        return Arrays.stream(var3.getMessages(var02.isTextFilteringEnabled())).allMatch(var0 -> var0.equals(CommonComponents.EMPTY) || var0.getContents() instanceof LiteralContents);
    }

    public abstract float getYRotationDegrees(IBlockData var1);

    public Vec3D getSignHitboxCenterPosition(IBlockData var0) {
        return new Vec3D(0.5, 0.5, 0.5);
    }

    @Override
    protected Fluid getFluidState(IBlockData var0) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            return FluidTypes.WATER.getSource(false);
        }
        return super.getFluidState(var0);
    }

    public BlockPropertyWood type() {
        return this.type;
    }

    public static BlockPropertyWood getWoodType(Block var0) {
        BlockPropertyWood var1 = var0 instanceof BlockSign ? ((BlockSign)var0).type() : BlockPropertyWood.OAK;
        return var1;
    }

    public void openTextEdit(EntityHuman var0, TileEntitySign var1, boolean var2) {
        var1.setAllowedPlayerEditor(var0.getUUID());
        var0.openTextEdit(var1, var2);
    }

    private boolean otherPlayerIsEditingSign(EntityHuman var0, TileEntitySign var1) {
        UUID var2 = var1.getPlayerWhoMayEdit();
        return var2 != null && !var2.equals(var0.getUUID());
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> getTicker(World var0, IBlockData var1, TileEntityTypes<T> var2) {
        return BlockSign.createTickerHelper(var2, TileEntityTypes.SIGN, TileEntitySign::tick);
    }
}

