/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.animal.HappyGhast;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.ticks.TickListServer;

public class DriedGhastBlock
extends BlockFacingHorizontal
implements IBlockWaterlogged {
    public static final MapCodec<DriedGhastBlock> CODEC = DriedGhastBlock.simpleCodec(DriedGhastBlock::new);
    public static final int MAX_HYDRATION_LEVEL = 3;
    public static final BlockStateInteger HYDRATION_LEVEL = BlockProperties.DRIED_GHAST_HYDRATION_LEVELS;
    public static final BlockStateBoolean WATERLOGGED = BlockProperties.WATERLOGGED;
    public static final int HYDRATION_TICK_DELAY = 5000;
    private static final VoxelShape SHAPE = Block.column(10.0, 10.0, 0.0, 10.0);

    public MapCodec<DriedGhastBlock> codec() {
        return CODEC;
    }

    public DriedGhastBlock(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(FACING, EnumDirection.NORTH)).setValue(HYDRATION_LEVEL, 0)).setValue(WATERLOGGED, false));
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(FACING, HYDRATION_LEVEL, WATERLOGGED);
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, IWorldReader var1, ScheduledTickAccess var2, BlockPosition var3, EnumDirection var4, BlockPosition var5, IBlockData var6, RandomSource var7) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            var2.scheduleTick(var3, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(var1));
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPE;
    }

    public int getHydrationLevel(IBlockData var0) {
        return var0.getValue(HYDRATION_LEVEL);
    }

    private boolean isReadyToSpawn(IBlockData var0) {
        return this.getHydrationLevel(var0) == 3;
    }

    @Override
    protected void tick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            this.tickWaterlogged(var0, var1, var2, var3);
            return;
        }
        int var4 = this.getHydrationLevel(var0);
        if (var4 > 0) {
            var1.setBlock(var2, (IBlockData)var0.setValue(HYDRATION_LEVEL, var4 - 1), 2);
            var1.gameEvent(GameEvent.BLOCK_CHANGE, var2, GameEvent.a.of(var0));
        }
    }

    private void tickWaterlogged(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        if (!this.isReadyToSpawn(var0)) {
            var1.playSound(null, var2, SoundEffects.DRIED_GHAST_TRANSITION, SoundCategory.BLOCKS, 1.0f, 1.0f);
            var1.setBlock(var2, (IBlockData)var0.setValue(HYDRATION_LEVEL, this.getHydrationLevel(var0) + 1), 2);
            var1.gameEvent(GameEvent.BLOCK_CHANGE, var2, GameEvent.a.of(var0));
        } else {
            this.spawnGhastling(var1, var2, var0);
        }
    }

    private void spawnGhastling(WorldServer var0, BlockPosition var1, IBlockData var2) {
        var0.removeBlock(var1, false);
        HappyGhast var3 = EntityTypes.HAPPY_GHAST.create(var0, EntitySpawnReason.BREEDING);
        if (var3 != null) {
            Vec3D var4 = var1.getBottomCenter();
            var3.setBaby(true);
            float var5 = EnumDirection.getYRot((EnumDirection)var2.getValue(FACING));
            var3.setYHeadRot(var5);
            var3.snapTo(var4.x(), var4.y(), var4.z(), var5, 0.0f);
            var0.addFreshEntity(var3);
            var0.playSound(null, var3, SoundEffects.GHASTLING_SPAWN, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    @Override
    public void animateTick(IBlockData var0, World var1, BlockPosition var2, RandomSource var3) {
        double var4 = (double)var2.getX() + 0.5;
        double var6 = (double)var2.getY() + 0.5;
        double var8 = (double)var2.getZ() + 0.5;
        if (!var0.getValue(WATERLOGGED).booleanValue()) {
            if (var3.nextInt(40) == 0 && var1.getBlockState(var2.below()).is(TagsBlock.TRIGGERS_AMBIENT_DRIED_GHAST_BLOCK_SOUNDS)) {
                var1.playLocalSound(var4, var6, var8, SoundEffects.DRIED_GHAST_AMBIENT, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
            if (var3.nextInt(6) == 0) {
                var1.addParticle(Particles.WHITE_SMOKE, var4, var6, var8, 0.0, 0.02, 0.0);
            }
        } else {
            if (var3.nextInt(40) == 0) {
                var1.playLocalSound(var4, var6, var8, SoundEffects.DRIED_GHAST_AMBIENT_WATER, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
            if (var3.nextInt(6) == 0) {
                var1.addParticle(Particles.HAPPY_VILLAGER, var4 + (double)((var3.nextFloat() * 2.0f - 1.0f) / 3.0f), var6 + 0.4, var8 + (double)((var3.nextFloat() * 2.0f - 1.0f) / 3.0f), 0.0, var3.nextFloat(), 0.0);
            }
        }
    }

    @Override
    protected void randomTick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        if ((var0.getValue(WATERLOGGED).booleanValue() || var0.getValue(HYDRATION_LEVEL) > 0) && !((TickListServer)var1.getBlockTicks()).hasScheduledTick(var2, this)) {
            var1.scheduleTick(var2, this, 5000);
        }
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        Fluid var1 = var0.getLevel().getFluidState(var0.getClickedPos());
        boolean var2 = var1.getType() == FluidTypes.WATER;
        return (IBlockData)((IBlockData)super.getStateForPlacement(var0).setValue(WATERLOGGED, var2)).setValue(FACING, var0.getHorizontalDirection().getOpposite());
    }

    @Override
    protected Fluid getFluidState(IBlockData var0) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            return FluidTypes.WATER.getSource(false);
        }
        return super.getFluidState(var0);
    }

    @Override
    public boolean placeLiquid(GeneratorAccess var0, BlockPosition var1, IBlockData var2, Fluid var3) {
        if (var2.getValue(BlockProperties.WATERLOGGED).booleanValue() || var3.getType() != FluidTypes.WATER) {
            return false;
        }
        if (!var0.isClientSide()) {
            var0.setBlock(var1, (IBlockData)var2.setValue(BlockProperties.WATERLOGGED, true), 3);
            var0.scheduleTick(var1, var3.getType(), var3.getType().getTickDelay(var0));
            var0.playSound(null, var1, SoundEffects.DRIED_GHAST_PLACE_IN_WATER, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        return true;
    }

    @Override
    public void setPlacedBy(World var0, BlockPosition var1, IBlockData var2, @Nullable EntityLiving var3, ItemStack var4) {
        super.setPlacedBy(var0, var1, var2, var3, var4);
        var0.playSound(null, var1, var2.getValue(WATERLOGGED) != false ? SoundEffects.DRIED_GHAST_PLACE_IN_WATER : SoundEffects.DRIED_GHAST_PLACE, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    @Override
    public boolean isPathfindable(IBlockData var0, PathMode var1) {
        return false;
    }
}

