/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSprawling;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class MultifaceBlock
extends Block
implements IBlockWaterlogged {
    public static final MapCodec<MultifaceBlock> CODEC = MultifaceBlock.simpleCodec(MultifaceBlock::new);
    public static final BlockStateBoolean WATERLOGGED = BlockProperties.WATERLOGGED;
    private static final Map<EnumDirection, BlockStateBoolean> PROPERTY_BY_DIRECTION = BlockSprawling.PROPERTY_BY_DIRECTION;
    protected static final EnumDirection[] DIRECTIONS = EnumDirection.values();
    private final Function<IBlockData, VoxelShape> shapes;
    private final boolean canRotate;
    private final boolean canMirrorX;
    private final boolean canMirrorZ;

    protected MapCodec<? extends MultifaceBlock> codec() {
        return CODEC;
    }

    public MultifaceBlock(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState(MultifaceBlock.getDefaultMultifaceState(this.stateDefinition));
        this.shapes = this.makeShapes();
        this.canRotate = EnumDirection.EnumDirectionLimit.HORIZONTAL.stream().allMatch(this::isFaceSupported);
        this.canMirrorX = EnumDirection.EnumDirectionLimit.HORIZONTAL.stream().filter(EnumDirection.EnumAxis.X).filter(this::isFaceSupported).count() % 2L == 0L;
        this.canMirrorZ = EnumDirection.EnumDirectionLimit.HORIZONTAL.stream().filter(EnumDirection.EnumAxis.Z).filter(this::isFaceSupported).count() % 2L == 0L;
    }

    private Function<IBlockData, VoxelShape> makeShapes() {
        Map<EnumDirection, VoxelShape> var0 = VoxelShapes.rotateAll(Block.boxZ(16.0, 0.0, 1.0));
        return this.getShapeForEachState(var1 -> {
            VoxelShape var2 = VoxelShapes.empty();
            for (EnumDirection var6 : DIRECTIONS) {
                if (!MultifaceBlock.hasFace(var1, var6)) continue;
                var2 = VoxelShapes.or(var2, (VoxelShape)var0.get(var6));
            }
            return var2.isEmpty() ? VoxelShapes.block() : var2;
        }, WATERLOGGED);
    }

    public static Set<EnumDirection> availableFaces(IBlockData var0) {
        if (!(var0.getBlock() instanceof MultifaceBlock)) {
            return Set.of();
        }
        EnumSet<EnumDirection> var1 = EnumSet.noneOf(EnumDirection.class);
        for (EnumDirection var5 : EnumDirection.values()) {
            if (!MultifaceBlock.hasFace(var0, var5)) continue;
            var1.add(var5);
        }
        return var1;
    }

    public static Set<EnumDirection> unpack(byte var0) {
        EnumSet<EnumDirection> var1 = EnumSet.noneOf(EnumDirection.class);
        for (EnumDirection var5 : EnumDirection.values()) {
            if ((var0 & (byte)(1 << var5.ordinal())) <= 0) continue;
            var1.add(var5);
        }
        return var1;
    }

    public static byte pack(Collection<EnumDirection> var0) {
        byte var1 = 0;
        for (EnumDirection var3 : var0) {
            var1 = (byte)(var1 | 1 << var3.ordinal());
        }
        return var1;
    }

    protected boolean isFaceSupported(EnumDirection var0) {
        return true;
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        for (EnumDirection var4 : DIRECTIONS) {
            if (!this.isFaceSupported(var4)) continue;
            var0.add(MultifaceBlock.getFaceProperty(var4));
        }
        var0.add(WATERLOGGED);
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, IWorldReader var1, ScheduledTickAccess var2, BlockPosition var3, EnumDirection var4, BlockPosition var5, IBlockData var6, RandomSource var7) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            var2.scheduleTick(var3, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(var1));
        }
        if (!MultifaceBlock.hasAnyFace(var0)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (!MultifaceBlock.hasFace(var0, var4) || MultifaceBlock.canAttachTo(var1, var4, var5, var6)) {
            return var0;
        }
        return MultifaceBlock.removeFace(var0, MultifaceBlock.getFaceProperty(var4));
    }

    @Override
    protected Fluid getFluidState(IBlockData var0) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            return FluidTypes.WATER.getSource(false);
        }
        return super.getFluidState(var0);
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return this.shapes.apply(var0);
    }

    @Override
    protected boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        boolean var3 = false;
        for (EnumDirection var7 : DIRECTIONS) {
            if (!MultifaceBlock.hasFace(var0, var7)) continue;
            if (!MultifaceBlock.canAttachTo(var1, var2, var7)) {
                return false;
            }
            var3 = true;
        }
        return var3;
    }

    @Override
    protected boolean canBeReplaced(IBlockData var0, BlockActionContext var1) {
        return !var1.getItemInHand().is(this.asItem()) || MultifaceBlock.hasAnyVacantFace(var0);
    }

    @Override
    @Nullable
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        World var1 = var0.getLevel();
        BlockPosition var2 = var0.getClickedPos();
        IBlockData var32 = var1.getBlockState(var2);
        return Arrays.stream(var0.getNearestLookingDirections()).map(var3 -> this.getStateForPlacement(var32, var1, var2, (EnumDirection)var3)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public boolean isValidStateForPlacement(IBlockAccess var0, IBlockData var1, BlockPosition var2, EnumDirection var3) {
        if (!this.isFaceSupported(var3) || var1.is(this) && MultifaceBlock.hasFace(var1, var3)) {
            return false;
        }
        BlockPosition var4 = var2.relative(var3);
        return MultifaceBlock.canAttachTo(var0, var3, var4, var0.getBlockState(var4));
    }

    @Nullable
    public IBlockData getStateForPlacement(IBlockData var0, IBlockAccess var1, BlockPosition var2, EnumDirection var3) {
        if (!this.isValidStateForPlacement(var1, var0, var2, var3)) {
            return null;
        }
        IBlockData var4 = var0.is(this) ? var0 : (var0.getFluidState().isSourceOfType(FluidTypes.WATER) ? (IBlockData)this.defaultBlockState().setValue(BlockProperties.WATERLOGGED, true) : this.defaultBlockState());
        return (IBlockData)var4.setValue(MultifaceBlock.getFaceProperty(var3), true);
    }

    @Override
    protected IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        if (!this.canRotate) {
            return var0;
        }
        return this.mapDirections(var0, var1::rotate);
    }

    @Override
    protected IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        if (var1 == EnumBlockMirror.FRONT_BACK && !this.canMirrorX) {
            return var0;
        }
        if (var1 == EnumBlockMirror.LEFT_RIGHT && !this.canMirrorZ) {
            return var0;
        }
        return this.mapDirections(var0, var1::mirror);
    }

    private IBlockData mapDirections(IBlockData var0, Function<EnumDirection, EnumDirection> var1) {
        IBlockData var2 = var0;
        for (EnumDirection var6 : DIRECTIONS) {
            if (!this.isFaceSupported(var6)) continue;
            var2 = (IBlockData)var2.setValue(MultifaceBlock.getFaceProperty(var1.apply(var6)), var0.getValue(MultifaceBlock.getFaceProperty(var6)));
        }
        return var2;
    }

    public static boolean hasFace(IBlockData var0, EnumDirection var1) {
        BlockStateBoolean var2 = MultifaceBlock.getFaceProperty(var1);
        return var0.getValueOrElse(var2, false);
    }

    public static boolean canAttachTo(IBlockAccess var0, BlockPosition var1, EnumDirection var2) {
        BlockPosition var3 = var1.relative(var2);
        IBlockData var4 = var0.getBlockState(var3);
        return MultifaceBlock.canAttachTo(var0, var2, var3, var4);
    }

    public static boolean canAttachTo(IBlockAccess var0, EnumDirection var1, BlockPosition var2, IBlockData var3) {
        return Block.isFaceFull(var3.getBlockSupportShape(var0, var2), var1.getOpposite()) || Block.isFaceFull(var3.getCollisionShape(var0, var2), var1.getOpposite());
    }

    private static IBlockData removeFace(IBlockData var0, BlockStateBoolean var1) {
        IBlockData var2 = (IBlockData)var0.setValue(var1, false);
        if (MultifaceBlock.hasAnyFace(var2)) {
            return var2;
        }
        return Blocks.AIR.defaultBlockState();
    }

    public static BlockStateBoolean getFaceProperty(EnumDirection var0) {
        return PROPERTY_BY_DIRECTION.get(var0);
    }

    private static IBlockData getDefaultMultifaceState(BlockStateList<Block, IBlockData> var0) {
        IBlockData var1 = (IBlockData)var0.any().setValue(WATERLOGGED, false);
        for (BlockStateBoolean var3 : PROPERTY_BY_DIRECTION.values()) {
            var1 = (IBlockData)var1.trySetValue(var3, false);
        }
        return var1;
    }

    protected static boolean hasAnyFace(IBlockData var0) {
        for (EnumDirection var4 : DIRECTIONS) {
            if (!MultifaceBlock.hasFace(var0, var4)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasAnyVacantFace(IBlockData var0) {
        for (EnumDirection var4 : DIRECTIONS) {
            if (MultifaceBlock.hasFace(var0, var4)) continue;
            return true;
        }
        return false;
    }
}

