/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.entity.TrialSpawnerBlockEntity;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;

public class TrialSpawnerBlock
extends BlockTileEntity {
    public static final MapCodec<TrialSpawnerBlock> CODEC = TrialSpawnerBlock.simpleCodec(TrialSpawnerBlock::new);
    public static final BlockStateEnum<TrialSpawnerState> STATE = BlockProperties.TRIAL_SPAWNER_STATE;
    public static final BlockStateBoolean OMINOUS = BlockProperties.OMINOUS;

    public MapCodec<TrialSpawnerBlock> codec() {
        return CODEC;
    }

    public TrialSpawnerBlock(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(STATE, TrialSpawnerState.INACTIVE)).setValue(OMINOUS, false));
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(STATE, OMINOUS);
    }

    @Override
    @Nullable
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new TrialSpawnerBlockEntity(var0, var1);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> getTicker(World var02, IBlockData var12, TileEntityTypes<T> var22) {
        BlockEntityTicker<T> blockEntityTicker;
        if (var02 instanceof WorldServer) {
            WorldServer var32 = (WorldServer)var02;
            blockEntityTicker = TrialSpawnerBlock.createTickerHelper(var22, TileEntityTypes.TRIAL_SPAWNER, (var1, var2, var3, var4) -> var4.getTrialSpawner().tickServer(var32, var2, var3.getOptionalValue(BlockProperties.OMINOUS).orElse(false)));
        } else {
            blockEntityTicker = TrialSpawnerBlock.createTickerHelper(var22, TileEntityTypes.TRIAL_SPAWNER, (var0, var1, var2, var3) -> var3.getTrialSpawner().tickClient(var0, var1, var2.getOptionalValue(BlockProperties.OMINOUS).orElse(false)));
        }
        return blockEntityTicker;
    }
}

