/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.IChunkAccess;

public class BulkSectionAccess
implements AutoCloseable {
    private final GeneratorAccess level;
    private final Long2ObjectMap<ChunkSection> acquiredSections = new Long2ObjectOpenHashMap();
    @Nullable
    private ChunkSection lastSection;
    private long lastSectionKey;

    public BulkSectionAccess(GeneratorAccess var0) {
        this.level = var0;
    }

    @Nullable
    public ChunkSection getSection(BlockPosition var0) {
        int var1 = this.level.getSectionIndex(var0.getY());
        if (var1 < 0 || var1 >= this.level.getSectionsCount()) {
            return null;
        }
        long var22 = SectionPosition.asLong(var0);
        if (this.lastSection == null || this.lastSectionKey != var22) {
            this.lastSection = (ChunkSection)this.acquiredSections.computeIfAbsent(var22, var2 -> {
                IChunkAccess var4 = this.level.getChunk(SectionPosition.blockToSectionCoord(var0.getX()), SectionPosition.blockToSectionCoord(var0.getZ()));
                ChunkSection var5 = var4.getSection(var1);
                var5.acquire();
                return var5;
            });
            this.lastSectionKey = var22;
        }
        return this.lastSection;
    }

    public IBlockData getBlockState(BlockPosition var0) {
        ChunkSection var1 = this.getSection(var0);
        if (var1 == null) {
            return Blocks.AIR.defaultBlockState();
        }
        int var2 = SectionPosition.sectionRelative(var0.getX());
        int var3 = SectionPosition.sectionRelative(var0.getY());
        int var4 = SectionPosition.sectionRelative(var0.getZ());
        return var1.getBlockState(var2, var3, var4);
    }

    @Override
    public void close() {
        for (ChunkSection var1 : this.acquiredSections.values()) {
            var1.release();
        }
    }
}

