/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkConverter;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.lighting.ChunkSkyLightSources;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.ticks.TickContainerAccess;
import net.minecraft.world.ticks.TickListEmpty;

public class ProtoChunkExtension
extends ProtoChunk {
    private final Chunk wrapped;
    private final boolean allowWrites;

    public ProtoChunkExtension(Chunk var0, boolean var1) {
        super(var0.getPos(), ChunkConverter.EMPTY, var0.levelHeightAccessor, (IRegistry<BiomeBase>)var0.getLevel().registryAccess().lookupOrThrow(Registries.BIOME), var0.getBlendingData());
        this.wrapped = var0;
        this.allowWrites = var1;
    }

    @Override
    @Nullable
    public TileEntity getBlockEntity(BlockPosition var0) {
        return this.wrapped.getBlockEntity(var0);
    }

    @Override
    public IBlockData getBlockState(BlockPosition var0) {
        return this.wrapped.getBlockState(var0);
    }

    @Override
    public Fluid getFluidState(BlockPosition var0) {
        return this.wrapped.getFluidState(var0);
    }

    @Override
    public ChunkSection getSection(int var0) {
        if (this.allowWrites) {
            return this.wrapped.getSection(var0);
        }
        return super.getSection(var0);
    }

    @Override
    @Nullable
    public IBlockData setBlockState(BlockPosition var0, IBlockData var1, int var2) {
        if (this.allowWrites) {
            return this.wrapped.setBlockState(var0, var1, var2);
        }
        return null;
    }

    @Override
    public void setBlockEntity(TileEntity var0) {
        if (this.allowWrites) {
            this.wrapped.setBlockEntity(var0);
        }
    }

    @Override
    public void addEntity(Entity var0) {
        if (this.allowWrites) {
            this.wrapped.addEntity(var0);
        }
    }

    @Override
    public void setPersistedStatus(ChunkStatus var0) {
        if (this.allowWrites) {
            super.setPersistedStatus(var0);
        }
    }

    @Override
    public ChunkSection[] getSections() {
        return this.wrapped.getSections();
    }

    @Override
    public void setHeightmap(HeightMap.Type var0, long[] var1) {
    }

    private HeightMap.Type fixType(HeightMap.Type var0) {
        if (var0 == HeightMap.Type.WORLD_SURFACE_WG) {
            return HeightMap.Type.WORLD_SURFACE;
        }
        if (var0 == HeightMap.Type.OCEAN_FLOOR_WG) {
            return HeightMap.Type.OCEAN_FLOOR;
        }
        return var0;
    }

    @Override
    public HeightMap getOrCreateHeightmapUnprimed(HeightMap.Type var0) {
        return this.wrapped.getOrCreateHeightmapUnprimed(var0);
    }

    @Override
    public int getHeight(HeightMap.Type var0, int var1, int var2) {
        return this.wrapped.getHeight(this.fixType(var0), var1, var2);
    }

    @Override
    public Holder<BiomeBase> getNoiseBiome(int var0, int var1, int var2) {
        return this.wrapped.getNoiseBiome(var0, var1, var2);
    }

    @Override
    public ChunkCoordIntPair getPos() {
        return this.wrapped.getPos();
    }

    @Override
    @Nullable
    public StructureStart getStartForStructure(Structure var0) {
        return this.wrapped.getStartForStructure(var0);
    }

    @Override
    public void setStartForStructure(Structure var0, StructureStart var1) {
    }

    @Override
    public Map<Structure, StructureStart> getAllStarts() {
        return this.wrapped.getAllStarts();
    }

    @Override
    public void setAllStarts(Map<Structure, StructureStart> var0) {
    }

    @Override
    public LongSet getReferencesForStructure(Structure var0) {
        return this.wrapped.getReferencesForStructure(var0);
    }

    @Override
    public void addReferenceForStructure(Structure var0, long var1) {
    }

    @Override
    public Map<Structure, LongSet> getAllReferences() {
        return this.wrapped.getAllReferences();
    }

    @Override
    public void setAllReferences(Map<Structure, LongSet> var0) {
    }

    @Override
    public void markUnsaved() {
        this.wrapped.markUnsaved();
    }

    @Override
    public boolean canBeSerialized() {
        return false;
    }

    @Override
    public boolean tryMarkSaved() {
        return false;
    }

    @Override
    public boolean isUnsaved() {
        return false;
    }

    @Override
    public ChunkStatus getPersistedStatus() {
        return this.wrapped.getPersistedStatus();
    }

    @Override
    public void removeBlockEntity(BlockPosition var0) {
    }

    @Override
    public void markPosForPostprocessing(BlockPosition var0) {
    }

    @Override
    public void setBlockEntityNbt(NBTTagCompound var0) {
    }

    @Override
    @Nullable
    public NBTTagCompound getBlockEntityNbt(BlockPosition var0) {
        return this.wrapped.getBlockEntityNbt(var0);
    }

    @Override
    @Nullable
    public NBTTagCompound getBlockEntityNbtForSaving(BlockPosition var0, HolderLookup.a var1) {
        return this.wrapped.getBlockEntityNbtForSaving(var0, var1);
    }

    @Override
    public void findBlocks(Predicate<IBlockData> var0, BiConsumer<BlockPosition, IBlockData> var1) {
        this.wrapped.findBlocks(var0, var1);
    }

    @Override
    public TickContainerAccess<Block> getBlockTicks() {
        if (this.allowWrites) {
            return this.wrapped.getBlockTicks();
        }
        return TickListEmpty.emptyContainer();
    }

    @Override
    public TickContainerAccess<FluidType> getFluidTicks() {
        if (this.allowWrites) {
            return this.wrapped.getFluidTicks();
        }
        return TickListEmpty.emptyContainer();
    }

    @Override
    public IChunkAccess.b getTicksForSerialization(long var0) {
        return this.wrapped.getTicksForSerialization(var0);
    }

    @Override
    @Nullable
    public BlendingData getBlendingData() {
        return this.wrapped.getBlendingData();
    }

    @Override
    public CarvingMask getCarvingMask() {
        if (this.allowWrites) {
            return super.getCarvingMask();
        }
        throw SystemUtils.pauseInIde(new UnsupportedOperationException("Meaningless in this context"));
    }

    @Override
    public CarvingMask getOrCreateCarvingMask() {
        if (this.allowWrites) {
            return super.getOrCreateCarvingMask();
        }
        throw SystemUtils.pauseInIde(new UnsupportedOperationException("Meaningless in this context"));
    }

    public Chunk getWrapped() {
        return this.wrapped;
    }

    @Override
    public boolean isLightCorrect() {
        return this.wrapped.isLightCorrect();
    }

    @Override
    public void setLightCorrect(boolean var0) {
        this.wrapped.setLightCorrect(var0);
    }

    @Override
    public void fillBiomesFromNoise(BiomeResolver var0, Climate.Sampler var1) {
        if (this.allowWrites) {
            this.wrapped.fillBiomesFromNoise(var0, var1);
        }
    }

    @Override
    public void initializeLightSources() {
        this.wrapped.initializeLightSources();
    }

    @Override
    public ChunkSkyLightSources getSkyLightSources() {
        return this.wrapped.getSkyLightSources();
    }
}

