/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Suppliers;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.QuartPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.BlockColumn;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.BiomeSettingsGeneration;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.Beardifier;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseRouterData;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverWrapper;
import org.apache.commons.lang3.mutable.MutableObject;

public final class ChunkGeneratorAbstract
extends ChunkGenerator {
    public static final MapCodec<ChunkGeneratorAbstract> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)WorldChunkManager.CODEC.fieldOf("biome_source").forGetter(var0 -> var0.biomeSource), (App)GeneratorSettingBase.CODEC.fieldOf("settings").forGetter(var0 -> var0.settings)).apply((Applicative)var02, var02.stable(ChunkGeneratorAbstract::new)));
    private static final IBlockData AIR = Blocks.AIR.defaultBlockState();
    public final Holder<GeneratorSettingBase> settings;
    private final Supplier<Aquifer.a> globalFluidPicker;

    public ChunkGeneratorAbstract(WorldChunkManager var0, Holder<GeneratorSettingBase> var1) {
        super(var0);
        this.settings = var1;
        this.globalFluidPicker = Suppliers.memoize(() -> ChunkGeneratorAbstract.createFluidPicker((GeneratorSettingBase)var1.value()));
    }

    private static Aquifer.a createFluidPicker(GeneratorSettingBase var0) {
        Aquifer.b var1 = new Aquifer.b(-54, Blocks.LAVA.defaultBlockState());
        int var2 = var0.seaLevel();
        Aquifer.b var3 = new Aquifer.b(var2, var0.defaultFluid());
        Aquifer.b var42 = new Aquifer.b(DimensionManager.MIN_Y * 2, Blocks.AIR.defaultBlockState());
        return (var4, var5, var6) -> {
            if (var5 < Math.min(-54, var2)) {
                return var1;
            }
            return var3;
        };
    }

    @Override
    public CompletableFuture<IChunkAccess> createBiomes(RandomState var0, Blender var1, StructureManager var2, IChunkAccess var3) {
        return CompletableFuture.supplyAsync(() -> {
            this.doCreateBiomes(var1, var0, var2, var3);
            return var3;
        }, SystemUtils.backgroundExecutor().forName("init_biomes"));
    }

    private void doCreateBiomes(Blender var0, RandomState var1, StructureManager var2, IChunkAccess var32) {
        NoiseChunk var4 = var32.getOrCreateNoiseChunk(var3 -> this.createNoiseChunk((IChunkAccess)var3, var2, var0, var1));
        BiomeResolver var5 = BelowZeroRetrogen.getBiomeResolver(var0.getBiomeResolver(this.biomeSource), var32);
        var32.fillBiomesFromNoise(var5, var4.cachedClimateSampler(var1.router(), this.settings.value().spawnTarget()));
    }

    private NoiseChunk createNoiseChunk(IChunkAccess var0, StructureManager var1, Blender var2, RandomState var3) {
        return NoiseChunk.forChunk(var0, var3, Beardifier.forStructuresInChunk(var1, var0.getPos()), this.settings.value(), this.globalFluidPicker.get(), var2);
    }

    @Override
    protected MapCodec<? extends ChunkGenerator> codec() {
        return CODEC;
    }

    public Holder<GeneratorSettingBase> generatorSettings() {
        return this.settings;
    }

    public boolean stable(ResourceKey<GeneratorSettingBase> var0) {
        return this.settings.is(var0);
    }

    @Override
    public int getBaseHeight(int var0, int var1, HeightMap.Type var2, LevelHeightAccessor var3, RandomState var4) {
        return this.iterateNoiseColumn(var3, var4, var0, var1, null, var2.isOpaque()).orElse(var3.getMinY());
    }

    @Override
    public BlockColumn getBaseColumn(int var0, int var1, LevelHeightAccessor var2, RandomState var3) {
        MutableObject var4 = new MutableObject();
        this.iterateNoiseColumn(var2, var3, var0, var1, (MutableObject<BlockColumn>)var4, null);
        return (BlockColumn)var4.getValue();
    }

    @Override
    public void addDebugScreenInfo(List<String> var0, RandomState var1, BlockPosition var2) {
        DecimalFormat var3 = new DecimalFormat("0.000");
        NoiseRouter var4 = var1.router();
        DensityFunction.e var5 = new DensityFunction.e(var2.getX(), var2.getY(), var2.getZ());
        double var6 = var4.ridges().compute(var5);
        var0.add("NoiseRouter T: " + var3.format(var4.temperature().compute(var5)) + " V: " + var3.format(var4.vegetation().compute(var5)) + " C: " + var3.format(var4.continents().compute(var5)) + " E: " + var3.format(var4.erosion().compute(var5)) + " D: " + var3.format(var4.depth().compute(var5)) + " W: " + var3.format(var6) + " PV: " + var3.format(NoiseRouterData.peaksAndValleys((float)var6)) + " AS: " + var3.format(var4.initialDensityWithoutJaggedness().compute(var5)) + " N: " + var3.format(var4.finalDensity().compute(var5)));
    }

    private OptionalInt iterateNoiseColumn(LevelHeightAccessor var0, RandomState var1, int var2, int var3, @Nullable MutableObject<BlockColumn> var4, @Nullable Predicate<IBlockData> var5) {
        IBlockData[] var11;
        NoiseSettings var6 = this.settings.value().noiseSettings().clampToHeightAccessor(var0);
        int var7 = var6.getCellHeight();
        int var8 = var6.minY();
        int var9 = MathHelper.floorDiv(var8, var7);
        int var10 = MathHelper.floorDiv(var6.height(), var7);
        if (var10 <= 0) {
            return OptionalInt.empty();
        }
        if (var4 == null) {
            var11 = null;
        } else {
            var11 = new IBlockData[var6.height()];
            var4.setValue((Object)new BlockColumn(var8, var11));
        }
        int var12 = var6.getCellWidth();
        int var13 = Math.floorDiv(var2, var12);
        int var14 = Math.floorDiv(var3, var12);
        int var15 = Math.floorMod(var2, var12);
        int var16 = Math.floorMod(var3, var12);
        int var17 = var13 * var12;
        int var18 = var14 * var12;
        double var19 = (double)var15 / (double)var12;
        double var21 = (double)var16 / (double)var12;
        NoiseChunk var23 = new NoiseChunk(1, var1, var17, var18, var6, DensityFunctions.b.INSTANCE, this.settings.value(), this.globalFluidPicker.get(), Blender.empty());
        var23.initializeForFirstCellX();
        var23.advanceCellX(0);
        for (int var24 = var10 - 1; var24 >= 0; --var24) {
            var23.selectCellYZ(var24, 0);
            for (int var25 = var7 - 1; var25 >= 0; --var25) {
                IBlockData var30;
                int var26 = (var9 + var24) * var7 + var25;
                double var27 = (double)var25 / (double)var7;
                var23.updateForY(var26, var27);
                var23.updateForX(var2, var19);
                var23.updateForZ(var3, var21);
                IBlockData var29 = var23.getInterpolatedState();
                IBlockData iBlockData = var30 = var29 == null ? this.settings.value().defaultBlock() : var29;
                if (var11 != null) {
                    int var31 = var24 * var7 + var25;
                    var11[var31] = var30;
                }
                if (var5 == null || !var5.test(var30)) continue;
                var23.stopInterpolation();
                return OptionalInt.of(var26 + 1);
            }
        }
        var23.stopInterpolation();
        return OptionalInt.empty();
    }

    @Override
    public void buildSurface(RegionLimitedWorldAccess var0, StructureManager var1, RandomState var2, IChunkAccess var3) {
        if (SharedConstants.debugVoidTerrain(var3.getPos())) {
            return;
        }
        WorldGenerationContext var4 = new WorldGenerationContext(this, var0);
        this.buildSurface(var3, var4, var2, var1, var0.getBiomeManager(), (IRegistry<BiomeBase>)var0.registryAccess().lookupOrThrow(Registries.BIOME), Blender.of(var0));
    }

    @VisibleForTesting
    public void buildSurface(IChunkAccess var0, WorldGenerationContext var1, RandomState var2, StructureManager var32, BiomeManager var4, IRegistry<BiomeBase> var5, Blender var6) {
        NoiseChunk var7 = var0.getOrCreateNoiseChunk(var3 -> this.createNoiseChunk((IChunkAccess)var3, var32, var6, var2));
        GeneratorSettingBase var8 = this.settings.value();
        var2.surfaceSystem().buildSurface(var2, var4, var5, var8.useLegacyRandomSource(), var1, var0, var7, var8.surfaceRule());
    }

    @Override
    public void applyCarvers(RegionLimitedWorldAccess var0, long var12, RandomState var32, BiomeManager var4, StructureManager var5, IChunkAccess var6) {
        BiomeManager var7 = var4.withDifferentSource((var1, var2, var3) -> this.biomeSource.getNoiseBiome(var1, var2, var3, var32.sampler()));
        SeededRandom var8 = new SeededRandom(new LegacyRandomSource(RandomSupport.generateUniqueSeed()));
        int var9 = 8;
        ChunkCoordIntPair var10 = var6.getPos();
        NoiseChunk var11 = var6.getOrCreateNoiseChunk(var3 -> this.createNoiseChunk((IChunkAccess)var3, var5, Blender.of(var0), var32));
        Aquifer var122 = var11.aquifer();
        CarvingContext var13 = new CarvingContext(this, var0.registryAccess(), var6.getHeightAccessorForGeneration(), var11, var32, this.settings.value().surfaceRule());
        CarvingMask var14 = ((ProtoChunk)var6).getOrCreateCarvingMask();
        for (int var15 = -8; var15 <= 8; ++var15) {
            for (int var16 = -8; var16 <= 8; ++var16) {
                ChunkCoordIntPair var17 = new ChunkCoordIntPair(var10.x + var15, var10.z + var16);
                IChunkAccess var18 = var0.getChunk(var17.x, var17.z);
                BiomeSettingsGeneration var19 = var18.carverBiome(() -> this.getBiomeGenerationSettings(this.biomeSource.getNoiseBiome(QuartPos.fromBlock(var17.getMinBlockX()), 0, QuartPos.fromBlock(var17.getMinBlockZ()), var32.sampler())));
                Iterable<Holder<WorldGenCarverWrapper<?>>> var20 = var19.getCarvers();
                int var21 = 0;
                for (Holder<WorldGenCarverWrapper<?>> var23 : var20) {
                    WorldGenCarverWrapper<?> var24 = var23.value();
                    var8.setLargeFeatureSeed(var12 + (long)var21, var17.x, var17.z);
                    if (var24.isStartChunk(var8)) {
                        var24.carve(var13, var6, var7::getBiome, var8, var122, var17, var14);
                    }
                    ++var21;
                }
            }
        }
    }

    @Override
    public CompletableFuture<IChunkAccess> fillFromNoise(Blender var0, RandomState var1, StructureManager var2, IChunkAccess var3) {
        NoiseSettings var4 = this.settings.value().noiseSettings().clampToHeightAccessor(var3.getHeightAccessorForGeneration());
        int var5 = var4.minY();
        int var6 = MathHelper.floorDiv(var5, var4.getCellHeight());
        int var7 = MathHelper.floorDiv(var4.height(), var4.getCellHeight());
        if (var7 <= 0) {
            return CompletableFuture.completedFuture(var3);
        }
        return CompletableFuture.supplyAsync(() -> {
            int var8 = var3.getSectionIndex(var7 * var4.getCellHeight() - 1 + var5);
            int var9 = var3.getSectionIndex(var5);
            HashSet var10 = Sets.newHashSet();
            for (int var11 = var8; var11 >= var9; --var11) {
                ChunkSection var12 = var3.getSection(var11);
                var12.acquire();
                var10.add(var12);
            }
            try {
                IChunkAccess iChunkAccess = this.doFill(var0, var2, var1, var3, var6, var7);
                return iChunkAccess;
            }
            finally {
                for (ChunkSection var13 : var10) {
                    var13.release();
                }
            }
        }, SystemUtils.backgroundExecutor().forName("wgen_fill_noise"));
    }

    private IChunkAccess doFill(Blender var0, StructureManager var1, RandomState var2, IChunkAccess var32, int var4, int var5) {
        NoiseChunk var6 = var32.getOrCreateNoiseChunk(var3 -> this.createNoiseChunk((IChunkAccess)var3, var1, var0, var2));
        HeightMap var7 = var32.getOrCreateHeightmapUnprimed(HeightMap.Type.OCEAN_FLOOR_WG);
        HeightMap var8 = var32.getOrCreateHeightmapUnprimed(HeightMap.Type.WORLD_SURFACE_WG);
        ChunkCoordIntPair var9 = var32.getPos();
        int var10 = var9.getMinBlockX();
        int var11 = var9.getMinBlockZ();
        Aquifer var12 = var6.aquifer();
        var6.initializeForFirstCellX();
        BlockPosition.MutableBlockPosition var13 = new BlockPosition.MutableBlockPosition();
        int var14 = var6.cellWidth();
        int var15 = var6.cellHeight();
        int var16 = 16 / var14;
        int var17 = 16 / var14;
        for (int var18 = 0; var18 < var16; ++var18) {
            var6.advanceCellX(var18);
            for (int var19 = 0; var19 < var17; ++var19) {
                int var20 = var32.getSectionsCount() - 1;
                ChunkSection var21 = var32.getSection(var20);
                for (int var22 = var5 - 1; var22 >= 0; --var22) {
                    var6.selectCellYZ(var22, var19);
                    for (int var23 = var15 - 1; var23 >= 0; --var23) {
                        int var24 = (var4 + var22) * var15 + var23;
                        int var25 = var24 & 0xF;
                        int var26 = var32.getSectionIndex(var24);
                        if (var20 != var26) {
                            var20 = var26;
                            var21 = var32.getSection(var26);
                        }
                        double var27 = (double)var23 / (double)var15;
                        var6.updateForY(var24, var27);
                        for (int var29 = 0; var29 < var14; ++var29) {
                            int var30 = var10 + var18 * var14 + var29;
                            int var31 = var30 & 0xF;
                            double var322 = (double)var29 / (double)var14;
                            var6.updateForX(var30, var322);
                            for (int var34 = 0; var34 < var14; ++var34) {
                                int var35 = var11 + var19 * var14 + var34;
                                int var36 = var35 & 0xF;
                                double var37 = (double)var34 / (double)var14;
                                var6.updateForZ(var35, var37);
                                IBlockData var39 = var6.getInterpolatedState();
                                if (var39 == null) {
                                    var39 = this.settings.value().defaultBlock();
                                }
                                if ((var39 = this.debugPreliminarySurfaceLevel(var6, var30, var24, var35, var39)) == AIR || SharedConstants.debugVoidTerrain(var32.getPos())) continue;
                                var21.setBlockState(var31, var25, var36, var39, false);
                                var7.update(var31, var24, var36, var39);
                                var8.update(var31, var24, var36, var39);
                                if (!var12.shouldScheduleFluidUpdate() || var39.getFluidState().isEmpty()) continue;
                                var13.set(var30, var24, var35);
                                var32.markPosForPostprocessing(var13);
                            }
                        }
                    }
                }
            }
            var6.swapSlices();
        }
        var6.stopInterpolation();
        return var32;
    }

    private IBlockData debugPreliminarySurfaceLevel(NoiseChunk var0, int var1, int var2, int var3, IBlockData var4) {
        return var4;
    }

    @Override
    public int getGenDepth() {
        return this.settings.value().noiseSettings().height();
    }

    @Override
    public int getSeaLevel() {
        return this.settings.value().seaLevel();
    }

    @Override
    public int getMinY() {
        return this.settings.value().noiseSettings().minY();
    }

    @Override
    public void spawnOriginalMobs(RegionLimitedWorldAccess var0) {
        if (this.settings.value().disableMobGeneration()) {
            return;
        }
        ChunkCoordIntPair var1 = var0.getCenter();
        Holder<BiomeBase> var2 = var0.getBiome(var1.getWorldPosition().atY(var0.getMaxY()));
        SeededRandom var3 = new SeededRandom(new LegacyRandomSource(RandomSupport.generateUniqueSeed()));
        var3.setDecorationSeed(var0.getSeed(), var1.getMinBlockX(), var1.getMinBlockZ());
        SpawnerCreature.spawnMobsForChunkGeneration(var0, var2, var1, var3);
    }
}

