/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;

public class LeveledPriorityQueue {
    private final int levelCount;
    private final LongLinkedOpenHashSet[] queues;
    private int firstQueuedLevel;

    public LeveledPriorityQueue(int var0, final int var1) {
        this.levelCount = var0;
        this.queues = new LongLinkedOpenHashSet[var0];
        for (int var2 = 0; var2 < var0; ++var2) {
            this.queues[var2] = new LongLinkedOpenHashSet(var1, 0.5f){

                protected void rehash(int var0) {
                    if (var0 > var1) {
                        super.rehash(var0);
                    }
                }
            };
        }
        this.firstQueuedLevel = var0;
    }

    public long removeFirstLong() {
        LongLinkedOpenHashSet var0 = this.queues[this.firstQueuedLevel];
        long var1 = var0.removeFirstLong();
        if (var0.isEmpty()) {
            this.checkFirstQueuedLevel(this.levelCount);
        }
        return var1;
    }

    public boolean isEmpty() {
        return this.firstQueuedLevel >= this.levelCount;
    }

    public void dequeue(long var0, int var2, int var3) {
        LongLinkedOpenHashSet var4 = this.queues[var2];
        var4.remove(var0);
        if (var4.isEmpty() && this.firstQueuedLevel == var2) {
            this.checkFirstQueuedLevel(var3);
        }
    }

    public void enqueue(long var0, int var2) {
        this.queues[var2].add(var0);
        if (this.firstQueuedLevel > var2) {
            this.firstQueuedLevel = var2;
        }
    }

    private void checkFirstQueuedLevel(int var0) {
        int var1 = this.firstQueuedLevel;
        this.firstQueuedLevel = var0;
        for (int var2 = var1 + 1; var2 < var0; ++var2) {
            if (this.queues[var2].isEmpty()) continue;
            this.firstQueuedLevel = var2;
            break;
        }
    }
}

