/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.pathfinder;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.minecraft.core.BlockPosition;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.level.ChunkCache;
import net.minecraft.world.level.block.BlockCampfire;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathDestination;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfindingContext;

public abstract class PathfinderAbstract {
    protected PathfindingContext currentContext;
    protected EntityInsentient mob;
    protected final Int2ObjectMap<PathPoint> nodes = new Int2ObjectOpenHashMap();
    protected int entityWidth;
    protected int entityHeight;
    protected int entityDepth;
    protected boolean canPassDoors = true;
    protected boolean canOpenDoors;
    protected boolean canFloat;
    protected boolean canWalkOverFences;

    public void prepare(ChunkCache var0, EntityInsentient var1) {
        this.currentContext = new PathfindingContext(var0, var1);
        this.mob = var1;
        this.nodes.clear();
        this.entityWidth = MathHelper.floor(var1.getBbWidth() + 1.0f);
        this.entityHeight = MathHelper.floor(var1.getBbHeight() + 1.0f);
        this.entityDepth = MathHelper.floor(var1.getBbWidth() + 1.0f);
    }

    public void done() {
        this.currentContext = null;
        this.mob = null;
    }

    protected PathPoint getNode(BlockPosition var0) {
        return this.getNode(var0.getX(), var0.getY(), var0.getZ());
    }

    protected PathPoint getNode(int var0, int var1, int var2) {
        return (PathPoint)this.nodes.computeIfAbsent(PathPoint.createHash(var0, var1, var2), var3 -> new PathPoint(var0, var1, var2));
    }

    public abstract PathPoint getStart();

    public abstract PathDestination getTarget(double var1, double var3, double var5);

    protected PathDestination getTargetNodeAt(double var0, double var2, double var4) {
        return new PathDestination(this.getNode(MathHelper.floor(var0), MathHelper.floor(var2), MathHelper.floor(var4)));
    }

    public abstract int getNeighbors(PathPoint[] var1, PathPoint var2);

    public abstract PathType getPathTypeOfMob(PathfindingContext var1, int var2, int var3, int var4, EntityInsentient var5);

    public abstract PathType getPathType(PathfindingContext var1, int var2, int var3, int var4);

    public PathType getPathType(EntityInsentient var0, BlockPosition var1) {
        return this.getPathType(new PathfindingContext(var0.level(), var0), var1.getX(), var1.getY(), var1.getZ());
    }

    public void setCanPassDoors(boolean var0) {
        this.canPassDoors = var0;
    }

    public void setCanOpenDoors(boolean var0) {
        this.canOpenDoors = var0;
    }

    public void setCanFloat(boolean var0) {
        this.canFloat = var0;
    }

    public void setCanWalkOverFences(boolean var0) {
        this.canWalkOverFences = var0;
    }

    public boolean canPassDoors() {
        return this.canPassDoors;
    }

    public boolean canOpenDoors() {
        return this.canOpenDoors;
    }

    public boolean canFloat() {
        return this.canFloat;
    }

    public boolean canWalkOverFences() {
        return this.canWalkOverFences;
    }

    public static boolean isBurningBlock(IBlockData var0) {
        return var0.is(TagsBlock.FIRE) || var0.is(Blocks.LAVA) || var0.is(Blocks.MAGMA_BLOCK) || BlockCampfire.isLitCampfire(var0) || var0.is(Blocks.LAVA_CAULDRON);
    }
}

