/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.SystemUtils;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.util.INamable;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class CopyComponentsFunction
extends LootItemFunctionConditional {
    public static final MapCodec<CopyComponentsFunction> CODEC = RecordCodecBuilder.mapCodec(var02 -> CopyComponentsFunction.commonFields(var02).and(var02.group((App)b.CODEC.fieldOf("source").forGetter(var0 -> var0.source), (App)DataComponentType.CODEC.listOf().optionalFieldOf("include").forGetter(var0 -> var0.include), (App)DataComponentType.CODEC.listOf().optionalFieldOf("exclude").forGetter(var0 -> var0.exclude))).apply((Applicative)var02, CopyComponentsFunction::new));
    private final b source;
    private final Optional<List<DataComponentType<?>>> include;
    private final Optional<List<DataComponentType<?>>> exclude;
    private final Predicate<DataComponentType<?>> bakedPredicate;

    CopyComponentsFunction(List<LootItemCondition> var0, b var13, Optional<List<DataComponentType<?>>> var2, Optional<List<DataComponentType<?>>> var3) {
        super(var0);
        this.source = var13;
        this.include = var2.map(List::copyOf);
        this.exclude = var3.map(List::copyOf);
        ArrayList var4 = new ArrayList(2);
        var3.ifPresent(var12 -> var4.add(var1 -> !var12.contains(var1)));
        var2.ifPresent(var1 -> var4.add(var1::contains));
        this.bakedPredicate = SystemUtils.allOf(var4);
    }

    public LootItemFunctionType<CopyComponentsFunction> getType() {
        return LootItemFunctions.COPY_COMPONENTS;
    }

    @Override
    public Set<ContextKey<?>> getReferencedContextParams() {
        return this.source.getReferencedContextParams();
    }

    @Override
    public ItemStack run(ItemStack var0, LootTableInfo var1) {
        DataComponentMap var2 = this.source.get(var1);
        var0.applyComponents(var2.filter(this.bakedPredicate));
        return var0;
    }

    public static a copyComponents(b var0) {
        return new a(var0);
    }

    public static final class b
    extends Enum<b>
    implements INamable {
        public static final /* enum */ b BLOCK_ENTITY = new b("block_entity");
        public static final Codec<b> CODEC;
        private final String name;
        private static final /* synthetic */ b[] d;

        public static b[] values() {
            return (b[])d.clone();
        }

        public static b valueOf(String var0) {
            return Enum.valueOf(b.class, var0);
        }

        private b(String var2) {
            this.name = var2;
        }

        public DataComponentMap get(LootTableInfo var0) {
            switch (this.ordinal()) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: 
            }
            TileEntity var1 = var0.getOptionalParameter(LootContextParameters.BLOCK_ENTITY);
            return var1 != null ? var1.collectComponents() : DataComponentMap.EMPTY;
        }

        public Set<ContextKey<?>> getReferencedContextParams() {
            switch (this.ordinal()) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: 
            }
            return Set.of(LootContextParameters.BLOCK_ENTITY);
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        private static /* synthetic */ b[] b() {
            return new b[]{BLOCK_ENTITY};
        }

        static {
            d = b.b();
            CODEC = INamable.fromValues(b::values);
        }
    }

    public static class a
    extends LootItemFunctionConditional.a<a> {
        private final b source;
        private Optional<ImmutableList.Builder<DataComponentType<?>>> include = Optional.empty();
        private Optional<ImmutableList.Builder<DataComponentType<?>>> exclude = Optional.empty();

        a(b var0) {
            this.source = var0;
        }

        public a include(DataComponentType<?> var0) {
            if (this.include.isEmpty()) {
                this.include = Optional.of(ImmutableList.builder());
            }
            this.include.get().add(var0);
            return this;
        }

        public a exclude(DataComponentType<?> var0) {
            if (this.exclude.isEmpty()) {
                this.exclude = Optional.of(ImmutableList.builder());
            }
            this.exclude.get().add(var0);
            return this;
        }

        @Override
        protected a getThis() {
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new CopyComponentsFunction(this.getConditions(), this.source, this.include.map(ImmutableList.Builder::build), this.exclude.map(ImmutableList.Builder::build));
        }

        @Override
        protected /* synthetic */ LootItemFunctionConditional.a getThis() {
            return this.getThis();
        }
    }
}

