/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.util.INamable;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.slf4j.Logger;

public class LootItemFunctionSetName
extends LootItemFunctionConditional {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final MapCodec<LootItemFunctionSetName> CODEC = RecordCodecBuilder.mapCodec(var02 -> LootItemFunctionSetName.commonFields(var02).and(var02.group((App)ComponentSerialization.CODEC.optionalFieldOf("name").forGetter(var0 -> var0.name), (App)LootTableInfo.EntityTarget.CODEC.optionalFieldOf("entity").forGetter(var0 -> var0.resolutionContext), (App)a.CODEC.optionalFieldOf("target", (Object)a.CUSTOM_NAME).forGetter(var0 -> var0.target))).apply((Applicative)var02, LootItemFunctionSetName::new));
    private final Optional<IChatBaseComponent> name;
    private final Optional<LootTableInfo.EntityTarget> resolutionContext;
    private final a target;

    private LootItemFunctionSetName(List<LootItemCondition> var0, Optional<IChatBaseComponent> var1, Optional<LootTableInfo.EntityTarget> var2, a var3) {
        super(var0);
        this.name = var1;
        this.resolutionContext = var2;
        this.target = var3;
    }

    public LootItemFunctionType<LootItemFunctionSetName> getType() {
        return LootItemFunctions.SET_NAME;
    }

    @Override
    public Set<ContextKey<?>> getReferencedContextParams() {
        return this.resolutionContext.map(var0 -> Set.of(var0.getParam())).orElse(Set.of());
    }

    public static UnaryOperator<IChatBaseComponent> createResolver(LootTableInfo var02, @Nullable LootTableInfo.EntityTarget var1) {
        Entity var22;
        if (var1 != null && (var22 = var02.getOptionalParameter(var1.getParam())) != null) {
            CommandListenerWrapper var3 = var22.createCommandSourceStackForNameResolution(var02.getLevel()).withPermission(2);
            return var2 -> {
                try {
                    return ChatComponentUtils.updateForEntity(var3, var2, var22, 0);
                }
                catch (CommandSyntaxException var3) {
                    LOGGER.warn("Failed to resolve text component", (Throwable)var3);
                    return var2;
                }
            };
        }
        return var0 -> var0;
    }

    @Override
    public ItemStack run(ItemStack var0, LootTableInfo var1) {
        this.name.ifPresent(var2 -> var0.set(this.target.component(), (IChatBaseComponent)LootItemFunctionSetName.createResolver(var1, this.resolutionContext.orElse(null)).apply((IChatBaseComponent)var2)));
        return var0;
    }

    public static LootItemFunctionConditional.a<?> setName(IChatBaseComponent var0, a var1) {
        return LootItemFunctionSetName.simpleBuilder(var2 -> new LootItemFunctionSetName((List<LootItemCondition>)var2, Optional.of(var0), Optional.empty(), var1));
    }

    public static LootItemFunctionConditional.a<?> setName(IChatBaseComponent var0, a var1, LootTableInfo.EntityTarget var2) {
        return LootItemFunctionSetName.simpleBuilder(var3 -> new LootItemFunctionSetName((List<LootItemCondition>)var3, Optional.of(var0), Optional.of(var2), var1));
    }

    public static final class a
    extends Enum<a>
    implements INamable {
        public static final /* enum */ a CUSTOM_NAME = new a("custom_name");
        public static final /* enum */ a ITEM_NAME = new a("item_name");
        public static final Codec<a> CODEC;
        private final String name;
        private static final /* synthetic */ a[] e;

        public static a[] values() {
            return (a[])e.clone();
        }

        public static a valueOf(String var0) {
            return Enum.valueOf(a.class, var0);
        }

        private a(String var2) {
            this.name = var2;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        public DataComponentType<IChatBaseComponent> component() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 1 -> DataComponents.ITEM_NAME;
                case 0 -> DataComponents.CUSTOM_NAME;
            };
        }

        private static /* synthetic */ a[] b() {
            return new a[]{CUSTOM_NAME, ITEM_NAME};
        }

        static {
            e = a.b();
            CODEC = INamable.fromEnum(a::values);
        }
    }
}

