/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.FurnaceRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.slf4j.Logger;

public class LootItemFunctionSmelt
extends LootItemFunctionConditional {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final MapCodec<LootItemFunctionSmelt> CODEC = RecordCodecBuilder.mapCodec(var0 -> LootItemFunctionSmelt.commonFields(var0).apply((Applicative)var0, LootItemFunctionSmelt::new));

    private LootItemFunctionSmelt(List<LootItemCondition> var0) {
        super(var0);
    }

    public LootItemFunctionType<LootItemFunctionSmelt> getType() {
        return LootItemFunctions.FURNACE_SMELT;
    }

    @Override
    public ItemStack run(ItemStack var0, LootTableInfo var1) {
        ItemStack var4;
        if (var0.isEmpty()) {
            return var0;
        }
        SingleRecipeInput var2 = new SingleRecipeInput(var0);
        Optional<RecipeHolder<FurnaceRecipe>> var3 = var1.getLevel().recipeAccess().getRecipeFor(Recipes.SMELTING, var2, var1.getLevel());
        if (var3.isPresent() && !(var4 = var3.get().value().assemble(var2, (HolderLookup.a)var1.getLevel().registryAccess())).isEmpty()) {
            return var4.copyWithCount(var0.getCount());
        }
        LOGGER.warn("Couldn't smelt {} because there is no smelting recipe", (Object)var0);
        return var0;
    }

    public static LootItemFunctionConditional.a<?> smelted() {
        return LootItemFunctionSmelt.simpleBuilder(LootItemFunctionSmelt::new);
    }
}

