/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.parameters;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.context.ContextKeySet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;

public class LootContextParameterSets {
    private static final BiMap<MinecraftKey, ContextKeySet> REGISTRY = HashBiMap.create();
    public static final Codec<ContextKeySet> CODEC = MinecraftKey.CODEC.comapFlatMap(var0 -> Optional.ofNullable((ContextKeySet)REGISTRY.get(var0)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "No parameter set exists with id: '" + String.valueOf(var0) + "'")), arg_0 -> REGISTRY.inverse().get(arg_0));
    public static final ContextKeySet EMPTY = LootContextParameterSets.register("empty", var0 -> {});
    public static final ContextKeySet CHEST = LootContextParameterSets.register("chest", var0 -> var0.required(LootContextParameters.ORIGIN).optional(LootContextParameters.THIS_ENTITY));
    public static final ContextKeySet COMMAND = LootContextParameterSets.register("command", var0 -> var0.required(LootContextParameters.ORIGIN).optional(LootContextParameters.THIS_ENTITY));
    public static final ContextKeySet SELECTOR = LootContextParameterSets.register("selector", var0 -> var0.required(LootContextParameters.ORIGIN).required(LootContextParameters.THIS_ENTITY));
    public static final ContextKeySet FISHING = LootContextParameterSets.register("fishing", var0 -> var0.required(LootContextParameters.ORIGIN).required(LootContextParameters.TOOL).optional(LootContextParameters.THIS_ENTITY));
    public static final ContextKeySet ENTITY = LootContextParameterSets.register("entity", var0 -> var0.required(LootContextParameters.THIS_ENTITY).required(LootContextParameters.ORIGIN).required(LootContextParameters.DAMAGE_SOURCE).optional(LootContextParameters.ATTACKING_ENTITY).optional(LootContextParameters.DIRECT_ATTACKING_ENTITY).optional(LootContextParameters.LAST_DAMAGE_PLAYER));
    public static final ContextKeySet EQUIPMENT = LootContextParameterSets.register("equipment", var0 -> var0.required(LootContextParameters.ORIGIN).required(LootContextParameters.THIS_ENTITY));
    public static final ContextKeySet ARCHAEOLOGY = LootContextParameterSets.register("archaeology", var0 -> var0.required(LootContextParameters.ORIGIN).required(LootContextParameters.THIS_ENTITY).required(LootContextParameters.TOOL));
    public static final ContextKeySet GIFT = LootContextParameterSets.register("gift", var0 -> var0.required(LootContextParameters.ORIGIN).required(LootContextParameters.THIS_ENTITY));
    public static final ContextKeySet PIGLIN_BARTER = LootContextParameterSets.register("barter", var0 -> var0.required(LootContextParameters.THIS_ENTITY));
    public static final ContextKeySet VAULT = LootContextParameterSets.register("vault", var0 -> var0.required(LootContextParameters.ORIGIN).optional(LootContextParameters.THIS_ENTITY).optional(LootContextParameters.TOOL));
    public static final ContextKeySet ADVANCEMENT_REWARD = LootContextParameterSets.register("advancement_reward", var0 -> var0.required(LootContextParameters.THIS_ENTITY).required(LootContextParameters.ORIGIN));
    public static final ContextKeySet ADVANCEMENT_ENTITY = LootContextParameterSets.register("advancement_entity", var0 -> var0.required(LootContextParameters.THIS_ENTITY).required(LootContextParameters.ORIGIN));
    public static final ContextKeySet ADVANCEMENT_LOCATION = LootContextParameterSets.register("advancement_location", var0 -> var0.required(LootContextParameters.THIS_ENTITY).required(LootContextParameters.ORIGIN).required(LootContextParameters.TOOL).required(LootContextParameters.BLOCK_STATE));
    public static final ContextKeySet BLOCK_USE = LootContextParameterSets.register("block_use", var0 -> var0.required(LootContextParameters.THIS_ENTITY).required(LootContextParameters.ORIGIN).required(LootContextParameters.BLOCK_STATE));
    public static final ContextKeySet ALL_PARAMS = LootContextParameterSets.register("generic", var0 -> var0.required(LootContextParameters.THIS_ENTITY).required(LootContextParameters.LAST_DAMAGE_PLAYER).required(LootContextParameters.DAMAGE_SOURCE).required(LootContextParameters.ATTACKING_ENTITY).required(LootContextParameters.DIRECT_ATTACKING_ENTITY).required(LootContextParameters.ORIGIN).required(LootContextParameters.BLOCK_STATE).required(LootContextParameters.BLOCK_ENTITY).required(LootContextParameters.TOOL).required(LootContextParameters.EXPLOSION_RADIUS));
    public static final ContextKeySet BLOCK = LootContextParameterSets.register("block", var0 -> var0.required(LootContextParameters.BLOCK_STATE).required(LootContextParameters.ORIGIN).required(LootContextParameters.TOOL).optional(LootContextParameters.THIS_ENTITY).optional(LootContextParameters.BLOCK_ENTITY).optional(LootContextParameters.EXPLOSION_RADIUS));
    public static final ContextKeySet SHEARING = LootContextParameterSets.register("shearing", var0 -> var0.required(LootContextParameters.ORIGIN).required(LootContextParameters.THIS_ENTITY).required(LootContextParameters.TOOL));
    public static final ContextKeySet ENCHANTED_DAMAGE = LootContextParameterSets.register("enchanted_damage", var0 -> var0.required(LootContextParameters.THIS_ENTITY).required(LootContextParameters.ENCHANTMENT_LEVEL).required(LootContextParameters.ORIGIN).required(LootContextParameters.DAMAGE_SOURCE).optional(LootContextParameters.DIRECT_ATTACKING_ENTITY).optional(LootContextParameters.ATTACKING_ENTITY));
    public static final ContextKeySet ENCHANTED_ITEM = LootContextParameterSets.register("enchanted_item", var0 -> var0.required(LootContextParameters.TOOL).required(LootContextParameters.ENCHANTMENT_LEVEL));
    public static final ContextKeySet ENCHANTED_LOCATION = LootContextParameterSets.register("enchanted_location", var0 -> var0.required(LootContextParameters.THIS_ENTITY).required(LootContextParameters.ENCHANTMENT_LEVEL).required(LootContextParameters.ORIGIN).required(LootContextParameters.ENCHANTMENT_ACTIVE));
    public static final ContextKeySet ENCHANTED_ENTITY = LootContextParameterSets.register("enchanted_entity", var0 -> var0.required(LootContextParameters.THIS_ENTITY).required(LootContextParameters.ENCHANTMENT_LEVEL).required(LootContextParameters.ORIGIN));
    public static final ContextKeySet HIT_BLOCK = LootContextParameterSets.register("hit_block", var0 -> var0.required(LootContextParameters.THIS_ENTITY).required(LootContextParameters.ENCHANTMENT_LEVEL).required(LootContextParameters.ORIGIN).required(LootContextParameters.BLOCK_STATE));

    private static ContextKeySet register(String var0, Consumer<ContextKeySet.a> var1) {
        ContextKeySet.a var2 = new ContextKeySet.a();
        var1.accept(var2);
        ContextKeySet var3 = var2.build();
        MinecraftKey var4 = MinecraftKey.withDefaultNamespace(var0);
        ContextKeySet var5 = (ContextKeySet)REGISTRY.put((Object)var4, (Object)var3);
        if (var5 != null) {
            throw new IllegalStateException("Loot table parameter set " + String.valueOf(var4) + " is already registered");
        }
        return var3;
    }
}

