/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.providers.nbt;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.CriterionConditionNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.providers.nbt.LootNbtProviderType;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProviders;

public class ContextNbtProvider
implements NbtProvider {
    private static final String BLOCK_ENTITY_ID = "block_entity";
    private static final a BLOCK_ENTITY_PROVIDER = new a(){

        @Override
        public NBTBase get(LootTableInfo var0) {
            TileEntity var1 = var0.getOptionalParameter(LootContextParameters.BLOCK_ENTITY);
            return var1 != null ? var1.saveWithFullMetadata(var1.getLevel().registryAccess()) : null;
        }

        @Override
        public String getId() {
            return ContextNbtProvider.BLOCK_ENTITY_ID;
        }

        @Override
        public Set<ContextKey<?>> getReferencedContextParams() {
            return Set.of(LootContextParameters.BLOCK_ENTITY);
        }
    };
    public static final ContextNbtProvider BLOCK_ENTITY = new ContextNbtProvider(BLOCK_ENTITY_PROVIDER);
    private static final Codec<a> GETTER_CODEC = Codec.STRING.xmap(var0 -> {
        if (var0.equals(BLOCK_ENTITY_ID)) {
            return BLOCK_ENTITY_PROVIDER;
        }
        LootTableInfo.EntityTarget var1 = LootTableInfo.EntityTarget.getByName(var0);
        return ContextNbtProvider.forEntity(var1);
    }, a::getId);
    public static final MapCodec<ContextNbtProvider> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)GETTER_CODEC.fieldOf("target").forGetter(var0 -> var0.getter)).apply((Applicative)var02, ContextNbtProvider::new));
    public static final Codec<ContextNbtProvider> INLINE_CODEC = GETTER_CODEC.xmap(ContextNbtProvider::new, var0 -> var0.getter);
    private final a getter;

    private static a forEntity(final LootTableInfo.EntityTarget var0) {
        return new a(){

            @Override
            @Nullable
            public NBTBase get(LootTableInfo var02) {
                Entity var1 = var02.getOptionalParameter(var0.getParam());
                return var1 != null ? CriterionConditionNBT.getEntityTagToCompare(var1) : null;
            }

            @Override
            public String getId() {
                return var0.name();
            }

            @Override
            public Set<ContextKey<?>> getReferencedContextParams() {
                return Set.of(var0.getParam());
            }
        };
    }

    private ContextNbtProvider(a var0) {
        this.getter = var0;
    }

    @Override
    public LootNbtProviderType getType() {
        return NbtProviders.CONTEXT;
    }

    @Override
    @Nullable
    public NBTBase get(LootTableInfo var0) {
        return this.getter.get(var0);
    }

    @Override
    public Set<ContextKey<?>> getReferencedContextParams() {
        return this.getter.getReferencedContextParams();
    }

    public static NbtProvider forContextEntity(LootTableInfo.EntityTarget var0) {
        return new ContextNbtProvider(ContextNbtProvider.forEntity(var0));
    }

    static interface a {
        @Nullable
        public NBTBase get(LootTableInfo var1);

        public String getId();

        public Set<ContextKey<?>> getReferencedContextParams();
    }
}

