/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionConditionEntity;
import net.minecraft.advancements.critereon.CriterionTriggerAbstract;
import net.minecraft.advancements.critereon.CriterionValidator;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;

public class DefaultBlockInteractionTrigger
extends CriterionTriggerAbstract<a> {
    @Override
    public Codec<a> codec() {
        return a.CODEC;
    }

    public void trigger(EntityPlayer var0, BlockPosition var12) {
        WorldServer var2 = var0.level();
        IBlockData var3 = var2.getBlockState(var12);
        LootParams var4 = new LootParams.a(var2).withParameter(LootContextParameters.ORIGIN, var12.getCenter()).withParameter(LootContextParameters.THIS_ENTITY, var0).withParameter(LootContextParameters.BLOCK_STATE, var3).create(LootContextParameterSets.BLOCK_USE);
        LootTableInfo var5 = new LootTableInfo.Builder(var4).create(Optional.empty());
        this.trigger(var0, (T var1) -> var1.matches(var5));
    }

    public record a(Optional<ContextAwarePredicate> player, Optional<ContextAwarePredicate> location) implements CriterionTriggerAbstract.a
    {
        public static final Codec<a> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)CriterionConditionEntity.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(a::player), (App)ContextAwarePredicate.CODEC.optionalFieldOf("location").forGetter(a::location)).apply((Applicative)var0, a::new));

        public boolean matches(LootTableInfo var0) {
            return this.location.isEmpty() || this.location.get().matches(var0);
        }

        @Override
        public void validate(CriterionValidator var0) {
            CriterionTriggerAbstract.a.super.validate(var0);
            this.location.ifPresent(var1 -> var0.validate((ContextAwarePredicate)var1, LootContextParameterSets.BLOCK_USE, "location"));
        }
    }
}

