/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

public class CursorPosition {
    public static final int TYPE_INSIDE = 0;
    public static final int TYPE_FACE = 1;
    public static final int TYPE_EDGE = 2;
    public static final int TYPE_CORNER = 3;
    private final int originX;
    private final int originY;
    private final int originZ;
    private final int width;
    private final int height;
    private final int depth;
    private final int end;
    private int index;
    private int x;
    private int y;
    private int z;

    public CursorPosition(int var0, int var1, int var2, int var3, int var4, int var5) {
        this.originX = var0;
        this.originY = var1;
        this.originZ = var2;
        this.width = var3 - var0 + 1;
        this.height = var4 - var1 + 1;
        this.depth = var5 - var2 + 1;
        this.end = this.width * this.height * this.depth;
    }

    public boolean advance() {
        if (this.index == this.end) {
            return false;
        }
        this.x = this.index % this.width;
        int var0 = this.index / this.width;
        this.y = var0 % this.height;
        this.z = var0 / this.height;
        ++this.index;
        return true;
    }

    public int nextX() {
        return this.originX + this.x;
    }

    public int nextY() {
        return this.originY + this.y;
    }

    public int nextZ() {
        return this.originZ + this.z;
    }

    public int getNextType() {
        int var0 = 0;
        if (this.x == 0 || this.x == this.width - 1) {
            ++var0;
        }
        if (this.y == 0 || this.y == this.height - 1) {
            ++var0;
        }
        if (this.z == 0 || this.z == this.depth - 1) {
            ++var0;
        }
        return var0;
    }
}

