/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.StringTagVisitor;
import net.minecraft.nbt.TagVisitor;
import net.minecraft.util.MathHelper;

public record NBTTagFloat(float value) implements NBTNumber
{
    private static final int SELF_SIZE_IN_BYTES = 12;
    public static final NBTTagFloat ZERO = new NBTTagFloat(0.0f);
    public static final NBTTagType<NBTTagFloat> TYPE = new NBTTagType.a<NBTTagFloat>(){

        @Override
        public NBTTagFloat load(DataInput var0, NBTReadLimiter var1) throws IOException {
            return NBTTagFloat.valueOf(1.readAccounted(var0, var1));
        }

        @Override
        public StreamTagVisitor.b parse(DataInput var0, StreamTagVisitor var1, NBTReadLimiter var2) throws IOException {
            return var1.visit(1.readAccounted(var0, var2));
        }

        private static float readAccounted(DataInput var0, NBTReadLimiter var1) throws IOException {
            var1.accountBytes(12L);
            return var0.readFloat();
        }

        @Override
        public int size() {
            return 4;
        }

        @Override
        public String getName() {
            return "FLOAT";
        }

        @Override
        public String getPrettyName() {
            return "TAG_Float";
        }

        @Override
        public /* synthetic */ NBTBase load(DataInput dataInput, NBTReadLimiter nBTReadLimiter) throws IOException {
            return this.load(dataInput, nBTReadLimiter);
        }
    };

    public static NBTTagFloat valueOf(float var0) {
        if (var0 == 0.0f) {
            return ZERO;
        }
        return new NBTTagFloat(var0);
    }

    @Override
    public void write(DataOutput var0) throws IOException {
        var0.writeFloat(this.value);
    }

    @Override
    public int sizeInBytes() {
        return 12;
    }

    @Override
    public byte getId() {
        return 5;
    }

    public NBTTagType<NBTTagFloat> getType() {
        return TYPE;
    }

    @Override
    public NBTTagFloat copy() {
        return this;
    }

    @Override
    public void accept(TagVisitor var0) {
        var0.visitFloat(this);
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public int intValue() {
        return MathHelper.floor(this.value);
    }

    @Override
    public short shortValue() {
        return (short)(MathHelper.floor(this.value) & 0xFFFF);
    }

    @Override
    public byte byteValue() {
        return (byte)(MathHelper.floor(this.value) & 0xFF);
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public Number box() {
        return Float.valueOf(this.value);
    }

    @Override
    public StreamTagVisitor.b accept(StreamTagVisitor var0) {
        return var0.visit(this.value);
    }

    @Override
    public String toString() {
        StringTagVisitor var0 = new StringTagVisitor();
        var0.visitFloat(this);
        return var0.build();
    }

    @Override
    public /* synthetic */ NBTBase copy() {
        return this.copy();
    }
}

