/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import java.time.Instant;
import javax.annotation.Nullable;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.LastSeenMessages;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayIn;

public record PacketPlayInChat(String message, Instant timeStamp, long salt, @Nullable MessageSignature signature, LastSeenMessages.b lastSeenMessages) implements Packet<PacketListenerPlayIn>
{
    public static final StreamCodec<PacketDataSerializer, PacketPlayInChat> STREAM_CODEC = Packet.codec(PacketPlayInChat::write, PacketPlayInChat::new);

    private PacketPlayInChat(PacketDataSerializer var0) {
        this(var0.readUtf(256), var0.readInstant(), var0.readLong(), var0.readNullable(MessageSignature::read), new LastSeenMessages.b(var0));
    }

    private void write(PacketDataSerializer var0) {
        var0.writeUtf(this.message, 256);
        var0.writeInstant(this.timeStamp);
        var0.writeLong(this.salt);
        var0.writeNullable(this.signature, MessageSignature::write);
        this.lastSeenMessages.write(var0);
    }

    @Override
    public PacketType<PacketPlayInChat> type() {
        return GamePacketTypes.SERVERBOUND_CHAT;
    }

    @Override
    public void handle(PacketListenerPlayIn var0) {
        var0.handleChat(this);
    }
}

