/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import javax.annotation.Nullable;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.World;

public class PacketPlayOutEntityStatus
implements Packet<PacketListenerPlayOut> {
    public static final StreamCodec<PacketDataSerializer, PacketPlayOutEntityStatus> STREAM_CODEC = Packet.codec(PacketPlayOutEntityStatus::write, PacketPlayOutEntityStatus::new);
    private final int entityId;
    private final byte eventId;

    public PacketPlayOutEntityStatus(Entity var0, byte var1) {
        this.entityId = var0.getId();
        this.eventId = var1;
    }

    private PacketPlayOutEntityStatus(PacketDataSerializer var0) {
        this.entityId = var0.readInt();
        this.eventId = var0.readByte();
    }

    private void write(PacketDataSerializer var0) {
        var0.writeInt(this.entityId);
        var0.writeByte(this.eventId);
    }

    @Override
    public PacketType<PacketPlayOutEntityStatus> type() {
        return GamePacketTypes.CLIENTBOUND_ENTITY_EVENT;
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleEntityEvent(this);
    }

    @Nullable
    public Entity getEntity(World var0) {
        return var0.getEntity(this.entityId);
    }

    public byte getEventId() {
        return this.eventId;
    }
}

