/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.login;

import java.security.PublicKey;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.login.LoginPacketTypes;
import net.minecraft.network.protocol.login.PacketLoginOutListener;
import net.minecraft.util.CryptographyException;
import net.minecraft.util.MinecraftEncryption;

public class PacketLoginOutEncryptionBegin
implements Packet<PacketLoginOutListener> {
    public static final StreamCodec<PacketDataSerializer, PacketLoginOutEncryptionBegin> STREAM_CODEC = Packet.codec(PacketLoginOutEncryptionBegin::write, PacketLoginOutEncryptionBegin::new);
    private final String serverId;
    private final byte[] publicKey;
    private final byte[] challenge;
    private final boolean shouldAuthenticate;

    public PacketLoginOutEncryptionBegin(String var0, byte[] var1, byte[] var2, boolean var3) {
        this.serverId = var0;
        this.publicKey = var1;
        this.challenge = var2;
        this.shouldAuthenticate = var3;
    }

    private PacketLoginOutEncryptionBegin(PacketDataSerializer var0) {
        this.serverId = var0.readUtf(20);
        this.publicKey = var0.readByteArray();
        this.challenge = var0.readByteArray();
        this.shouldAuthenticate = var0.readBoolean();
    }

    private void write(PacketDataSerializer var0) {
        var0.writeUtf(this.serverId);
        var0.writeByteArray(this.publicKey);
        var0.writeByteArray(this.challenge);
        var0.writeBoolean(this.shouldAuthenticate);
    }

    @Override
    public PacketType<PacketLoginOutEncryptionBegin> type() {
        return LoginPacketTypes.CLIENTBOUND_HELLO;
    }

    @Override
    public void handle(PacketLoginOutListener var0) {
        var0.handleHello(this);
    }

    public String getServerId() {
        return this.serverId;
    }

    public PublicKey getPublicKey() throws CryptographyException {
        return MinecraftEncryption.byteToPublicKey(this.publicKey);
    }

    public byte[] getChallenge() {
        return this.challenge;
    }

    public boolean shouldAuthenticate() {
        return this.shouldAuthenticate;
    }
}

