/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.IEntityAccess;
import net.minecraft.world.phys.AxisAlignedBB;

public interface ServerEntityGetter
extends IEntityAccess {
    public WorldServer getLevel();

    @Nullable
    default public EntityHuman getNearestPlayer(PathfinderTargetCondition var0, EntityLiving var1) {
        return this.getNearestEntity(this.players(), var0, var1, var1.getX(), var1.getY(), var1.getZ());
    }

    @Nullable
    default public EntityHuman getNearestPlayer(PathfinderTargetCondition var0, EntityLiving var1, double var2, double var4, double var6) {
        return this.getNearestEntity(this.players(), var0, var1, var2, var4, var6);
    }

    @Nullable
    default public EntityHuman getNearestPlayer(PathfinderTargetCondition var0, double var1, double var3, double var5) {
        return this.getNearestEntity(this.players(), var0, null, var1, var3, var5);
    }

    @Nullable
    default public <T extends EntityLiving> T getNearestEntity(Class<? extends T> var02, PathfinderTargetCondition var1, @Nullable EntityLiving var2, double var3, double var5, double var7, AxisAlignedBB var9) {
        return (T)this.getNearestEntity(this.getEntitiesOfClass(var02, var9, var0 -> true), var1, var2, var3, var5, var7);
    }

    @Nullable
    default public <T extends EntityLiving> T getNearestEntity(List<? extends T> var0, PathfinderTargetCondition var1, @Nullable EntityLiving var2, double var3, double var5, double var7) {
        double var9 = -1.0;
        EntityLiving var11 = null;
        for (EntityLiving var13 : var0) {
            if (!var1.test(this.getLevel(), var2, var13)) continue;
            double var14 = var13.distanceToSqr(var3, var5, var7);
            if (var9 != -1.0 && !(var14 < var9)) continue;
            var9 = var14;
            var11 = var13;
        }
        return (T)var11;
    }

    default public List<EntityHuman> getNearbyPlayers(PathfinderTargetCondition var0, EntityLiving var1, AxisAlignedBB var2) {
        ArrayList<EntityHuman> var3 = new ArrayList<EntityHuman>();
        for (EntityHuman entityHuman : this.players()) {
            if (!var2.contains(entityHuman.getX(), entityHuman.getY(), entityHuman.getZ()) || !var0.test(this.getLevel(), var1, entityHuman)) continue;
            var3.add(entityHuman);
        }
        return var3;
    }

    default public <T extends EntityLiving> List<T> getNearbyEntities(Class<T> var02, PathfinderTargetCondition var1, EntityLiving var2, AxisAlignedBB var3) {
        List<EntityLiving> var4 = this.getEntitiesOfClass(var02, var3, var0 -> true);
        ArrayList<EntityLiving> var5 = new ArrayList<EntityLiving>();
        for (EntityLiving var7 : var4) {
            if (!var1.test(this.getLevel(), var2, var7)) continue;
            var5.add(var7);
        }
        return var5;
    }
}

