/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.SectionPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.levelgen.HeightMap;

public class WorldProviderNormal {
    @Nullable
    protected static BlockPosition getOverworldRespawnPos(WorldServer var0, int var1, int var2) {
        int var5;
        boolean var3 = var0.dimensionType().hasCeiling();
        Chunk var4 = var0.getChunk(SectionPosition.blockToSectionCoord(var1), SectionPosition.blockToSectionCoord(var2));
        int n2 = var5 = var3 ? var0.getChunkSource().getGenerator().getSpawnHeight(var0) : var4.getHeight(HeightMap.Type.MOTION_BLOCKING, var1 & 0xF, var2 & 0xF);
        if (var5 < var0.getMinY()) {
            return null;
        }
        int var6 = var4.getHeight(HeightMap.Type.WORLD_SURFACE, var1 & 0xF, var2 & 0xF);
        if (var6 <= var5 && var6 > var4.getHeight(HeightMap.Type.OCEAN_FLOOR, var1 & 0xF, var2 & 0xF)) {
            return null;
        }
        BlockPosition.MutableBlockPosition var7 = new BlockPosition.MutableBlockPosition();
        for (int var8 = var5 + 1; var8 >= var0.getMinY(); --var8) {
            var7.set(var1, var8, var2);
            IBlockData var9 = var0.getBlockState(var7);
            if (!var9.getFluidState().isEmpty()) break;
            if (!Block.isFaceFull(var9.getCollisionShape(var0, var7), EnumDirection.UP)) continue;
            return ((BlockPosition)var7.above()).immutable();
        }
        return null;
    }

    @Nullable
    public static BlockPosition getSpawnPosInChunk(WorldServer var0, ChunkCoordIntPair var1) {
        if (SharedConstants.debugVoidTerrain(var1)) {
            return null;
        }
        for (int var2 = var1.getMinBlockX(); var2 <= var1.getMaxBlockX(); ++var2) {
            for (int var3 = var1.getMinBlockZ(); var3 <= var1.getMaxBlockZ(); ++var3) {
                BlockPosition var4 = WorldProviderNormal.getOverworldRespawnPos(var0, var2, var3);
                if (var4 == null) continue;
                return var4;
            }
        }
        return null;
    }
}

