/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.network.FilteredText;

public record Filterable<T>(T raw, Optional<T> filtered) {
    public static <T> Codec<Filterable<T>> codec(Codec<T> var0) {
        Codec var12 = RecordCodecBuilder.create(var1 -> var1.group((App)var0.fieldOf("raw").forGetter(Filterable::raw), (App)var0.optionalFieldOf("filtered").forGetter(Filterable::filtered)).apply((Applicative)var1, Filterable::new));
        Codec var2 = var0.xmap(Filterable::passThrough, Filterable::raw);
        return Codec.withAlternative((Codec)var12, (Codec)var2);
    }

    public static <B extends ByteBuf, T> StreamCodec<B, Filterable<T>> streamCodec(StreamCodec<B, T> var0) {
        return StreamCodec.composite(var0, Filterable::raw, var0.apply(ByteBufCodecs::optional), Filterable::filtered, Filterable::new);
    }

    public static <T> Filterable<T> passThrough(T var0) {
        return new Filterable<T>(var0, Optional.empty());
    }

    public static Filterable<String> from(FilteredText var0) {
        return new Filterable<String>(var0.raw(), var0.isFiltered() ? Optional.of(var0.filteredOrEmpty()) : Optional.empty());
    }

    public T get(boolean var0) {
        if (var0) {
            return this.filtered.orElse(this.raw);
        }
        return this.raw;
    }

    public <U> Filterable<U> map(Function<T, U> var0) {
        return new Filterable<U>(var0.apply(this.raw), this.filtered.map(var0));
    }

    public <U> Optional<Filterable<U>> resolve(Function<T, Optional<U>> var0) {
        Optional<U> var1 = var0.apply(this.raw);
        if (var1.isEmpty()) {
            return Optional.empty();
        }
        if (this.filtered.isPresent()) {
            Optional<U> var2 = var0.apply(this.filtered.get());
            if (var2.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(new Filterable<U>(var1.get(), var2));
        }
        return Optional.of(new Filterable<U>(var1.get(), Optional.empty()));
    }
}

