/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceKey;
import org.slf4j.Logger;

public interface ProblemReporter {
    public static final ProblemReporter DISCARDING = new ProblemReporter(){

        @Override
        public ProblemReporter forChild(f var0) {
            return this;
        }

        @Override
        public void report(g var0) {
        }
    };

    public ProblemReporter forChild(f var1);

    public void report(g var1);

    public static class j
    extends a
    implements AutoCloseable {
        private final Logger logger;

        public j(Logger var0) {
            this.logger = var0;
        }

        public j(f var0, Logger var1) {
            super(var0);
            this.logger = var1;
        }

        @Override
        public void close() {
            if (!this.isEmpty()) {
                this.logger.warn("[{}] Serialization errors:\n{}", (Object)this.logger.getName(), (Object)this.getTreeReport());
            }
        }
    }

    public static class net.minecraft.util.ProblemReporter$a
    implements ProblemReporter {
        public static final f EMPTY_ROOT = () -> "";
        @Nullable
        private final net.minecraft.util.ProblemReporter$a parent;
        private final f element;
        private final Set<a> problems;

        public net.minecraft.util.ProblemReporter$a() {
            this(EMPTY_ROOT);
        }

        public net.minecraft.util.ProblemReporter$a(f var0) {
            this.parent = null;
            this.problems = new LinkedHashSet<a>();
            this.element = var0;
        }

        private net.minecraft.util.ProblemReporter$a(net.minecraft.util.ProblemReporter$a var0, f var1) {
            this.problems = var0.problems;
            this.parent = var0;
            this.element = var1;
        }

        @Override
        public ProblemReporter forChild(f var0) {
            return new net.minecraft.util.ProblemReporter$a(this, var0);
        }

        @Override
        public void report(g var0) {
            this.problems.add(new a(this, var0));
        }

        public boolean isEmpty() {
            return this.problems.isEmpty();
        }

        public void forEach(BiConsumer<String, g> var0) {
            ArrayList<f> var1 = new ArrayList<f>();
            StringBuilder var2 = new StringBuilder();
            for (a var4 : this.problems) {
                net.minecraft.util.ProblemReporter$a var5 = var4.source;
                while (var5 != null) {
                    var1.add(var5.element);
                    var5 = var5.parent;
                }
                for (int var6 = var1.size() - 1; var6 >= 0; --var6) {
                    var2.append(((f)var1.get(var6)).get());
                }
                var0.accept(var2.toString(), var4.problem());
                var2.setLength(0);
                var1.clear();
            }
        }

        public String getReport() {
            HashMultimap var02 = HashMultimap.create();
            this.forEach((arg_0, arg_1) -> ((Multimap)var02).put(arg_0, arg_1));
            return var02.asMap().entrySet().stream().map(var0 -> " at " + (String)var0.getKey() + ": " + ((Collection)var0.getValue()).stream().map(g::description).collect(Collectors.joining("; "))).collect(Collectors.joining("\n"));
        }

        public String getTreeReport() {
            ArrayList<f> var0 = new ArrayList<f>();
            b var1 = new b(this.element);
            for (a var3 : this.problems) {
                net.minecraft.util.ProblemReporter$a var4 = var3.source;
                while (var4 != this) {
                    var0.add(var4.element);
                    var4 = var4.parent;
                }
                b var5 = var1;
                for (int var6 = var0.size() - 1; var6 >= 0; --var6) {
                    var5 = var5.child((f)var0.get(var6));
                }
                var0.clear();
                var5.problems.add(var3.problem);
            }
            return String.join((CharSequence)"\n", var1.getLines());
        }

        static final class a
        extends Record {
            final net.minecraft.util.ProblemReporter$a source;
            final g problem;

            a(net.minecraft.util.ProblemReporter$a var0, g var1) {
                this.source = var0;
                this.problem = var1;
            }

            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "source;problem", "source", "problem"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "source;problem", "source", "problem"}, this);
            }

            @Override
            public final boolean equals(Object var0) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "source;problem", "source", "problem"}, this, var0);
            }

            public net.minecraft.util.ProblemReporter$a source() {
                return this.source;
            }

            public g problem() {
                return this.problem;
            }
        }

        static final class b
        extends Record {
            private final f element;
            final List<g> problems;
            private final Map<f, b> children;

            public b(f var0) {
                this(var0, new ArrayList<g>(), new LinkedHashMap<f, b>());
            }

            private b(f var0, List<g> var1, Map<f, b> var2) {
                this.element = var0;
                this.problems = var1;
                this.children = var2;
            }

            public b child(f var0) {
                return this.children.computeIfAbsent(var0, b::new);
            }

            public List<String> getLines() {
                int var02 = this.problems.size();
                int var12 = this.children.size();
                if (var02 == 0 && var12 == 0) {
                    return List.of();
                }
                if (var02 == 0 && var12 == 1) {
                    ArrayList<String> var22 = new ArrayList<String>();
                    this.children.forEach((var1, var2) -> var22.addAll(var2.getLines()));
                    var22.set(0, this.element.get() + (String)var22.get(0));
                    return var22;
                }
                if (var02 == 1 && var12 == 0) {
                    return List.of(this.element.get() + ": " + this.problems.getFirst().description());
                }
                ArrayList<String> var23 = new ArrayList<String>();
                this.children.forEach((var1, var2) -> var23.addAll(var2.getLines()));
                var23.replaceAll(var0 -> "  " + var0);
                for (g var4 : this.problems) {
                    var23.add("  " + var4.description());
                }
                var23.addFirst(this.element.get() + ":");
                return var23;
            }

            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "element;problems;children", "element", "problems", "children"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "element;problems;children", "element", "problems", "children"}, this);
            }

            @Override
            public final boolean equals(Object var0) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "element;problems;children", "element", "problems", "children"}, this, var0);
            }

            public f element() {
                return this.element;
            }

            public List<g> problems() {
                return this.problems;
            }

            public Map<f, b> children() {
                return this.children;
            }
        }
    }

    public record b(ResourceKey<?> id) implements f
    {
        @Override
        public String get() {
            return "->{" + String.valueOf(this.id.location()) + "@" + String.valueOf(this.id.registry()) + "}";
        }
    }

    public record e(int index) implements f
    {
        @Override
        public String get() {
            return "[" + this.index + "]";
        }
    }

    public record d(String name, int index) implements f
    {
        @Override
        public String get() {
            return "." + this.name + "[" + this.index + "]";
        }
    }

    public record c(String name) implements f
    {
        @Override
        public String get() {
            return "." + this.name;
        }
    }

    public record h(ResourceKey<?> id) implements f
    {
        @Override
        public String get() {
            return "{" + String.valueOf(this.id.location()) + "@" + String.valueOf(this.id.registry()) + "}";
        }
    }

    public record i(String name) implements f
    {
        @Override
        public String get() {
            return this.name;
        }
    }

    @FunctionalInterface
    public static interface f {
        public String get();
    }

    public static interface g {
        public String description();
    }
}

