/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.LongStream;
import javax.annotation.Nullable;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import org.slf4j.Logger;

public class StructuresBecomeConfiguredFix
extends DataFix {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<String, a> CONVERSION_MAP = ImmutableMap.builder().put((Object)"mineshaft", (Object)a.biomeMapped(Map.of(List.of("minecraft:badlands", "minecraft:eroded_badlands", "minecraft:wooded_badlands"), "minecraft:mineshaft_mesa"), "minecraft:mineshaft")).put((Object)"shipwreck", (Object)a.biomeMapped(Map.of(List.of("minecraft:beach", "minecraft:snowy_beach"), "minecraft:shipwreck_beached"), "minecraft:shipwreck")).put((Object)"ocean_ruin", (Object)a.biomeMapped(Map.of(List.of("minecraft:warm_ocean", "minecraft:lukewarm_ocean", "minecraft:deep_lukewarm_ocean"), "minecraft:ocean_ruin_warm"), "minecraft:ocean_ruin_cold")).put((Object)"village", (Object)a.biomeMapped(Map.of(List.of("minecraft:desert"), "minecraft:village_desert", List.of("minecraft:savanna"), "minecraft:village_savanna", List.of("minecraft:snowy_plains"), "minecraft:village_snowy", List.of("minecraft:taiga"), "minecraft:village_taiga"), "minecraft:village_plains")).put((Object)"ruined_portal", (Object)a.biomeMapped(Map.of(List.of("minecraft:desert"), "minecraft:ruined_portal_desert", List.of("minecraft:badlands", "minecraft:eroded_badlands", "minecraft:wooded_badlands", "minecraft:windswept_hills", "minecraft:windswept_forest", "minecraft:windswept_gravelly_hills", "minecraft:savanna_plateau", "minecraft:windswept_savanna", "minecraft:stony_shore", "minecraft:meadow", "minecraft:frozen_peaks", "minecraft:jagged_peaks", "minecraft:stony_peaks", "minecraft:snowy_slopes"), "minecraft:ruined_portal_mountain", List.of("minecraft:bamboo_jungle", "minecraft:jungle", "minecraft:sparse_jungle"), "minecraft:ruined_portal_jungle", List.of("minecraft:deep_frozen_ocean", "minecraft:deep_cold_ocean", "minecraft:deep_ocean", "minecraft:deep_lukewarm_ocean", "minecraft:frozen_ocean", "minecraft:ocean", "minecraft:cold_ocean", "minecraft:lukewarm_ocean", "minecraft:warm_ocean"), "minecraft:ruined_portal_ocean"), "minecraft:ruined_portal")).put((Object)"pillager_outpost", (Object)a.trivial("minecraft:pillager_outpost")).put((Object)"mansion", (Object)a.trivial("minecraft:mansion")).put((Object)"jungle_pyramid", (Object)a.trivial("minecraft:jungle_pyramid")).put((Object)"desert_pyramid", (Object)a.trivial("minecraft:desert_pyramid")).put((Object)"igloo", (Object)a.trivial("minecraft:igloo")).put((Object)"swamp_hut", (Object)a.trivial("minecraft:swamp_hut")).put((Object)"stronghold", (Object)a.trivial("minecraft:stronghold")).put((Object)"monument", (Object)a.trivial("minecraft:monument")).put((Object)"fortress", (Object)a.trivial("minecraft:fortress")).put((Object)"endcity", (Object)a.trivial("minecraft:end_city")).put((Object)"buried_treasure", (Object)a.trivial("minecraft:buried_treasure")).put((Object)"nether_fossil", (Object)a.trivial("minecraft:nether_fossil")).put((Object)"bastion_remnant", (Object)a.trivial("minecraft:bastion_remnant")).build();

    public StructuresBecomeConfiguredFix(Schema var0) {
        super(var0, false);
    }

    protected TypeRewriteRule makeRule() {
        Type var0 = this.getInputSchema().getType(DataConverterTypes.CHUNK);
        Type var1 = this.getInputSchema().getType(DataConverterTypes.CHUNK);
        return this.writeFixAndRead("StucturesToConfiguredStructures", var0, var1, this::fix);
    }

    private Dynamic<?> fix(Dynamic<?> var0) {
        return var0.update("structures", var12 -> var12.update("starts", var1 -> this.updateStarts((Dynamic<?>)var1, var0)).update("References", var1 -> this.updateReferences((Dynamic<?>)var1, var0)));
    }

    private Dynamic<?> updateStarts(Dynamic<?> var0, Dynamic<?> var1) {
        Map<Dynamic, Dynamic> var2 = var0.getMapValues().result().orElse(Map.of());
        HashMap var32 = Maps.newHashMap();
        var2.forEach((var22, var3) -> {
            if (var3.get("id").asString("INVALID").equals("INVALID")) {
                return;
            }
            Dynamic<?> var4 = this.findUpdatedStructureType((Dynamic<?>)var22, var1);
            if (var4 == null) {
                LOGGER.warn("Encountered unknown structure in datafixer: " + var22.asString("<missing key>"));
                return;
            }
            var32.computeIfAbsent(var4, var2 -> var3.set("id", var4));
        });
        return var1.createMap((Map)var32);
    }

    private Dynamic<?> updateReferences(Dynamic<?> var0, Dynamic<?> var1) {
        Map<Dynamic, Dynamic> var2 = var0.getMapValues().result().orElse(Map.of());
        HashMap var32 = Maps.newHashMap();
        var2.forEach((var22, var3) -> {
            if (var3.asLongStream().count() == 0L) {
                return;
            }
            Dynamic<?> var4 = this.findUpdatedStructureType((Dynamic<?>)var22, var1);
            if (var4 == null) {
                LOGGER.warn("Encountered unknown structure in datafixer: " + var22.asString("<missing key>"));
                return;
            }
            var32.compute(var4, (var1, var2) -> {
                if (var2 == null) {
                    return var3;
                }
                return var3.createLongList(LongStream.concat(var2.asLongStream(), var3.asLongStream()));
            });
        });
        return var1.createMap((Map)var32);
    }

    @Nullable
    private Dynamic<?> findUpdatedStructureType(Dynamic<?> var0, Dynamic<?> var1) {
        Optional<String> var5;
        String var2 = var0.asString("UNKNOWN").toLowerCase(Locale.ROOT);
        a var3 = CONVERSION_MAP.get(var2);
        if (var3 == null) {
            return null;
        }
        String var4 = var3.fallback;
        if (!var3.biomeMapping().isEmpty() && (var5 = this.guessConfiguration(var1, var3)).isPresent()) {
            var4 = var5.get();
        }
        return var1.createString(var4);
    }

    private Optional<String> guessConfiguration(Dynamic<?> var0, a var1) {
        Object2IntArrayMap var2 = new Object2IntArrayMap();
        var0.get("sections").asList(Function.identity()).forEach(var22 -> var22.get("biomes").get("palette").asList(Function.identity()).forEach(var2 -> {
            String var3 = var1.biomeMapping().get(var2.asString(""));
            if (var3 != null) {
                var2.mergeInt((Object)var3, 1, Integer::sum);
            }
        }));
        return var2.object2IntEntrySet().stream().max(Comparator.comparingInt(Object2IntMap.Entry::getIntValue)).map(Map.Entry::getKey);
    }

    static final class a
    extends Record {
        private final Map<String, String> biomeMapping;
        final String fallback;

        private a(Map<String, String> var0, String var1) {
            this.biomeMapping = var0;
            this.fallback = var1;
        }

        public static a trivial(String var0) {
            return new a(Map.of(), var0);
        }

        public static a biomeMapped(Map<List<String>, String> var0, String var1) {
            return new a(a.unpack(var0), var1);
        }

        private static Map<String, String> unpack(Map<List<String>, String> var0) {
            ImmutableMap.Builder var1 = ImmutableMap.builder();
            for (Map.Entry<List<String>, String> var3 : var0.entrySet()) {
                var3.getKey().forEach(var2 -> var1.put(var2, (Object)((String)var3.getValue())));
            }
            return var1.build();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "biomeMapping;fallback", "biomeMapping", "fallback"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "biomeMapping;fallback", "biomeMapping", "fallback"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "biomeMapping;fallback", "biomeMapping", "fallback"}, this, var0);
        }

        public Map<String, String> biomeMapping() {
            return this.biomeMapping;
        }

        public String fallback() {
            return this.fallback;
        }
    }
}

