/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.RandomSequence;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.saveddata.PersistentBase;
import net.minecraft.world.level.saveddata.SavedDataType;

public class RandomSequences
extends PersistentBase {
    public static final SavedDataType<RandomSequences> TYPE = new SavedDataType<RandomSequences>("random_sequences", var0 -> new RandomSequences(var0.worldSeed()), var0 -> RandomSequences.codec(var0.worldSeed()), DataFixTypes.SAVED_DATA_RANDOM_SEQUENCES);
    private final long worldSeed;
    private int salt;
    private boolean includeWorldSeed = true;
    private boolean includeSequenceId = true;
    private final Map<MinecraftKey, RandomSequence> sequences = new Object2ObjectOpenHashMap();

    public RandomSequences(long var0) {
        this.worldSeed = var0;
    }

    private RandomSequences(long var0, int var2, boolean var3, boolean var4, Map<MinecraftKey, RandomSequence> var5) {
        this.worldSeed = var0;
        this.salt = var2;
        this.includeWorldSeed = var3;
        this.includeSequenceId = var4;
        this.sequences.putAll(var5);
    }

    public static Codec<RandomSequences> codec(long var0) {
        return RecordCodecBuilder.create(var2 -> var2.group((App)RecordCodecBuilder.point((Object)var0), (App)Codec.INT.fieldOf("salt").forGetter(var0 -> var0.salt), (App)Codec.BOOL.optionalFieldOf("include_world_seed", (Object)true).forGetter(var0 -> var0.includeWorldSeed), (App)Codec.BOOL.optionalFieldOf("include_sequence_id", (Object)true).forGetter(var0 -> var0.includeSequenceId), (App)Codec.unboundedMap(MinecraftKey.CODEC, RandomSequence.CODEC).fieldOf("sequences").forGetter(var0 -> var0.sequences)).apply((Applicative)var2, RandomSequences::new));
    }

    public RandomSource get(MinecraftKey var0) {
        RandomSource var1 = this.sequences.computeIfAbsent(var0, this::createSequence).random();
        return new a(var1);
    }

    private RandomSequence createSequence(MinecraftKey var0) {
        return this.createSequence(var0, this.salt, this.includeWorldSeed, this.includeSequenceId);
    }

    private RandomSequence createSequence(MinecraftKey var0, int var1, boolean var2, boolean var3) {
        long var4 = (var2 ? this.worldSeed : 0L) ^ (long)var1;
        return new RandomSequence(var4, var3 ? Optional.of(var0) : Optional.empty());
    }

    public void forAllSequences(BiConsumer<MinecraftKey, RandomSequence> var0) {
        this.sequences.forEach(var0);
    }

    public void setSeedDefaults(int var0, boolean var1, boolean var2) {
        this.salt = var0;
        this.includeWorldSeed = var1;
        this.includeSequenceId = var2;
    }

    public int clear() {
        int var0 = this.sequences.size();
        this.sequences.clear();
        return var0;
    }

    public void reset(MinecraftKey var0) {
        this.sequences.put(var0, this.createSequence(var0));
    }

    public void reset(MinecraftKey var0, int var1, boolean var2, boolean var3) {
        this.sequences.put(var0, this.createSequence(var0, var1, var2, var3));
    }

    class a
    implements RandomSource {
        private final RandomSource random;

        a(RandomSource var1) {
            this.random = var1;
        }

        @Override
        public RandomSource fork() {
            RandomSequences.this.setDirty();
            return this.random.fork();
        }

        @Override
        public PositionalRandomFactory forkPositional() {
            RandomSequences.this.setDirty();
            return this.random.forkPositional();
        }

        @Override
        public void setSeed(long var0) {
            RandomSequences.this.setDirty();
            this.random.setSeed(var0);
        }

        @Override
        public int nextInt() {
            RandomSequences.this.setDirty();
            return this.random.nextInt();
        }

        @Override
        public int nextInt(int var0) {
            RandomSequences.this.setDirty();
            return this.random.nextInt(var0);
        }

        @Override
        public long nextLong() {
            RandomSequences.this.setDirty();
            return this.random.nextLong();
        }

        @Override
        public boolean nextBoolean() {
            RandomSequences.this.setDirty();
            return this.random.nextBoolean();
        }

        @Override
        public float nextFloat() {
            RandomSequences.this.setDirty();
            return this.random.nextFloat();
        }

        @Override
        public double nextDouble() {
            RandomSequences.this.setDirty();
            return this.random.nextDouble();
        }

        @Override
        public double nextGaussian() {
            RandomSequences.this.setDirty();
            return this.random.nextGaussian();
        }

        public boolean equals(Object var0) {
            if (this == var0) {
                return true;
            }
            if (var0 instanceof a) {
                a var1 = (a)var0;
                return this.random.equals(var1.random);
            }
            return false;
        }
    }
}

