/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.DropChances;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EquipmentTable;
import net.minecraft.world.entity.EquipmentUser;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.Targeting;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerJump;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.control.EntityAIBodyControl;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSelector;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.sensing.EntitySenses;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemMonsterEgg;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.enchantment.providers.VanillaEnchantmentProviders;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.ticks.ContainerSingleItem;

public abstract class EntityInsentient
extends EntityLiving
implements EquipmentUser,
Leashable,
Targeting {
    private static final DataWatcherObject<Byte> DATA_MOB_FLAGS_ID = DataWatcher.defineId(EntityInsentient.class, DataWatcherRegistry.BYTE);
    private static final int MOB_FLAG_NO_AI = 1;
    private static final int MOB_FLAG_LEFTHANDED = 2;
    private static final int MOB_FLAG_AGGRESSIVE = 4;
    protected static final int PICKUP_REACH = 1;
    private static final BaseBlockPosition ITEM_PICKUP_REACH = new BaseBlockPosition(1, 0, 1);
    private static final List<EnumItemSlot> EQUIPMENT_POPULATION_ORDER = List.of(EnumItemSlot.HEAD, EnumItemSlot.CHEST, EnumItemSlot.LEGS, EnumItemSlot.FEET);
    public static final float MAX_WEARING_ARMOR_CHANCE = 0.15f;
    public static final float MAX_PICKUP_LOOT_CHANCE = 0.55f;
    public static final float MAX_ENCHANTED_ARMOR_CHANCE = 0.5f;
    public static final float MAX_ENCHANTED_WEAPON_CHANCE = 0.25f;
    public static final int UPDATE_GOAL_SELECTOR_EVERY_N_TICKS = 2;
    private static final double DEFAULT_ATTACK_REACH = Math.sqrt(2.04f) - (double)0.6f;
    private static final boolean DEFAULT_CAN_PICK_UP_LOOT = false;
    private static final boolean DEFAULT_PERSISTENCE_REQUIRED = false;
    private static final boolean DEFAULT_LEFT_HANDED = false;
    private static final boolean DEFAULT_NO_AI = false;
    protected static final MinecraftKey RANDOM_SPAWN_BONUS_ID = MinecraftKey.withDefaultNamespace("random_spawn_bonus");
    public static final String TAG_DROP_CHANCES = "drop_chances";
    public static final String TAG_LEFT_HANDED = "LeftHanded";
    public static final String TAG_CAN_PICK_UP_LOOT = "CanPickUpLoot";
    public static final String TAG_NO_AI = "NoAI";
    public int ambientSoundTime;
    protected int xpReward;
    protected ControllerLook lookControl;
    protected ControllerMove moveControl;
    protected ControllerJump jumpControl;
    private final EntityAIBodyControl bodyRotationControl;
    protected NavigationAbstract navigation;
    public PathfinderGoalSelector goalSelector;
    public PathfinderGoalSelector targetSelector;
    @Nullable
    private EntityLiving target;
    private final EntitySenses sensing;
    private DropChances dropChances = DropChances.DEFAULT;
    private boolean canPickUpLoot = false;
    private boolean persistenceRequired = false;
    private final Map<PathType, Float> pathfindingMalus = Maps.newEnumMap(PathType.class);
    public Optional<ResourceKey<LootTable>> lootTable = Optional.empty();
    public long lootTableSeed;
    @Nullable
    private Leashable.a leashData;
    private BlockPosition homePosition = BlockPosition.ZERO;
    private int homeRadius = -1;

    protected EntityInsentient(EntityTypes<? extends EntityInsentient> var0, World var1) {
        super((EntityTypes<? extends EntityLiving>)var0, var1);
        this.goalSelector = new PathfinderGoalSelector();
        this.targetSelector = new PathfinderGoalSelector();
        this.lookControl = new ControllerLook(this);
        this.moveControl = new ControllerMove(this);
        this.jumpControl = new ControllerJump(this);
        this.bodyRotationControl = this.createBodyControl();
        this.navigation = this.createNavigation(var1);
        this.sensing = new EntitySenses(this);
        if (var1 instanceof WorldServer) {
            this.registerGoals();
        }
    }

    protected void registerGoals() {
    }

    public static AttributeProvider.Builder createMobAttributes() {
        return EntityLiving.createLivingAttributes().add(GenericAttributes.FOLLOW_RANGE, 16.0);
    }

    protected NavigationAbstract createNavigation(World var0) {
        return new Navigation(this, var0);
    }

    protected boolean shouldPassengersInheritMalus() {
        return false;
    }

    public float getPathfindingMalus(PathType var0) {
        Object var2;
        Entity entity = this.getControlledVehicle();
        Object var1 = entity instanceof EntityInsentient && ((EntityInsentient)(var2 = (EntityInsentient)entity)).shouldPassengersInheritMalus() ? var2 : this;
        var2 = ((EntityInsentient)var1).pathfindingMalus.get((Object)var0);
        return var2 == null ? var0.getMalus() : ((Float)var2).floatValue();
    }

    public void setPathfindingMalus(PathType var0, float var1) {
        this.pathfindingMalus.put(var0, Float.valueOf(var1));
    }

    public void onPathfindingStart() {
    }

    public void onPathfindingDone() {
    }

    protected EntityAIBodyControl createBodyControl() {
        return new EntityAIBodyControl(this);
    }

    public ControllerLook getLookControl() {
        return this.lookControl;
    }

    public ControllerMove getMoveControl() {
        Entity entity = this.getControlledVehicle();
        if (entity instanceof EntityInsentient) {
            EntityInsentient var0 = (EntityInsentient)entity;
            return var0.getMoveControl();
        }
        return this.moveControl;
    }

    public ControllerJump getJumpControl() {
        return this.jumpControl;
    }

    public NavigationAbstract getNavigation() {
        Entity entity = this.getControlledVehicle();
        if (entity instanceof EntityInsentient) {
            EntityInsentient var0 = (EntityInsentient)entity;
            return var0.getNavigation();
        }
        return this.navigation;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public EntityLiving getControllingPassenger() {
        Entity var0 = this.getFirstPassenger();
        if (this.isNoAi()) return null;
        if (!(var0 instanceof EntityInsentient)) return null;
        EntityInsentient var1 = (EntityInsentient)var0;
        if (!var0.canControlVehicle()) return null;
        EntityInsentient entityInsentient = var1;
        return entityInsentient;
    }

    public EntitySenses getSensing() {
        return this.sensing;
    }

    @Override
    @Nullable
    public EntityLiving getTarget() {
        return this.target;
    }

    @Nullable
    protected final EntityLiving getTargetFromBrain() {
        return this.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null);
    }

    public void setTarget(@Nullable EntityLiving var0) {
        this.target = var0;
    }

    @Override
    public boolean canAttackType(EntityTypes<?> var0) {
        return var0 != EntityTypes.GHAST;
    }

    public boolean canFireProjectileWeapon(ItemProjectileWeapon var0) {
        return false;
    }

    public void ate() {
        this.gameEvent(GameEvent.EAT);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_MOB_FLAGS_ID, (byte)0);
    }

    public int getAmbientSoundInterval() {
        return 80;
    }

    public void playAmbientSound() {
        this.makeSound(this.getAmbientSound());
    }

    @Override
    public void baseTick() {
        super.baseTick();
        GameProfilerFiller var0 = Profiler.get();
        var0.push("mobBaseTick");
        if (this.isAlive() && this.random.nextInt(1000) < this.ambientSoundTime++) {
            this.resetAmbientSoundTime();
            this.playAmbientSound();
        }
        var0.pop();
    }

    @Override
    protected void playHurtSound(DamageSource var0) {
        this.resetAmbientSoundTime();
        super.playHurtSound(var0);
    }

    private void resetAmbientSoundTime() {
        this.ambientSoundTime = -this.getAmbientSoundInterval();
    }

    @Override
    protected int getBaseExperienceReward(WorldServer var0) {
        if (this.xpReward > 0) {
            int var1 = this.xpReward;
            for (EnumItemSlot var3 : EnumItemSlot.VALUES) {
                ItemStack var4;
                if (!var3.canIncreaseExperience() || (var4 = this.getItemBySlot(var3)).isEmpty() || !(this.dropChances.byEquipment(var3) <= 1.0f)) continue;
                var1 += 1 + this.random.nextInt(3);
            }
            return var1;
        }
        return this.xpReward;
    }

    public void spawnAnim() {
        if (this.level().isClientSide) {
            this.makePoofParticles();
        } else {
            this.level().broadcastEntityEvent(this, (byte)20);
        }
    }

    @Override
    public void handleEntityEvent(byte var0) {
        if (var0 == 20) {
            this.spawnAnim();
        } else {
            super.handleEntityEvent(var0);
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide && this.tickCount % 5 == 0) {
            this.updateControlFlags();
        }
    }

    protected void updateControlFlags() {
        boolean var0 = !(this.getControllingPassenger() instanceof EntityInsentient);
        boolean var1 = !(this.getVehicle() instanceof AbstractBoat);
        this.goalSelector.setControlFlag(PathfinderGoal.Type.MOVE, var0);
        this.goalSelector.setControlFlag(PathfinderGoal.Type.JUMP, var0 && var1);
        this.goalSelector.setControlFlag(PathfinderGoal.Type.LOOK, var0);
    }

    @Override
    protected void tickHeadTurn(float var0) {
        this.bodyRotationControl.clientTick();
    }

    @Nullable
    protected SoundEffect getAmbientSound() {
        return null;
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput var0) {
        super.addAdditionalSaveData(var0);
        var0.putBoolean(TAG_CAN_PICK_UP_LOOT, this.canPickUpLoot());
        var0.putBoolean("PersistenceRequired", this.persistenceRequired);
        if (!this.dropChances.equals(DropChances.DEFAULT)) {
            var0.store(TAG_DROP_CHANCES, DropChances.CODEC, this.dropChances);
        }
        this.writeLeashData(var0, this.leashData);
        if (this.hasHome()) {
            var0.putInt("home_radius", this.homeRadius);
            var0.store("home_pos", BlockPosition.CODEC, this.homePosition);
        }
        var0.putBoolean(TAG_LEFT_HANDED, this.isLeftHanded());
        this.lootTable.ifPresent(var1 -> var0.store("DeathLootTable", LootTable.KEY_CODEC, var1));
        if (this.lootTableSeed != 0L) {
            var0.putLong("DeathLootTableSeed", this.lootTableSeed);
        }
        if (this.isNoAi()) {
            var0.putBoolean(TAG_NO_AI, this.isNoAi());
        }
    }

    @Override
    protected void readAdditionalSaveData(ValueInput var0) {
        super.readAdditionalSaveData(var0);
        this.setCanPickUpLoot(var0.getBooleanOr(TAG_CAN_PICK_UP_LOOT, false));
        this.persistenceRequired = var0.getBooleanOr("PersistenceRequired", false);
        this.dropChances = var0.read(TAG_DROP_CHANCES, DropChances.CODEC).orElse(DropChances.DEFAULT);
        this.readLeashData(var0);
        this.homeRadius = var0.getIntOr("home_radius", -1);
        if (this.homeRadius >= 0) {
            this.homePosition = var0.read("home_pos", BlockPosition.CODEC).orElse(BlockPosition.ZERO);
        }
        this.setLeftHanded(var0.getBooleanOr(TAG_LEFT_HANDED, false));
        this.lootTable = var0.read("DeathLootTable", LootTable.KEY_CODEC);
        this.lootTableSeed = var0.getLongOr("DeathLootTableSeed", 0L);
        this.setNoAi(var0.getBooleanOr(TAG_NO_AI, false));
    }

    @Override
    protected void dropFromLootTable(WorldServer var0, DamageSource var1, boolean var2) {
        super.dropFromLootTable(var0, var1, var2);
        this.lootTable = Optional.empty();
    }

    @Override
    public final Optional<ResourceKey<LootTable>> getLootTable() {
        if (this.lootTable.isPresent()) {
            return this.lootTable;
        }
        return super.getLootTable();
    }

    @Override
    public long getLootTableSeed() {
        return this.lootTableSeed;
    }

    public void setZza(float var0) {
        this.zza = var0;
    }

    public void setYya(float var0) {
        this.yya = var0;
    }

    public void setXxa(float var0) {
        this.xxa = var0;
    }

    @Override
    public void setSpeed(float var0) {
        super.setSpeed(var0);
        this.setZza(var0);
    }

    public void stopInPlace() {
        this.getNavigation().stop();
        this.setXxa(0.0f);
        this.setYya(0.0f);
        this.setSpeed(0.0f);
        this.setDeltaMovement(0.0, 0.0, 0.0);
        this.resetAngularLeashMomentum();
    }

    @Override
    public void aiStep() {
        super.aiStep();
        GameProfilerFiller var0 = Profiler.get();
        var0.push("looting");
        World world = this.level();
        if (world instanceof WorldServer) {
            WorldServer var1 = (WorldServer)world;
            if (this.canPickUpLoot() && this.isAlive() && !this.dead && var1.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                BaseBlockPosition var2 = this.getPickupReach();
                List<EntityItem> var3 = this.level().getEntitiesOfClass(EntityItem.class, this.getBoundingBox().inflate(var2.getX(), var2.getY(), var2.getZ()));
                for (EntityItem var5 : var3) {
                    if (var5.isRemoved() || var5.getItem().isEmpty() || var5.hasPickUpDelay() || !this.wantsToPickUp(var1, var5.getItem())) continue;
                    this.pickUpItem(var1, var5);
                }
            }
        }
        var0.pop();
    }

    protected BaseBlockPosition getPickupReach() {
        return ITEM_PICKUP_REACH;
    }

    protected void pickUpItem(WorldServer var0, EntityItem var1) {
        ItemStack var2 = var1.getItem();
        ItemStack var3 = this.equipItemIfPossible(var0, var2.copy());
        if (!var3.isEmpty()) {
            this.onItemPickup(var1);
            this.take(var1, var3.getCount());
            var2.shrink(var3.getCount());
            if (var2.isEmpty()) {
                var1.discard();
            }
        }
    }

    public ItemStack equipItemIfPossible(WorldServer var0, ItemStack var1) {
        EnumItemSlot var2 = this.getEquipmentSlotForItem(var1);
        if (!this.isEquippableInSlot(var1, var2)) {
            return ItemStack.EMPTY;
        }
        ItemStack var3 = this.getItemBySlot(var2);
        boolean var4 = this.canReplaceCurrentItem(var1, var3, var2);
        if (var2.isArmor() && !var4) {
            var2 = EnumItemSlot.MAINHAND;
            var3 = this.getItemBySlot(var2);
            var4 = var3.isEmpty();
        }
        if (var4 && this.canHoldItem(var1)) {
            double var5 = this.dropChances.byEquipment(var2);
            if (!var3.isEmpty() && (double)Math.max(this.random.nextFloat() - 0.1f, 0.0f) < var5) {
                this.spawnAtLocation(var0, var3);
            }
            ItemStack var7 = var2.limit(var1);
            this.setItemSlotAndDropWhenKilled(var2, var7);
            return var7;
        }
        return ItemStack.EMPTY;
    }

    protected void setItemSlotAndDropWhenKilled(EnumItemSlot var0, ItemStack var1) {
        this.setItemSlot(var0, var1);
        this.setGuaranteedDrop(var0);
        this.persistenceRequired = true;
    }

    protected boolean canShearEquipment(EntityHuman var0) {
        return !this.isVehicle();
    }

    public void setGuaranteedDrop(EnumItemSlot var0) {
        this.dropChances = this.dropChances.withGuaranteedDrop(var0);
    }

    protected boolean canReplaceCurrentItem(ItemStack var0, ItemStack var1, EnumItemSlot var2) {
        if (var1.isEmpty()) {
            return true;
        }
        if (var2.isArmor()) {
            return this.compareArmor(var0, var1, var2);
        }
        if (var2 == EnumItemSlot.MAINHAND) {
            return this.compareWeapons(var0, var1, var2);
        }
        return false;
    }

    private boolean compareArmor(ItemStack var0, ItemStack var1, EnumItemSlot var2) {
        if (EnchantmentManager.has(var1, EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE)) {
            return false;
        }
        double var3 = this.getApproximateAttributeWith(var0, GenericAttributes.ARMOR, var2);
        double var5 = this.getApproximateAttributeWith(var1, GenericAttributes.ARMOR, var2);
        double var7 = this.getApproximateAttributeWith(var0, GenericAttributes.ARMOR_TOUGHNESS, var2);
        double var9 = this.getApproximateAttributeWith(var1, GenericAttributes.ARMOR_TOUGHNESS, var2);
        if (var3 != var5) {
            return var3 > var5;
        }
        if (var7 != var9) {
            return var7 > var9;
        }
        return this.canReplaceEqualItem(var0, var1);
    }

    private boolean compareWeapons(ItemStack var0, ItemStack var1, EnumItemSlot var2) {
        double var6;
        double var4;
        TagKey<Item> var3 = this.getPreferredWeaponType();
        if (var3 != null) {
            if (var1.is(var3) && !var0.is(var3)) {
                return false;
            }
            if (!var1.is(var3) && var0.is(var3)) {
                return true;
            }
        }
        if ((var4 = this.getApproximateAttributeWith(var0, GenericAttributes.ATTACK_DAMAGE, var2)) != (var6 = this.getApproximateAttributeWith(var1, GenericAttributes.ATTACK_DAMAGE, var2))) {
            return var4 > var6;
        }
        return this.canReplaceEqualItem(var0, var1);
    }

    private double getApproximateAttributeWith(ItemStack var0, Holder<AttributeBase> var1, EnumItemSlot var2) {
        double var3 = this.getAttributes().hasAttribute(var1) ? this.getAttributeBaseValue(var1) : 0.0;
        ItemAttributeModifiers var5 = var0.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, ItemAttributeModifiers.EMPTY);
        return var5.compute(var3, var2);
    }

    public boolean canReplaceEqualItem(ItemStack var0, ItemStack var1) {
        int var5;
        Set<Object2IntMap.Entry<Holder<Enchantment>>> var2 = var1.getOrDefault(DataComponents.ENCHANTMENTS, ItemEnchantments.EMPTY).entrySet();
        Set<Object2IntMap.Entry<Holder<Enchantment>>> var3 = var0.getOrDefault(DataComponents.ENCHANTMENTS, ItemEnchantments.EMPTY).entrySet();
        if (var3.size() != var2.size()) {
            return var3.size() > var2.size();
        }
        int var4 = var0.getDamageValue();
        if (var4 != (var5 = var1.getDamageValue())) {
            return var4 < var5;
        }
        return var0.has(DataComponents.CUSTOM_NAME) && !var1.has(DataComponents.CUSTOM_NAME);
    }

    public boolean canHoldItem(ItemStack var0) {
        return true;
    }

    public boolean wantsToPickUp(WorldServer var0, ItemStack var1) {
        return this.canHoldItem(var1);
    }

    @Nullable
    public TagKey<Item> getPreferredWeaponType() {
        return null;
    }

    public boolean removeWhenFarAway(double var0) {
        return true;
    }

    public boolean requiresCustomPersistence() {
        return this.isPassenger();
    }

    protected boolean shouldDespawnInPeaceful() {
        return false;
    }

    @Override
    public void checkDespawn() {
        if (this.level().getDifficulty() == EnumDifficulty.PEACEFUL && this.shouldDespawnInPeaceful()) {
            this.discard();
            return;
        }
        if (this.isPersistenceRequired() || this.requiresCustomPersistence()) {
            this.noActionTime = 0;
            return;
        }
        EntityHuman var0 = this.level().getNearestPlayer(this, -1.0);
        if (var0 != null) {
            int var3;
            int var4;
            double var1 = var0.distanceToSqr(this);
            if (var1 > (double)(var4 = (var3 = this.getType().getCategory().getDespawnDistance()) * var3) && this.removeWhenFarAway(var1)) {
                this.discard();
            }
            int var5 = this.getType().getCategory().getNoDespawnDistance();
            int var6 = var5 * var5;
            if (this.noActionTime > 600 && this.random.nextInt(800) == 0 && var1 > (double)var6 && this.removeWhenFarAway(var1)) {
                this.discard();
            } else if (var1 < (double)var6) {
                this.noActionTime = 0;
            }
        }
    }

    @Override
    protected final void serverAiStep() {
        ++this.noActionTime;
        GameProfilerFiller var0 = Profiler.get();
        var0.push("sensing");
        this.sensing.tick();
        var0.pop();
        int var1 = this.tickCount + this.getId();
        if (var1 % 2 == 0 || this.tickCount <= 1) {
            var0.push("targetSelector");
            this.targetSelector.tick();
            var0.pop();
            var0.push("goalSelector");
            this.goalSelector.tick();
            var0.pop();
        } else {
            var0.push("targetSelector");
            this.targetSelector.tickRunningGoals(false);
            var0.pop();
            var0.push("goalSelector");
            this.goalSelector.tickRunningGoals(false);
            var0.pop();
        }
        var0.push("navigation");
        this.navigation.tick();
        var0.pop();
        var0.push("mob tick");
        this.customServerAiStep((WorldServer)this.level());
        var0.pop();
        var0.push("controls");
        var0.push("move");
        this.moveControl.tick();
        var0.popPush("look");
        this.lookControl.tick();
        var0.popPush("jump");
        this.jumpControl.tick();
        var0.pop();
        var0.pop();
        this.sendDebugPackets();
    }

    protected void sendDebugPackets() {
        PacketDebug.sendGoalSelector(this.level(), this, this.goalSelector);
    }

    protected void customServerAiStep(WorldServer var0) {
    }

    public int getMaxHeadXRot() {
        return 40;
    }

    public int getMaxHeadYRot() {
        return 75;
    }

    protected void clampHeadRotationToBody() {
        float var0 = this.getMaxHeadYRot();
        float var1 = this.getYHeadRot();
        float var2 = MathHelper.wrapDegrees(this.yBodyRot - var1);
        float var3 = MathHelper.clamp(MathHelper.wrapDegrees(this.yBodyRot - var1), -var0, var0);
        float var4 = var1 + var2 - var3;
        this.setYHeadRot(var4);
    }

    public int getHeadRotSpeed() {
        return 10;
    }

    public void lookAt(Entity var0, float var1, float var2) {
        double var5;
        double var3 = var0.getX() - this.getX();
        double var7 = var0.getZ() - this.getZ();
        if (var0 instanceof EntityLiving) {
            EntityLiving var9 = (EntityLiving)var0;
            var5 = var9.getEyeY() - this.getEyeY();
        } else {
            var5 = (var0.getBoundingBox().minY + var0.getBoundingBox().maxY) / 2.0 - this.getEyeY();
        }
        double var9 = Math.sqrt(var3 * var3 + var7 * var7);
        float var11 = (float)(MathHelper.atan2(var7, var3) * 57.2957763671875) - 90.0f;
        float var12 = (float)(-(MathHelper.atan2(var5, var9) * 57.2957763671875));
        this.setXRot(this.rotlerp(this.getXRot(), var12, var2));
        this.setYRot(this.rotlerp(this.getYRot(), var11, var1));
    }

    private float rotlerp(float var0, float var1, float var2) {
        float var3 = MathHelper.wrapDegrees(var1 - var0);
        if (var3 > var2) {
            var3 = var2;
        }
        if (var3 < -var2) {
            var3 = -var2;
        }
        return var0 + var3;
    }

    public static boolean checkMobSpawnRules(EntityTypes<? extends EntityInsentient> var0, GeneratorAccess var1, EntitySpawnReason var2, BlockPosition var3, RandomSource var4) {
        BlockPosition var5 = var3.below();
        return EntitySpawnReason.isSpawner(var2) || var1.getBlockState(var5).isValidSpawn(var1, var5, var0);
    }

    public boolean checkSpawnRules(GeneratorAccess var0, EntitySpawnReason var1) {
        return true;
    }

    public boolean checkSpawnObstruction(IWorldReader var0) {
        return !var0.containsAnyLiquid(this.getBoundingBox()) && var0.isUnobstructed(this);
    }

    public int getMaxSpawnClusterSize() {
        return 4;
    }

    public boolean isMaxGroupSizeReached(int var0) {
        return false;
    }

    @Override
    public int getMaxFallDistance() {
        if (this.getTarget() == null) {
            return this.getComfortableFallDistance(0.0f);
        }
        int var0 = (int)(this.getHealth() - this.getMaxHealth() * 0.33f);
        if ((var0 -= (3 - this.level().getDifficulty().getId()) * 4) < 0) {
            var0 = 0;
        }
        return this.getComfortableFallDistance(var0);
    }

    public ItemStack getBodyArmorItem() {
        return this.getItemBySlot(EnumItemSlot.BODY);
    }

    public boolean isSaddled() {
        return this.hasValidEquippableItemForSlot(EnumItemSlot.SADDLE);
    }

    public boolean isWearingBodyArmor() {
        return this.hasValidEquippableItemForSlot(EnumItemSlot.BODY);
    }

    private boolean hasValidEquippableItemForSlot(EnumItemSlot var0) {
        return this.hasItemInSlot(var0) && this.isEquippableInSlot(this.getItemBySlot(var0), var0);
    }

    public void setBodyArmorItem(ItemStack var0) {
        this.setItemSlotAndDropWhenKilled(EnumItemSlot.BODY, var0);
    }

    public IInventory createEquipmentSlotContainer(final EnumItemSlot var0) {
        return new ContainerSingleItem(){

            @Override
            public ItemStack getTheItem() {
                return EntityInsentient.this.getItemBySlot(var0);
            }

            @Override
            public void setTheItem(ItemStack var02) {
                EntityInsentient.this.setItemSlot(var0, var02);
                if (!var02.isEmpty()) {
                    EntityInsentient.this.setGuaranteedDrop(var0);
                    EntityInsentient.this.setPersistenceRequired();
                }
            }

            @Override
            public void setChanged() {
            }

            @Override
            public boolean stillValid(EntityHuman var02) {
                return var02.getVehicle() == EntityInsentient.this || var02.canInteractWithEntity(EntityInsentient.this, 4.0);
            }
        };
    }

    @Override
    protected void dropCustomDeathLoot(WorldServer var0, DamageSource var1, boolean var2) {
        super.dropCustomDeathLoot(var0, var1, var2);
        for (EnumItemSlot var4 : EnumItemSlot.VALUES) {
            ItemStack var5 = this.getItemBySlot(var4);
            float var6 = this.dropChances.byEquipment(var4);
            if (var6 == 0.0f) continue;
            boolean var7 = this.dropChances.isPreserved(var4);
            Object object = var1.getEntity();
            if (object instanceof EntityLiving) {
                EntityLiving var8 = (EntityLiving)object;
                object = this.level();
                if (object instanceof WorldServer) {
                    WorldServer var9 = (WorldServer)object;
                    var6 = EnchantmentManager.processEquipmentDropChance(var9, var8, var1, var6);
                }
            }
            if (var5.isEmpty() || EnchantmentManager.has(var5, EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP) || !var2 && !var7 || !(this.random.nextFloat() < var6)) continue;
            if (!var7 && var5.isDamageableItem()) {
                var5.setDamageValue(var5.getMaxDamage() - this.random.nextInt(1 + this.random.nextInt(Math.max(var5.getMaxDamage() - 3, 1))));
            }
            this.spawnAtLocation(var0, var5);
            this.setItemSlot(var4, ItemStack.EMPTY);
        }
    }

    public DropChances getDropChances() {
        return this.dropChances;
    }

    public void dropPreservedEquipment(WorldServer var02) {
        this.dropPreservedEquipment(var02, var0 -> true);
    }

    public Set<EnumItemSlot> dropPreservedEquipment(WorldServer var0, Predicate<ItemStack> var1) {
        HashSet<EnumItemSlot> var2 = new HashSet<EnumItemSlot>();
        for (EnumItemSlot var4 : EnumItemSlot.VALUES) {
            ItemStack var5 = this.getItemBySlot(var4);
            if (var5.isEmpty()) continue;
            if (!var1.test(var5)) {
                var2.add(var4);
                continue;
            }
            if (!this.dropChances.isPreserved(var4)) continue;
            this.setItemSlot(var4, ItemStack.EMPTY);
            this.spawnAtLocation(var0, var5);
        }
        return var2;
    }

    private LootParams createEquipmentParams(WorldServer var0) {
        return new LootParams.a(var0).withParameter(LootContextParameters.ORIGIN, this.position()).withParameter(LootContextParameters.THIS_ENTITY, this).create(LootContextParameterSets.EQUIPMENT);
    }

    public void equip(EquipmentTable var0) {
        this.equip(var0.lootTable(), var0.slotDropChances());
    }

    public void equip(ResourceKey<LootTable> var0, Map<EnumItemSlot, Float> var1) {
        World world = this.level();
        if (world instanceof WorldServer) {
            WorldServer var2 = (WorldServer)world;
            this.equip(var0, this.createEquipmentParams(var2), var1);
        }
    }

    protected void populateDefaultEquipmentSlots(RandomSource var0, DifficultyDamageScaler var1) {
        if (var0.nextFloat() < 0.15f * var1.getSpecialMultiplier()) {
            float var3;
            int var2 = var0.nextInt(2);
            float f2 = var3 = this.level().getDifficulty() == EnumDifficulty.HARD ? 0.1f : 0.25f;
            if (var0.nextFloat() < 0.095f) {
                ++var2;
            }
            if (var0.nextFloat() < 0.095f) {
                ++var2;
            }
            if (var0.nextFloat() < 0.095f) {
                ++var2;
            }
            boolean var4 = true;
            for (EnumItemSlot var6 : EQUIPMENT_POPULATION_ORDER) {
                Item var8;
                ItemStack var7 = this.getItemBySlot(var6);
                if (!var4 && var0.nextFloat() < var3) break;
                var4 = false;
                if (!var7.isEmpty() || (var8 = EntityInsentient.getEquipmentForSlot(var6, var2)) == null) continue;
                this.setItemSlot(var6, new ItemStack(var8));
            }
        }
    }

    @Nullable
    public static Item getEquipmentForSlot(EnumItemSlot var0, int var1) {
        switch (var0) {
            case HEAD: {
                if (var1 == 0) {
                    return Items.LEATHER_HELMET;
                }
                if (var1 == 1) {
                    return Items.GOLDEN_HELMET;
                }
                if (var1 == 2) {
                    return Items.CHAINMAIL_HELMET;
                }
                if (var1 == 3) {
                    return Items.IRON_HELMET;
                }
                if (var1 == 4) {
                    return Items.DIAMOND_HELMET;
                }
            }
            case CHEST: {
                if (var1 == 0) {
                    return Items.LEATHER_CHESTPLATE;
                }
                if (var1 == 1) {
                    return Items.GOLDEN_CHESTPLATE;
                }
                if (var1 == 2) {
                    return Items.CHAINMAIL_CHESTPLATE;
                }
                if (var1 == 3) {
                    return Items.IRON_CHESTPLATE;
                }
                if (var1 == 4) {
                    return Items.DIAMOND_CHESTPLATE;
                }
            }
            case LEGS: {
                if (var1 == 0) {
                    return Items.LEATHER_LEGGINGS;
                }
                if (var1 == 1) {
                    return Items.GOLDEN_LEGGINGS;
                }
                if (var1 == 2) {
                    return Items.CHAINMAIL_LEGGINGS;
                }
                if (var1 == 3) {
                    return Items.IRON_LEGGINGS;
                }
                if (var1 == 4) {
                    return Items.DIAMOND_LEGGINGS;
                }
            }
            case FEET: {
                if (var1 == 0) {
                    return Items.LEATHER_BOOTS;
                }
                if (var1 == 1) {
                    return Items.GOLDEN_BOOTS;
                }
                if (var1 == 2) {
                    return Items.CHAINMAIL_BOOTS;
                }
                if (var1 == 3) {
                    return Items.IRON_BOOTS;
                }
                if (var1 != 4) break;
                return Items.DIAMOND_BOOTS;
            }
        }
        return null;
    }

    protected void populateDefaultEquipmentEnchantments(WorldAccess var0, RandomSource var1, DifficultyDamageScaler var2) {
        this.enchantSpawnedWeapon(var0, var1, var2);
        for (EnumItemSlot var4 : EnumItemSlot.VALUES) {
            if (var4.getType() != EnumItemSlot.Function.HUMANOID_ARMOR) continue;
            this.enchantSpawnedArmor(var0, var1, var4, var2);
        }
    }

    protected void enchantSpawnedWeapon(WorldAccess var0, RandomSource var1, DifficultyDamageScaler var2) {
        this.enchantSpawnedEquipment(var0, EnumItemSlot.MAINHAND, var1, 0.25f, var2);
    }

    protected void enchantSpawnedArmor(WorldAccess var0, RandomSource var1, EnumItemSlot var2, DifficultyDamageScaler var3) {
        this.enchantSpawnedEquipment(var0, var2, var1, 0.5f, var3);
    }

    private void enchantSpawnedEquipment(WorldAccess var0, EnumItemSlot var1, RandomSource var2, float var3, DifficultyDamageScaler var4) {
        ItemStack var5 = this.getItemBySlot(var1);
        if (!var5.isEmpty() && var2.nextFloat() < var3 * var4.getSpecialMultiplier()) {
            EnchantmentManager.enchantItemFromProvider(var5, var0.registryAccess(), VanillaEnchantmentProviders.MOB_SPAWN_EQUIPMENT, var4, var2);
            this.setItemSlot(var1, var5);
        }
    }

    @Nullable
    public GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EntitySpawnReason var2, @Nullable GroupDataEntity var3) {
        RandomSource var4 = var0.getRandom();
        AttributeModifiable var5 = Objects.requireNonNull(this.getAttribute(GenericAttributes.FOLLOW_RANGE));
        if (!var5.hasModifier(RANDOM_SPAWN_BONUS_ID)) {
            var5.addPermanentModifier(new AttributeModifier(RANDOM_SPAWN_BONUS_ID, var4.triangle(0.0, 0.11485000000000001), AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        }
        this.setLeftHanded(var4.nextFloat() < 0.05f);
        return var3;
    }

    public void setPersistenceRequired() {
        this.persistenceRequired = true;
    }

    @Override
    public void setDropChance(EnumItemSlot var0, float var1) {
        this.dropChances = this.dropChances.withEquipmentChance(var0, var1);
    }

    @Override
    public boolean canPickUpLoot() {
        return this.canPickUpLoot;
    }

    public void setCanPickUpLoot(boolean var0) {
        this.canPickUpLoot = var0;
    }

    @Override
    protected boolean canDispenserEquipIntoSlot(EnumItemSlot var0) {
        return this.canPickUpLoot();
    }

    public boolean isPersistenceRequired() {
        return this.persistenceRequired;
    }

    @Override
    public final EnumInteractionResult interact(EntityHuman var0, EnumHand var1) {
        if (!this.isAlive()) {
            return EnumInteractionResult.PASS;
        }
        EnumInteractionResult var2 = this.checkAndHandleImportantInteractions(var0, var1);
        if (var2.consumesAction()) {
            this.gameEvent(GameEvent.ENTITY_INTERACT, var0);
            return var2;
        }
        EnumInteractionResult var3 = super.interact(var0, var1);
        if (var3 != EnumInteractionResult.PASS) {
            return var3;
        }
        var2 = this.mobInteract(var0, var1);
        if (var2.consumesAction()) {
            this.gameEvent(GameEvent.ENTITY_INTERACT, var0);
            return var2;
        }
        return EnumInteractionResult.PASS;
    }

    private EnumInteractionResult checkAndHandleImportantInteractions(EntityHuman var0, EnumHand var12) {
        Object var3;
        ItemStack var2 = var0.getItemInHand(var12);
        if (var2.is(Items.NAME_TAG) && (var3 = var2.interactLivingEntity(var0, this, var12)).consumesAction()) {
            return var3;
        }
        if (var2.getItem() instanceof ItemMonsterEgg) {
            if (this.level() instanceof WorldServer) {
                var3 = (ItemMonsterEgg)var2.getItem();
                Optional<EntityInsentient> var4 = ((ItemMonsterEgg)var3).spawnOffspringFromSpawnEgg(var0, this, this.getType(), (WorldServer)this.level(), this.position(), var2);
                var4.ifPresent(var1 -> this.onOffspringSpawnedFromEgg(var0, (EntityInsentient)var1));
                if (var4.isEmpty()) {
                    return EnumInteractionResult.PASS;
                }
            }
            return EnumInteractionResult.SUCCESS_SERVER;
        }
        return EnumInteractionResult.PASS;
    }

    protected void onOffspringSpawnedFromEgg(EntityHuman var0, EntityInsentient var1) {
    }

    protected EnumInteractionResult mobInteract(EntityHuman var0, EnumHand var1) {
        return EnumInteractionResult.PASS;
    }

    public boolean isWithinHome() {
        return this.isWithinHome(this.blockPosition());
    }

    public boolean isWithinHome(BlockPosition var0) {
        if (this.homeRadius == -1) {
            return true;
        }
        return this.homePosition.distSqr(var0) < (double)(this.homeRadius * this.homeRadius);
    }

    public boolean isWithinHome(Vec3D var0) {
        if (this.homeRadius == -1) {
            return true;
        }
        return this.homePosition.distToCenterSqr(var0) < (double)(this.homeRadius * this.homeRadius);
    }

    public void setHomeTo(BlockPosition var0, int var1) {
        this.homePosition = var0;
        this.homeRadius = var1;
    }

    public BlockPosition getHomePosition() {
        return this.homePosition;
    }

    public int getHomeRadius() {
        return this.homeRadius;
    }

    public void clearHome() {
        this.homeRadius = -1;
    }

    public boolean hasHome() {
        return this.homeRadius != -1;
    }

    @Nullable
    public <T extends EntityInsentient> T convertTo(EntityTypes<T> var0, ConversionParams var1, EntitySpawnReason var2, ConversionParams.a<T> var3) {
        if (this.isRemoved()) {
            return null;
        }
        EntityInsentient var4 = (EntityInsentient)var0.create(this.level(), var2);
        if (var4 == null) {
            return null;
        }
        var1.type().convert(this, var4, var1);
        var3.finalizeConversion(var4);
        World world = this.level();
        if (world instanceof WorldServer) {
            WorldServer var5 = (WorldServer)world;
            var5.addFreshEntity(var4);
        }
        if (var1.type().shouldDiscardAfterConversion()) {
            this.discard();
        }
        return (T)var4;
    }

    @Nullable
    public <T extends EntityInsentient> T convertTo(EntityTypes<T> var0, ConversionParams var1, ConversionParams.a<T> var2) {
        return this.convertTo(var0, var1, EntitySpawnReason.CONVERSION, var2);
    }

    @Override
    @Nullable
    public Leashable.a getLeashData() {
        return this.leashData;
    }

    private void resetAngularLeashMomentum() {
        if (this.leashData != null) {
            this.leashData.angularMomentum = 0.0;
        }
    }

    @Override
    public void setLeashData(@Nullable Leashable.a var0) {
        this.leashData = var0;
    }

    @Override
    public void onLeashRemoved() {
        if (this.getLeashData() == null) {
            this.clearHome();
        }
    }

    @Override
    public void leashTooFarBehaviour() {
        Leashable.super.leashTooFarBehaviour();
        this.goalSelector.disableControlFlag(PathfinderGoal.Type.MOVE);
    }

    @Override
    public boolean canBeLeashed() {
        return !(this instanceof IMonster);
    }

    @Override
    public boolean startRiding(Entity var0, boolean var1) {
        boolean var2 = super.startRiding(var0, var1);
        if (var2 && this.isLeashed()) {
            this.dropLeash();
        }
        return var2;
    }

    @Override
    public boolean isEffectiveAi() {
        return super.isEffectiveAi() && !this.isNoAi();
    }

    public void setNoAi(boolean var0) {
        byte var1 = this.entityData.get(DATA_MOB_FLAGS_ID);
        this.entityData.set(DATA_MOB_FLAGS_ID, var0 ? (byte)(var1 | 1) : (byte)(var1 & 0xFFFFFFFE));
    }

    public void setLeftHanded(boolean var0) {
        byte var1 = this.entityData.get(DATA_MOB_FLAGS_ID);
        this.entityData.set(DATA_MOB_FLAGS_ID, var0 ? (byte)(var1 | 2) : (byte)(var1 & 0xFFFFFFFD));
    }

    public void setAggressive(boolean var0) {
        byte var1 = this.entityData.get(DATA_MOB_FLAGS_ID);
        this.entityData.set(DATA_MOB_FLAGS_ID, var0 ? (byte)(var1 | 4) : (byte)(var1 & 0xFFFFFFFB));
    }

    public boolean isNoAi() {
        return (this.entityData.get(DATA_MOB_FLAGS_ID) & 1) != 0;
    }

    public boolean isLeftHanded() {
        return (this.entityData.get(DATA_MOB_FLAGS_ID) & 2) != 0;
    }

    public boolean isAggressive() {
        return (this.entityData.get(DATA_MOB_FLAGS_ID) & 4) != 0;
    }

    public void setBaby(boolean var0) {
    }

    @Override
    public EnumMainHand getMainArm() {
        return this.isLeftHanded() ? EnumMainHand.LEFT : EnumMainHand.RIGHT;
    }

    public boolean isWithinMeleeAttackRange(EntityLiving var0) {
        return this.getAttackBoundingBox().intersects(var0.getHitbox());
    }

    protected AxisAlignedBB getAttackBoundingBox() {
        AxisAlignedBB var0;
        Entity var1 = this.getVehicle();
        if (var1 != null) {
            AxisAlignedBB var2 = var1.getBoundingBox();
            AxisAlignedBB var3 = this.getBoundingBox();
            var0 = new AxisAlignedBB(Math.min(var3.minX, var2.minX), var3.minY, Math.min(var3.minZ, var2.minZ), Math.max(var3.maxX, var2.maxX), var3.maxY, Math.max(var3.maxZ, var2.maxZ));
        } else {
            var0 = this.getBoundingBox();
        }
        return var0.inflate(DEFAULT_ATTACK_REACH, 0.0, DEFAULT_ATTACK_REACH);
    }

    @Override
    public boolean doHurtTarget(WorldServer var0, Entity var1) {
        boolean var5;
        float var2 = (float)this.getAttributeValue(GenericAttributes.ATTACK_DAMAGE);
        ItemStack var3 = this.getWeaponItem();
        DamageSource var4 = Optional.ofNullable(var3.getItem().getDamageSource(this)).orElse(this.damageSources().mobAttack(this));
        var2 = EnchantmentManager.modifyDamage(var0, var3, var1, var4, var2);
        if (var5 = var1.hurtServer(var0, var4, var2 += var3.getItem().getAttackDamageBonus(var1, var2, var4))) {
            EntityLiving var7;
            float var6 = this.getKnockback(var1, var4);
            if (var6 > 0.0f && var1 instanceof EntityLiving) {
                var7 = (EntityLiving)var1;
                var7.knockback(var6 * 0.5f, MathHelper.sin(this.getYRot() * ((float)Math.PI / 180)), -MathHelper.cos(this.getYRot() * ((float)Math.PI / 180)));
                this.setDeltaMovement(this.getDeltaMovement().multiply(0.6, 1.0, 0.6));
            }
            if (var1 instanceof EntityLiving) {
                var7 = (EntityLiving)var1;
                var3.hurtEnemy(var7, this);
            }
            EnchantmentManager.doPostAttackEffects(var0, var1, var4);
            this.setLastHurtMob(var1);
            this.playAttackSound();
        }
        return var5;
    }

    protected void playAttackSound() {
    }

    protected boolean isSunBurnTick() {
        if (this.level().isBrightOutside() && !this.level().isClientSide) {
            boolean var2;
            float var0 = this.getLightLevelDependentMagicValue();
            BlockPosition var1 = BlockPosition.containing(this.getX(), this.getEyeY(), this.getZ());
            boolean bl = var2 = this.isInWaterOrRain() || this.isInPowderSnow || this.wasInPowderSnow;
            if (var0 > 0.5f && this.random.nextFloat() * 30.0f < (var0 - 0.4f) * 2.0f && !var2 && this.level().canSeeSky(var1)) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void jumpInLiquid(TagKey<FluidType> var0) {
        if (this.getNavigation().canFloat()) {
            super.jumpInLiquid(var0);
        } else {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.3, 0.0));
        }
    }

    @VisibleForTesting
    public void removeFreeWill() {
        this.removeAllGoals(var0 -> true);
        this.getBrain().removeAllBehaviors();
    }

    public void removeAllGoals(Predicate<PathfinderGoal> var0) {
        this.goalSelector.removeAllGoals(var0);
    }

    @Override
    protected void removeAfterChangingDimensions() {
        super.removeAfterChangingDimensions();
        for (EnumItemSlot var1 : EnumItemSlot.VALUES) {
            ItemStack var2 = this.getItemBySlot(var1);
            if (var2.isEmpty()) continue;
            var2.setCount(0);
        }
    }

    @Override
    @Nullable
    public ItemStack getPickResult() {
        ItemMonsterEgg var0 = ItemMonsterEgg.byId(this.getType());
        if (var0 == null) {
            return null;
        }
        return new ItemStack(var0);
    }

    @Override
    protected void onAttributeUpdated(Holder<AttributeBase> var0) {
        super.onAttributeUpdated(var0);
        if (var0.is(GenericAttributes.FOLLOW_RANGE) || var0.is(GenericAttributes.TEMPT_RANGE)) {
            this.getNavigation().updatePathfinderMaxVisitedNodes();
        }
    }
}

