/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.decoration.EntityLeash;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;

public interface Leashable {
    public static final String LEASH_TAG = "leash";
    public static final double LEASH_TOO_FAR_DIST = 12.0;
    public static final double LEASH_ELASTIC_DIST = 6.0;
    public static final double MAXIMUM_ALLOWED_LEASHED_DIST = 16.0;
    public static final Vec3D AXIS_SPECIFIC_ELASTICITY = new Vec3D(0.8, 0.2, 0.8);
    public static final float SPRING_DAMPENING = 0.7f;
    public static final double TORSIONAL_ELASTICITY = 10.0;
    public static final double STIFFNESS = 0.11;
    public static final List<Vec3D> ENTITY_ATTACHMENT_POINT = ImmutableList.of((Object)new Vec3D(0.0, 0.5, 0.5));
    public static final List<Vec3D> LEASHER_ATTACHMENT_POINT = ImmutableList.of((Object)new Vec3D(0.0, 0.5, 0.0));
    public static final List<Vec3D> SHARED_QUAD_ATTACHMENT_POINTS = ImmutableList.of((Object)new Vec3D(-0.5, 0.5, 0.5), (Object)new Vec3D(-0.5, 0.5, -0.5), (Object)new Vec3D(0.5, 0.5, -0.5), (Object)new Vec3D(0.5, 0.5, 0.5));

    @Nullable
    public a getLeashData();

    public void setLeashData(@Nullable a var1);

    default public boolean isLeashed() {
        return this.getLeashData() != null && this.getLeashData().leashHolder != null;
    }

    default public boolean mayBeLeashed() {
        return this.getLeashData() != null;
    }

    default public boolean canHaveALeashAttachedTo(Entity var0) {
        if (this == var0) {
            return false;
        }
        if (this.leashDistanceTo(var0) > this.leashSnapDistance()) {
            return false;
        }
        return this.canBeLeashed();
    }

    default public double leashDistanceTo(Entity var0) {
        return var0.getBoundingBox().getCenter().distanceTo(((Entity)((Object)this)).getBoundingBox().getCenter());
    }

    default public boolean canBeLeashed() {
        return true;
    }

    default public void setDelayedLeashHolderId(int var0) {
        this.setLeashData(new a(var0));
        Leashable.dropLeash((Entity)((Object)this), false, false);
    }

    default public void readLeashData(ValueInput var0) {
        a var1 = var0.read(LEASH_TAG, a.CODEC).orElse(null);
        if (this.getLeashData() != null && var1 == null) {
            this.removeLeash();
        }
        this.setLeashData(var1);
    }

    default public void writeLeashData(ValueOutput var0, @Nullable a var1) {
        var0.storeNullable(LEASH_TAG, a.CODEC, var1);
    }

    private static <E extends Entity> void restoreLeashFromSave(E var0, a var1) {
        World world;
        if (var1.delayedLeashInfo != null && (world = var0.level()) instanceof WorldServer) {
            WorldServer var2 = (WorldServer)world;
            Optional var3 = var1.delayedLeashInfo.left();
            Optional var4 = var1.delayedLeashInfo.right();
            if (var3.isPresent()) {
                Entity var5 = var2.getEntity((UUID)var3.get());
                if (var5 != null) {
                    Leashable.setLeashedTo(var0, var5, true);
                    return;
                }
            } else if (var4.isPresent()) {
                Leashable.setLeashedTo(var0, EntityLeash.getOrCreateKnot(var2, (BlockPosition)var4.get()), true);
                return;
            }
            if (var0.tickCount > 100) {
                var0.spawnAtLocation(var2, Items.LEAD);
                ((Leashable)((Object)var0)).setLeashData(null);
            }
        }
    }

    default public void dropLeash() {
        Leashable.dropLeash((Entity)((Object)this), true, true);
    }

    default public void removeLeash() {
        Leashable.dropLeash((Entity)((Object)this), true, false);
    }

    default public void onLeashRemoved() {
    }

    private static <E extends Entity> void dropLeash(E var0, boolean var1, boolean var2) {
        a var3 = ((Leashable)((Object)var0)).getLeashData();
        if (var3 != null && var3.leashHolder != null) {
            ((Leashable)((Object)var0)).setLeashData(null);
            ((Leashable)((Object)var0)).onLeashRemoved();
            World world = var0.level();
            if (world instanceof WorldServer) {
                WorldServer var4 = (WorldServer)world;
                if (var2) {
                    var0.spawnAtLocation(var4, Items.LEAD);
                }
                if (var1) {
                    var4.getChunkSource().broadcast(var0, new PacketPlayOutAttachEntity(var0, null));
                }
                var3.leashHolder.notifyLeasheeRemoved((Leashable)((Object)var0));
            }
        }
    }

    public static <E extends Entity> void tickLeash(WorldServer var0, E var1) {
        Entity var3;
        a var2 = ((Leashable)((Object)var1)).getLeashData();
        if (var2 != null && var2.delayedLeashInfo != null) {
            Leashable.restoreLeashFromSave(var1, var2);
        }
        if (var2 == null || var2.leashHolder == null) {
            return;
        }
        if (!var1.isAlive() || !var2.leashHolder.isAlive()) {
            if (var0.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                ((Leashable)((Object)var1)).dropLeash();
            } else {
                ((Leashable)((Object)var1)).removeLeash();
            }
        }
        if ((var3 = ((Leashable)((Object)var1)).getLeashHolder()) != null && var3.level() == var1.level()) {
            double var4 = ((Leashable)((Object)var1)).leashDistanceTo(var3);
            ((Leashable)((Object)var1)).whenLeashedTo(var3);
            if (var4 > ((Leashable)((Object)var1)).leashSnapDistance()) {
                var0.playSound(null, var3.getX(), var3.getY(), var3.getZ(), SoundEffects.LEAD_BREAK, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                ((Leashable)((Object)var1)).leashTooFarBehaviour();
            } else if (var4 > ((Leashable)((Object)var1)).leashElasticDistance() - (double)var3.getBbWidth() - (double)var1.getBbWidth() && ((Leashable)((Object)var1)).checkElasticInteractions(var3, var2)) {
                ((Leashable)((Object)var1)).onElasticLeashPull();
            } else {
                ((Leashable)((Object)var1)).closeRangeLeashBehaviour(var3);
            }
            var1.setYRot((float)((double)var1.getYRot() - var2.angularMomentum));
            var2.angularMomentum *= (double)Leashable.angularFriction(var1);
        }
    }

    default public void onElasticLeashPull() {
        Entity var0 = (Entity)((Object)this);
        var0.checkFallDistanceAccumulation();
    }

    default public double leashSnapDistance() {
        return 12.0;
    }

    default public double leashElasticDistance() {
        return 6.0;
    }

    public static <E extends Entity> float angularFriction(E var0) {
        if (var0.onGround()) {
            return var0.level().getBlockState(var0.getBlockPosBelowThatAffectsMyMovement()).getBlock().getFriction() * 0.91f;
        }
        if (var0.isInLiquid()) {
            return 0.8f;
        }
        return 0.91f;
    }

    default public void whenLeashedTo(Entity var0) {
        var0.notifyLeashHolder(this);
    }

    default public void leashTooFarBehaviour() {
        this.dropLeash();
    }

    default public void closeRangeLeashBehaviour(Entity var0) {
    }

    default public boolean checkElasticInteractions(Entity var0, a var1) {
        boolean var2 = var0.supportQuadLeashAsHolder() && this.supportQuadLeash();
        List<b> var3 = Leashable.computeElasticInteraction((Entity)((Object)this), var0, var2 ? SHARED_QUAD_ATTACHMENT_POINTS : ENTITY_ATTACHMENT_POINT, var2 ? SHARED_QUAD_ATTACHMENT_POINTS : LEASHER_ATTACHMENT_POINT);
        if (var3.isEmpty()) {
            return false;
        }
        b var4 = b.accumulate(var3).scale(var2 ? 0.25 : 1.0);
        var1.angularMomentum += 10.0 * var4.torque();
        Vec3D var5 = Leashable.getHolderMovement(var0).subtract(((Entity)((Object)this)).getKnownMovement());
        ((Entity)((Object)this)).addDeltaMovement(var4.force().multiply(AXIS_SPECIFIC_ELASTICITY).add(var5.scale(0.11)));
        return true;
    }

    private static Vec3D getHolderMovement(Entity var0) {
        EntityInsentient var1;
        if (var0 instanceof EntityInsentient && (var1 = (EntityInsentient)var0).isNoAi()) {
            return Vec3D.ZERO;
        }
        return var0.getKnownMovement();
    }

    private static <E extends Entity> List<b> computeElasticInteraction(E var0, Entity var1, List<Vec3D> var2, List<Vec3D> var3) {
        double var4 = ((Leashable)((Object)var0)).leashElasticDistance();
        Vec3D var6 = Leashable.getHolderMovement(var0);
        float var7 = var0.getYRot() * ((float)Math.PI / 180);
        Vec3D var8 = new Vec3D(var0.getBbWidth(), var0.getBbHeight(), var0.getBbWidth());
        float var9 = var1.getYRot() * ((float)Math.PI / 180);
        Vec3D var10 = new Vec3D(var1.getBbWidth(), var1.getBbHeight(), var1.getBbWidth());
        ArrayList<b> var11 = new ArrayList<b>();
        for (int var12 = 0; var12 < var2.size(); ++var12) {
            Vec3D var13 = var2.get(var12).multiply(var8).yRot(-var7);
            Vec3D var14 = var0.position().add(var13);
            Vec3D var15 = var3.get(var12).multiply(var10).yRot(-var9);
            Vec3D var16 = var1.position().add(var15);
            Leashable.computeDampenedSpringInteraction(var16, var14, var4, var6, var13).ifPresent(var11::add);
        }
        return var11;
    }

    private static Optional<b> computeDampenedSpringInteraction(Vec3D var0, Vec3D var1, double var2, Vec3D var4, Vec3D var5) {
        boolean var11;
        double var6 = var1.distanceTo(var0);
        if (var6 < var2) {
            return Optional.empty();
        }
        Vec3D var8 = var0.subtract(var1).normalize().scale(var6 - var2);
        double var9 = b.torqueFromForce(var5, var8);
        boolean bl = var11 = var4.dot(var8) >= 0.0;
        if (var11) {
            var8 = var8.scale(0.3f);
        }
        return Optional.of(new b(var8, var9));
    }

    default public boolean supportQuadLeash() {
        return false;
    }

    default public Vec3D[] getQuadLeashOffsets() {
        return Leashable.createQuadLeashOffsets((Entity)((Object)this), 0.0, 0.5, 0.5, 0.5);
    }

    public static Vec3D[] createQuadLeashOffsets(Entity var0, double var1, double var3, double var5, double var7) {
        float var9 = var0.getBbWidth();
        double var10 = var1 * (double)var9;
        double var12 = var3 * (double)var9;
        double var14 = var5 * (double)var9;
        double var16 = var7 * (double)var0.getBbHeight();
        return new Vec3D[]{new Vec3D(-var14, var16, var12 + var10), new Vec3D(-var14, var16, -var12 + var10), new Vec3D(var14, var16, -var12 + var10), new Vec3D(var14, var16, var12 + var10)};
    }

    default public Vec3D getLeashOffset(float var0) {
        return this.getLeashOffset();
    }

    default public Vec3D getLeashOffset() {
        Entity var0 = (Entity)((Object)this);
        return new Vec3D(0.0, var0.getEyeHeight(), var0.getBbWidth() * 0.4f);
    }

    default public void setLeashedTo(Entity var0, boolean var1) {
        if (this == var0) {
            return;
        }
        Leashable.setLeashedTo((Entity)((Object)this), var0, var1);
    }

    private static <E extends Entity> void setLeashedTo(E var0, Entity var1, boolean var2) {
        World world;
        Object var4;
        a var3 = ((Leashable)((Object)var0)).getLeashData();
        if (var3 == null) {
            var3 = new a(var1);
            ((Leashable)((Object)var0)).setLeashData(var3);
        } else {
            var4 = var3.leashHolder;
            var3.setLeashHolder(var1);
            if (var4 != null && var4 != var1) {
                ((Entity)var4).notifyLeasheeRemoved((Leashable)((Object)var0));
            }
        }
        if (var2 && (world = var0.level()) instanceof WorldServer) {
            var4 = (WorldServer)world;
            ((WorldServer)var4).getChunkSource().broadcast(var0, new PacketPlayOutAttachEntity(var0, var1));
        }
        if (var0.isPassenger()) {
            var0.stopRiding();
        }
    }

    @Nullable
    default public Entity getLeashHolder() {
        return Leashable.getLeashHolder((Entity)((Object)this));
    }

    @Nullable
    private static <E extends Entity> Entity getLeashHolder(E var0) {
        Entity entity;
        a var1 = ((Leashable)((Object)var0)).getLeashData();
        if (var1 == null) {
            return null;
        }
        if (var1.delayedLeashHolderId != 0 && var0.level().isClientSide && (entity = var0.level().getEntity(var1.delayedLeashHolderId)) instanceof Entity) {
            Entity var2 = entity;
            var1.setLeashHolder(var2);
        }
        return var1.leashHolder;
    }

    public static List<Leashable> leashableLeashedTo(Entity var0) {
        return Leashable.leashableInArea(var0, var1 -> var1.getLeashHolder() == var0);
    }

    public static List<Leashable> leashableInArea(Entity var0, Predicate<Leashable> var1) {
        return Leashable.leashableInArea(var0.level(), var0.getBoundingBox().getCenter(), var1);
    }

    public static List<Leashable> leashableInArea(World var0, Vec3D var12, Predicate<Leashable> var2) {
        double var3 = 32.0;
        AxisAlignedBB var5 = AxisAlignedBB.ofSize(var12, 32.0, 32.0, 32.0);
        return var0.getEntitiesOfClass(Entity.class, var5, var1 -> {
            Leashable var2;
            return var1 instanceof Leashable && var2.test(var2 = (Leashable)((Object)var1));
        }).stream().map(Leashable.class::cast).toList();
    }

    public static final class a {
        public static final Codec<a> CODEC = Codec.xor((Codec)UUIDUtil.CODEC.fieldOf("UUID").codec(), BlockPosition.CODEC).xmap(a::new, var0 -> {
            Entity var2 = var0.leashHolder;
            if (var2 instanceof EntityLeash) {
                EntityLeash var1 = (EntityLeash)var2;
                return Either.right((Object)var1.getPos());
            }
            if (var0.leashHolder != null) {
                return Either.left((Object)var0.leashHolder.getUUID());
            }
            return Objects.requireNonNull(var0.delayedLeashInfo, "Invalid LeashData had no attachment");
        });
        int delayedLeashHolderId;
        @Nullable
        public Entity leashHolder;
        @Nullable
        public Either<UUID, BlockPosition> delayedLeashInfo;
        public double angularMomentum;

        private a(Either<UUID, BlockPosition> var0) {
            this.delayedLeashInfo = var0;
        }

        a(Entity var0) {
            this.leashHolder = var0;
        }

        a(int var0) {
            this.delayedLeashHolderId = var0;
        }

        public void setLeashHolder(Entity var0) {
            this.leashHolder = var0;
            this.delayedLeashInfo = null;
            this.delayedLeashHolderId = 0;
        }
    }

    public record b(Vec3D force, double torque) {
        static b ZERO = new b(Vec3D.ZERO, 0.0);

        static double torqueFromForce(Vec3D var0, Vec3D var1) {
            return var0.z * var1.x - var0.x * var1.z;
        }

        static b accumulate(List<b> var0) {
            if (var0.isEmpty()) {
                return ZERO;
            }
            double var1 = 0.0;
            double var3 = 0.0;
            double var5 = 0.0;
            double var7 = 0.0;
            for (b var10 : var0) {
                Vec3D var11 = var10.force;
                var1 += var11.x;
                var3 += var11.y;
                var5 += var11.z;
                var7 += var10.torque;
            }
            return new b(new Vec3D(var1, var3, var5), var7);
        }

        public b scale(double var0) {
            return new b(this.force.scale(var0), this.torque * var0);
        }
    }
}

