/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class CountDownCooldownTicks
extends Behavior<EntityLiving> {
    private final MemoryModuleType<Integer> cooldownTicks;

    public CountDownCooldownTicks(MemoryModuleType<Integer> var0) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(var0, (Object)((Object)MemoryStatus.VALUE_PRESENT)));
        this.cooldownTicks = var0;
    }

    private Optional<Integer> getCooldownTickMemory(EntityLiving var0) {
        return var0.getBrain().getMemory(this.cooldownTicks);
    }

    @Override
    protected boolean timedOut(long var0) {
        return false;
    }

    @Override
    protected boolean canStillUse(WorldServer var0, EntityLiving var1, long var2) {
        Optional<Integer> var4 = this.getCooldownTickMemory(var1);
        return var4.isPresent() && var4.get() > 0;
    }

    @Override
    protected void tick(WorldServer var0, EntityLiving var1, long var2) {
        Optional<Integer> var4 = this.getCooldownTickMemory(var1);
        var1.getBrain().setMemory(this.cooldownTicks, var4.get() - 1);
    }

    @Override
    protected void stop(WorldServer var0, EntityLiving var1, long var2) {
        var1.getBrain().eraseMemory(this.cooldownTicks);
    }
}

