/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.control;

import java.util.Optional;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.ai.control.Control;
import net.minecraft.world.phys.Vec3D;

public class ControllerLook
implements Control {
    protected final EntityInsentient mob;
    protected float yMaxRotSpeed;
    protected float xMaxRotAngle;
    protected int lookAtCooldown;
    protected double wantedX;
    protected double wantedY;
    protected double wantedZ;

    public ControllerLook(EntityInsentient var0) {
        this.mob = var0;
    }

    public void setLookAt(Vec3D var0) {
        this.setLookAt(var0.x, var0.y, var0.z);
    }

    public void setLookAt(Entity var0) {
        this.setLookAt(var0.getX(), var0.getEyeY(), var0.getZ());
    }

    public void setLookAt(Entity var0, float var1, float var2) {
        this.setLookAt(var0.getX(), var0.getEyeY(), var0.getZ(), var1, var2);
    }

    public void setLookAt(double var0, double var2, double var4) {
        this.setLookAt(var0, var2, var4, this.mob.getHeadRotSpeed(), this.mob.getMaxHeadXRot());
    }

    public void setLookAt(double var0, double var2, double var4, float var6, float var7) {
        this.wantedX = var0;
        this.wantedY = var2;
        this.wantedZ = var4;
        this.yMaxRotSpeed = var6;
        this.xMaxRotAngle = var7;
        this.lookAtCooldown = 2;
    }

    public void tick() {
        if (this.resetXRotOnTick()) {
            this.mob.setXRot(0.0f);
        }
        if (this.lookAtCooldown > 0) {
            --this.lookAtCooldown;
            this.getYRotD().ifPresent(var0 -> {
                this.mob.yHeadRot = this.rotateTowards(this.mob.yHeadRot, var0.floatValue(), this.yMaxRotSpeed);
            });
            this.getXRotD().ifPresent(var0 -> this.mob.setXRot(this.rotateTowards(this.mob.getXRot(), var0.floatValue(), this.xMaxRotAngle)));
        } else {
            this.mob.yHeadRot = this.rotateTowards(this.mob.yHeadRot, this.mob.yBodyRot, 10.0f);
        }
        this.clampHeadRotationToBody();
    }

    protected void clampHeadRotationToBody() {
        if (!this.mob.getNavigation().isDone()) {
            this.mob.yHeadRot = MathHelper.rotateIfNecessary(this.mob.yHeadRot, this.mob.yBodyRot, this.mob.getMaxHeadYRot());
        }
    }

    protected boolean resetXRotOnTick() {
        return true;
    }

    public boolean isLookingAtTarget() {
        return this.lookAtCooldown > 0;
    }

    public double getWantedX() {
        return this.wantedX;
    }

    public double getWantedY() {
        return this.wantedY;
    }

    public double getWantedZ() {
        return this.wantedZ;
    }

    protected Optional<Float> getXRotD() {
        double var0 = this.wantedX - this.mob.getX();
        double var2 = this.wantedY - this.mob.getEyeY();
        double var4 = this.wantedZ - this.mob.getZ();
        double var6 = Math.sqrt(var0 * var0 + var4 * var4);
        return Math.abs(var2) > (double)1.0E-5f || Math.abs(var6) > (double)1.0E-5f ? Optional.of(Float.valueOf((float)(-(MathHelper.atan2(var2, var6) * 57.2957763671875)))) : Optional.empty();
    }

    protected Optional<Float> getYRotD() {
        double var0 = this.wantedX - this.mob.getX();
        double var2 = this.wantedZ - this.mob.getZ();
        return Math.abs(var2) > (double)1.0E-5f || Math.abs(var0) > (double)1.0E-5f ? Optional.of(Float.valueOf((float)(MathHelper.atan2(var2, var0) * 57.2957763671875) - 90.0f)) : Optional.empty();
    }
}

