/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.core.BlockPosition;
import net.minecraft.tags.TagsEntity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class ClimbOnTopOfPowderSnowGoal
extends PathfinderGoal {
    private final EntityInsentient mob;
    private final World level;

    public ClimbOnTopOfPowderSnowGoal(EntityInsentient var0, World var1) {
        this.mob = var0;
        this.level = var1;
        this.setFlags(EnumSet.of(PathfinderGoal.Type.JUMP));
    }

    @Override
    public boolean canUse() {
        boolean var0;
        boolean bl = var0 = this.mob.wasInPowderSnow || this.mob.isInPowderSnow;
        if (!var0 || !this.mob.getType().is(TagsEntity.POWDER_SNOW_WALKABLE_MOBS)) {
            return false;
        }
        BlockPosition var1 = this.mob.blockPosition().above();
        IBlockData var2 = this.level.getBlockState(var1);
        return var2.is(Blocks.POWDER_SNOW) || var2.getCollisionShape(this.level, var1) == VoxelShapes.empty();
    }

    @Override
    public boolean requiresUpdateEveryTick() {
        return true;
    }

    @Override
    public void tick() {
        this.mob.getJumpControl().jump();
    }
}

