/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.armadillo;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.TimeRange;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.AnimalPanic;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BehaviorFollowAdult;
import net.minecraft.world.entity.ai.behavior.BehaviorGateSingle;
import net.minecraft.world.entity.ai.behavior.BehaviorLook;
import net.minecraft.world.entity.ai.behavior.BehaviorLookWalk;
import net.minecraft.world.entity.ai.behavior.BehaviorMakeLoveAnimal;
import net.minecraft.world.entity.ai.behavior.BehaviorNop;
import net.minecraft.world.entity.ai.behavior.BehaviorStrollRandomUnconstrained;
import net.minecraft.world.entity.ai.behavior.BehaviorSwim;
import net.minecraft.world.entity.ai.behavior.BehavorMove;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.RandomLookAround;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.armadillo.Armadillo;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;

public class ArmadilloAi {
    private static final float SPEED_MULTIPLIER_WHEN_PANICKING = 2.0f;
    private static final float SPEED_MULTIPLIER_WHEN_IDLING = 1.0f;
    private static final float SPEED_MULTIPLIER_WHEN_TEMPTED = 1.25f;
    private static final float SPEED_MULTIPLIER_WHEN_FOLLOWING_ADULT = 1.25f;
    private static final float SPEED_MULTIPLIER_WHEN_MAKING_LOVE = 1.0f;
    private static final double DEFAULT_CLOSE_ENOUGH_DIST = 2.0;
    private static final double BABY_CLOSE_ENOUGH_DIST = 1.0;
    private static final UniformInt ADULT_FOLLOW_RANGE = UniformInt.of(5, 16);
    private static final ImmutableList<SensorType<? extends Sensor<? super Armadillo>>> SENSOR_TYPES = ImmutableList.of(SensorType.NEAREST_LIVING_ENTITIES, SensorType.HURT_BY, SensorType.ARMADILLO_TEMPTATIONS, SensorType.NEAREST_ADULT, SensorType.ARMADILLO_SCARE_DETECTED);
    private static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of(MemoryModuleType.IS_PANICKING, MemoryModuleType.HURT_BY, MemoryModuleType.HURT_BY_ENTITY, MemoryModuleType.WALK_TARGET, MemoryModuleType.LOOK_TARGET, MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, MemoryModuleType.PATH, MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, MemoryModuleType.TEMPTING_PLAYER, MemoryModuleType.TEMPTATION_COOLDOWN_TICKS, MemoryModuleType.GAZE_COOLDOWN_TICKS, MemoryModuleType.IS_TEMPTED, (Object[])new MemoryModuleType[]{MemoryModuleType.BREED_TARGET, MemoryModuleType.NEAREST_VISIBLE_ADULT, MemoryModuleType.DANGER_DETECTED_RECENTLY});
    private static final OneShot<Armadillo> ARMADILLO_ROLLING_OUT = BehaviorBuilder.create(var0 -> var0.group(var0.absent(MemoryModuleType.DANGER_DETECTED_RECENTLY)).apply((Applicative)var0, var02 -> (var0, var1, var2) -> {
        if (var1.isScared()) {
            var1.rollOut();
            return true;
        }
        return false;
    }));

    public static BehaviorController.b<Armadillo> brainProvider() {
        return BehaviorController.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected static BehaviorController<?> makeBrain(BehaviorController<Armadillo> var0) {
        ArmadilloAi.initCoreActivity(var0);
        ArmadilloAi.initIdleActivity(var0);
        ArmadilloAi.initScaredActivity(var0);
        var0.setCoreActivities(Set.of(Activity.CORE));
        var0.setDefaultActivity(Activity.IDLE);
        var0.useDefaultActivity();
        return var0;
    }

    private static void initCoreActivity(BehaviorController<Armadillo> var0) {
        var0.addActivity(Activity.CORE, 0, (ImmutableList<BehaviorControl<Armadillo>>)ImmutableList.of(new BehaviorSwim(0.8f), (Object)new b(2.0f), (Object)new BehaviorLook(45, 90), (Object)new BehavorMove(){

            @Override
            protected boolean checkExtraStartConditions(WorldServer var0, EntityInsentient var1) {
                Armadillo var2;
                if (var1 instanceof Armadillo && (var2 = (Armadillo)var1).isScared()) {
                    return false;
                }
                return super.checkExtraStartConditions(var0, var1);
            }
        }, (Object)new CountDownCooldownTicks(MemoryModuleType.TEMPTATION_COOLDOWN_TICKS), (Object)new CountDownCooldownTicks(MemoryModuleType.GAZE_COOLDOWN_TICKS), ARMADILLO_ROLLING_OUT));
    }

    private static void initIdleActivity(BehaviorController<Armadillo> var02) {
        var02.addActivity(Activity.IDLE, (ImmutableList<Pair<Integer, BehaviorControl<Armadillo>>>)ImmutableList.of((Object)Pair.of((Object)0, SetEntityLookTargetSometimes.create(EntityTypes.PLAYER, 6.0f, UniformInt.of(30, 60))), (Object)Pair.of((Object)1, (Object)new BehaviorMakeLoveAnimal(EntityTypes.ARMADILLO, 1.0f, 1)), (Object)Pair.of((Object)2, new BehaviorGateSingle(ImmutableList.of((Object)Pair.of((Object)new FollowTemptation(var0 -> Float.valueOf(1.25f), var0 -> var0.isBaby() ? 1.0 : 2.0), (Object)1), (Object)Pair.of(BehaviorFollowAdult.create(ADULT_FOLLOW_RANGE, 1.25f), (Object)1)))), (Object)Pair.of((Object)3, (Object)new RandomLookAround(UniformInt.of(150, 250), 30.0f, 0.0f, 0.0f)), (Object)Pair.of((Object)4, new BehaviorGateSingle((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT)), ImmutableList.of((Object)Pair.of(BehaviorStrollRandomUnconstrained.stroll(1.0f), (Object)1), (Object)Pair.of(BehaviorLookWalk.create(1.0f, 3), (Object)1), (Object)Pair.of((Object)new BehaviorNop(30, 60), (Object)1))))));
    }

    private static void initScaredActivity(BehaviorController<Armadillo> var0) {
        var0.addActivityWithConditions(Activity.PANIC, (ImmutableList<Pair<Integer, BehaviorControl<Armadillo>>>)ImmutableList.of((Object)Pair.of((Object)0, (Object)new a())), Set.of(Pair.of(MemoryModuleType.DANGER_DETECTED_RECENTLY, (Object)((Object)MemoryStatus.VALUE_PRESENT)), Pair.of(MemoryModuleType.IS_PANICKING, (Object)((Object)MemoryStatus.VALUE_ABSENT))));
    }

    public static void updateActivity(Armadillo var0) {
        var0.getBrain().setActiveActivityToFirstValid((List<Activity>)ImmutableList.of((Object)Activity.PANIC, (Object)Activity.IDLE));
    }

    public static Predicate<ItemStack> getTemptations() {
        return var0 -> var0.is(TagsItem.ARMADILLO_FOOD);
    }

    public static class b
    extends AnimalPanic<Armadillo> {
        public b(float var02) {
            super(var02, var0 -> DamageTypeTags.PANIC_ENVIRONMENTAL_CAUSES);
        }

        @Override
        protected void start(WorldServer var0, Armadillo var1, long var2) {
            var1.rollOut();
            super.start(var0, var1, var2);
        }

        @Override
        protected /* synthetic */ void start(WorldServer worldServer, EntityCreature entityCreature, long l2) {
            this.start(worldServer, (Armadillo)entityCreature, l2);
        }

        @Override
        protected /* synthetic */ void start(WorldServer worldServer, EntityLiving entityLiving, long l2) {
            this.start(worldServer, (Armadillo)entityLiving, l2);
        }
    }

    public static class a
    extends Behavior<Armadillo> {
        static final int BALL_UP_STAY_IN_STATE = 5 * TimeRange.SECONDS_PER_MINUTE * 20;
        static final int TICKS_DELAY_TO_DETERMINE_IF_DANGER_IS_STILL_AROUND = 5;
        static final int DANGER_DETECTED_RECENTLY_DANGER_THRESHOLD = 75;
        int nextPeekTimer = 0;
        boolean dangerWasAround;

        public a() {
            super(Map.of(), BALL_UP_STAY_IN_STATE);
        }

        @Override
        protected void tick(WorldServer var0, Armadillo var1, long var2) {
            boolean var7;
            super.tick(var0, var1, var2);
            if (this.nextPeekTimer > 0) {
                --this.nextPeekTimer;
            }
            if (var1.shouldSwitchToScaredState()) {
                var1.switchToState(Armadillo.a.SCARED);
                if (var1.onGround()) {
                    var1.playSound(SoundEffects.ARMADILLO_LAND);
                }
                return;
            }
            Armadillo.a var4 = var1.getState();
            long var5 = var1.getBrain().getTimeUntilExpiry(MemoryModuleType.DANGER_DETECTED_RECENTLY);
            boolean bl = var7 = var5 > 75L;
            if (var7 != this.dangerWasAround) {
                this.nextPeekTimer = this.pickNextPeekTimer(var1);
            }
            this.dangerWasAround = var7;
            if (var4 == Armadillo.a.SCARED) {
                if (this.nextPeekTimer == 0 && var1.onGround() && var7) {
                    var0.broadcastEntityEvent(var1, (byte)64);
                    this.nextPeekTimer = this.pickNextPeekTimer(var1);
                }
                if (var5 < (long)Armadillo.a.UNROLLING.animationDuration()) {
                    var1.playSound(SoundEffects.ARMADILLO_UNROLL_START);
                    var1.switchToState(Armadillo.a.UNROLLING);
                }
            } else if (var4 == Armadillo.a.UNROLLING && var5 > (long)Armadillo.a.UNROLLING.animationDuration()) {
                var1.switchToState(Armadillo.a.SCARED);
            }
        }

        private int pickNextPeekTimer(Armadillo var0) {
            return Armadillo.a.SCARED.animationDuration() + var0.getRandom().nextIntBetweenInclusive(100, 400);
        }

        @Override
        protected boolean checkExtraStartConditions(WorldServer var0, Armadillo var1) {
            return var1.onGround();
        }

        @Override
        protected boolean canStillUse(WorldServer var0, Armadillo var1, long var2) {
            return var1.getState().isThreatened();
        }

        @Override
        protected void start(WorldServer var0, Armadillo var1, long var2) {
            var1.rollUp();
        }

        @Override
        protected void stop(WorldServer var0, Armadillo var1, long var2) {
            if (!var1.canStayRolledUp()) {
                var1.rollOut();
            }
        }

        @Override
        protected /* synthetic */ boolean canStillUse(WorldServer worldServer, EntityLiving entityLiving, long l2) {
            return this.canStillUse(worldServer, (Armadillo)entityLiving, l2);
        }

        @Override
        protected /* synthetic */ void stop(WorldServer worldServer, EntityLiving entityLiving, long l2) {
            this.stop(worldServer, (Armadillo)entityLiving, l2);
        }

        @Override
        protected /* synthetic */ void tick(WorldServer worldServer, EntityLiving entityLiving, long l2) {
            this.tick(worldServer, (Armadillo)entityLiving, l2);
        }

        @Override
        protected /* synthetic */ void start(WorldServer worldServer, EntityLiving entityLiving, long l2) {
            this.start(worldServer, (Armadillo)entityLiving, l2);
        }
    }
}

