/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.projectile.EntityFireballFireball;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;

public class EntitySmallFireball
extends EntityFireballFireball {
    public EntitySmallFireball(EntityTypes<? extends EntitySmallFireball> var0, World var1) {
        super((EntityTypes<? extends EntityFireballFireball>)var0, var1);
    }

    public EntitySmallFireball(World var0, EntityLiving var1, Vec3D var2) {
        super((EntityTypes<? extends EntityFireballFireball>)EntityTypes.SMALL_FIREBALL, var1, var2, var0);
    }

    public EntitySmallFireball(World var0, double var1, double var3, double var5, Vec3D var7) {
        super((EntityTypes<? extends EntityFireballFireball>)EntityTypes.SMALL_FIREBALL, var1, var3, var5, var7, var0);
    }

    @Override
    protected void onHitEntity(MovingObjectPositionEntity var0) {
        super.onHitEntity(var0);
        World world = this.level();
        if (!(world instanceof WorldServer)) {
            return;
        }
        WorldServer var1 = (WorldServer)world;
        Entity var2 = var0.getEntity();
        Entity var3 = this.getOwner();
        int var4 = var2.getRemainingFireTicks();
        var2.igniteForSeconds(5.0f);
        DamageSource var5 = this.damageSources().fireball(this, var3);
        if (!var2.hurtServer(var1, var5, 5.0f)) {
            var2.setRemainingFireTicks(var4);
        } else {
            EnchantmentManager.doPostAttackEffects(var1, var2, var5);
        }
    }

    @Override
    protected void onHitBlock(MovingObjectPositionBlock var0) {
        super.onHitBlock(var0);
        World world = this.level();
        if (!(world instanceof WorldServer)) {
            return;
        }
        WorldServer var1 = (WorldServer)world;
        Entity var2 = this.getOwner();
        if (!(var2 instanceof EntityInsentient) || var1.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
            BlockPosition var3 = var0.getBlockPos().relative(var0.getDirection());
            if (this.level().isEmptyBlock(var3)) {
                this.level().setBlockAndUpdate(var3, BlockFireAbstract.getState(this.level(), var3));
            }
        }
    }

    @Override
    protected void onHit(MovingObjectPosition var0) {
        super.onHit(var0);
        if (!this.level().isClientSide) {
            this.discard();
        }
    }
}

