/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.raid;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Collection;
import java.util.List;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.PoiTypeTags;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceRecord;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.saveddata.PersistentBase;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.phys.Vec3D;

public class PersistentRaid
extends PersistentBase {
    private static final String RAID_FILE_ID = "raids";
    public static final Codec<PersistentRaid> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)a.CODEC.listOf().optionalFieldOf(RAID_FILE_ID, List.of()).forGetter(var0 -> var0.raidMap.int2ObjectEntrySet().stream().map(a::from).toList()), (App)Codec.INT.fieldOf("next_id").forGetter(var0 -> var0.nextId), (App)Codec.INT.fieldOf("tick").forGetter(var0 -> var0.tick)).apply((Applicative)var02, PersistentRaid::new));
    public static final SavedDataType<PersistentRaid> TYPE = new SavedDataType<PersistentRaid>("raids", PersistentRaid::new, CODEC, DataFixTypes.SAVED_DATA_RAIDS);
    public static final SavedDataType<PersistentRaid> TYPE_END = new SavedDataType<PersistentRaid>("raids_end", PersistentRaid::new, CODEC, DataFixTypes.SAVED_DATA_RAIDS);
    public final Int2ObjectMap<Raid> raidMap = new Int2ObjectOpenHashMap();
    private int nextId = 1;
    private int tick;

    public static SavedDataType<PersistentRaid> getType(Holder<DimensionManager> var0) {
        if (var0.is(BuiltinDimensionTypes.END)) {
            return TYPE_END;
        }
        return TYPE;
    }

    public PersistentRaid() {
        this.setDirty();
    }

    private PersistentRaid(List<a> var0, int var1, int var2) {
        for (a var4 : var0) {
            this.raidMap.put(var4.id, (Object)var4.raid);
        }
        this.nextId = var1;
        this.tick = var2;
    }

    @Nullable
    public Raid get(int var0) {
        return (Raid)this.raidMap.get(var0);
    }

    public OptionalInt getId(Raid var0) {
        for (Int2ObjectMap.Entry var2 : this.raidMap.int2ObjectEntrySet()) {
            if (var2.getValue() != var0) continue;
            return OptionalInt.of(var2.getIntKey());
        }
        return OptionalInt.empty();
    }

    public void tick(WorldServer var0) {
        ++this.tick;
        ObjectIterator var1 = this.raidMap.values().iterator();
        while (var1.hasNext()) {
            Raid var2 = (Raid)var1.next();
            if (var0.getGameRules().getBoolean(GameRules.RULE_DISABLE_RAIDS)) {
                var2.stop();
            }
            if (var2.isStopped()) {
                var1.remove();
                this.setDirty();
                continue;
            }
            var2.tick(var0);
        }
        if (this.tick % 200 == 0) {
            this.setDirty();
        }
        PacketDebug.sendRaids(var0, (Collection<Raid>)this.raidMap.values());
    }

    public static boolean canJoinRaid(EntityRaider var0) {
        return var0.isAlive() && var0.canJoinRaid() && var0.getNoActionTime() <= 2400;
    }

    @Nullable
    public Raid createOrExtendRaid(EntityPlayer var02, BlockPosition var1) {
        BlockPosition var7;
        if (var02.isSpectator()) {
            return null;
        }
        WorldServer var2 = var02.level();
        if (var2.getGameRules().getBoolean(GameRules.RULE_DISABLE_RAIDS)) {
            return null;
        }
        DimensionManager var3 = var2.dimensionType();
        if (!var3.hasRaids()) {
            return null;
        }
        List<VillagePlaceRecord> var4 = var2.getPoiManager().getInRange(var0 -> var0.is(PoiTypeTags.VILLAGE), var1, 64, VillagePlace.Occupancy.IS_OCCUPIED).toList();
        int var5 = 0;
        Vec3D var6 = Vec3D.ZERO;
        for (VillagePlaceRecord villagePlaceRecord : var4) {
            BlockPosition var9 = villagePlaceRecord.getPos();
            var6 = var6.add(var9.getX(), var9.getY(), var9.getZ());
            ++var5;
        }
        if (var5 > 0) {
            var6 = var6.scale(1.0 / (double)var5);
            var7 = BlockPosition.containing(var6);
        } else {
            var7 = var1;
        }
        Raid raid = this.getOrCreateRaid(var2, var7);
        if (!raid.isStarted() && !this.raidMap.containsValue((Object)raid)) {
            this.raidMap.put(this.getUniqueId(), (Object)raid);
        }
        if (!raid.isStarted() || raid.getRaidOmenLevel() < raid.getMaxRaidOmenLevel()) {
            raid.absorbRaidOmen(var02);
        }
        this.setDirty();
        return raid;
    }

    private Raid getOrCreateRaid(WorldServer var0, BlockPosition var1) {
        Raid var2 = var0.getRaidAt(var1);
        return var2 != null ? var2 : new Raid(var1, var0.getDifficulty());
    }

    public static PersistentRaid load(NBTTagCompound var0) {
        return CODEC.parse((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var0).resultOrPartial().orElseGet(PersistentRaid::new);
    }

    private int getUniqueId() {
        return ++this.nextId;
    }

    @Nullable
    public Raid getNearbyRaid(BlockPosition var0, int var1) {
        Raid var2 = null;
        double var3 = var1;
        for (Raid var6 : this.raidMap.values()) {
            double var7 = var6.getCenter().distSqr(var0);
            if (!var6.isActive() || !(var7 < var3)) continue;
            var2 = var6;
            var3 = var7;
        }
        return var2;
    }

    static final class a
    extends Record {
        final int id;
        final Raid raid;
        public static final Codec<a> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)Codec.INT.fieldOf("id").forGetter(a::id), (App)Raid.MAP_CODEC.forGetter(a::raid)).apply((Applicative)var0, a::new));

        private a(int var0, Raid var1) {
            this.id = var0;
            this.raid = var1;
        }

        public static a from(Int2ObjectMap.Entry<Raid> var0) {
            return new a(var0.getIntKey(), (Raid)var0.getValue());
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "id;raid", "id", "raid"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "id;raid", "id", "raid"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "id;raid", "id", "raid"}, this, var0);
        }

        public int id() {
            return this.id;
        }

        public Raid raid() {
            return this.raid;
        }
    }
}

