/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDye;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.IRecipeComplex;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;

public class RecipeFireworksStar
extends IRecipeComplex {
    private static final Map<Item, FireworkExplosion.a> SHAPE_BY_ITEM = Map.of(Items.FIRE_CHARGE, FireworkExplosion.a.LARGE_BALL, Items.FEATHER, FireworkExplosion.a.BURST, Items.GOLD_NUGGET, FireworkExplosion.a.STAR, Items.SKELETON_SKULL, FireworkExplosion.a.CREEPER, Items.WITHER_SKELETON_SKULL, FireworkExplosion.a.CREEPER, Items.CREEPER_HEAD, FireworkExplosion.a.CREEPER, Items.PLAYER_HEAD, FireworkExplosion.a.CREEPER, Items.DRAGON_HEAD, FireworkExplosion.a.CREEPER, Items.ZOMBIE_HEAD, FireworkExplosion.a.CREEPER, Items.PIGLIN_HEAD, FireworkExplosion.a.CREEPER);
    private static final RecipeItemStack TRAIL_INGREDIENT = RecipeItemStack.of((IMaterial)Items.DIAMOND);
    private static final RecipeItemStack TWINKLE_INGREDIENT = RecipeItemStack.of((IMaterial)Items.GLOWSTONE_DUST);
    private static final RecipeItemStack GUNPOWDER_INGREDIENT = RecipeItemStack.of((IMaterial)Items.GUNPOWDER);

    public RecipeFireworksStar(CraftingBookCategory var0) {
        super(var0);
    }

    @Override
    public boolean matches(CraftingInput var0, World var1) {
        if (var0.ingredientCount() < 2) {
            return false;
        }
        boolean var2 = false;
        boolean var3 = false;
        boolean var4 = false;
        boolean var5 = false;
        boolean var6 = false;
        for (int var7 = 0; var7 < var0.size(); ++var7) {
            ItemStack var8 = var0.getItem(var7);
            if (var8.isEmpty()) continue;
            if (SHAPE_BY_ITEM.containsKey(var8.getItem())) {
                if (var4) {
                    return false;
                }
                var4 = true;
                continue;
            }
            if (TWINKLE_INGREDIENT.test(var8)) {
                if (var6) {
                    return false;
                }
                var6 = true;
                continue;
            }
            if (TRAIL_INGREDIENT.test(var8)) {
                if (var5) {
                    return false;
                }
                var5 = true;
                continue;
            }
            if (GUNPOWDER_INGREDIENT.test(var8)) {
                if (var2) {
                    return false;
                }
                var2 = true;
                continue;
            }
            if (var8.getItem() instanceof ItemDye) {
                var3 = true;
                continue;
            }
            return false;
        }
        return var2 && var3;
    }

    @Override
    public ItemStack assemble(CraftingInput var0, HolderLookup.a var1) {
        FireworkExplosion.a var2 = FireworkExplosion.a.SMALL_BALL;
        boolean var3 = false;
        boolean var4 = false;
        IntArrayList var5 = new IntArrayList();
        for (int var6 = 0; var6 < var0.size(); ++var6) {
            ItemStack var7 = var0.getItem(var6);
            if (var7.isEmpty()) continue;
            FireworkExplosion.a var8 = SHAPE_BY_ITEM.get(var7.getItem());
            if (var8 != null) {
                var2 = var8;
                continue;
            }
            if (TWINKLE_INGREDIENT.test(var7)) {
                var3 = true;
                continue;
            }
            if (TRAIL_INGREDIENT.test(var7)) {
                var4 = true;
                continue;
            }
            Item item = var7.getItem();
            if (!(item instanceof ItemDye)) continue;
            ItemDye var9 = (ItemDye)item;
            var5.add(var9.getDyeColor().getFireworkColor());
        }
        ItemStack var6 = new ItemStack(Items.FIREWORK_STAR);
        var6.set(DataComponents.FIREWORK_EXPLOSION, new FireworkExplosion(var2, (IntList)var5, IntList.of(), var4, var3));
        return var6;
    }

    @Override
    public RecipeSerializer<RecipeFireworksStar> getSerializer() {
        return RecipeSerializer.FIREWORK_STAR;
    }
}

