/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.World;

public abstract class RecipeSingleItem
implements IRecipe<SingleRecipeInput> {
    private final RecipeItemStack input;
    private final ItemStack result;
    private final String group;
    @Nullable
    private PlacementInfo placementInfo;

    public RecipeSingleItem(String var0, RecipeItemStack var1, ItemStack var2) {
        this.group = var0;
        this.input = var1;
        this.result = var2;
    }

    @Override
    public abstract RecipeSerializer<? extends RecipeSingleItem> getSerializer();

    @Override
    public abstract Recipes<? extends RecipeSingleItem> getType();

    @Override
    public boolean matches(SingleRecipeInput var0, World var1) {
        return this.input.test(var0.item());
    }

    @Override
    public String group() {
        return this.group;
    }

    public RecipeItemStack input() {
        return this.input;
    }

    protected ItemStack result() {
        return this.result;
    }

    @Override
    public PlacementInfo placementInfo() {
        if (this.placementInfo == null) {
            this.placementInfo = PlacementInfo.create(this.input);
        }
        return this.placementInfo;
    }

    @Override
    public ItemStack assemble(SingleRecipeInput var0, HolderLookup.a var1) {
        return this.result.copy();
    }

    @FunctionalInterface
    public static interface a<T extends RecipeSingleItem> {
        public T create(String var1, RecipeItemStack var2, ItemStack var3);
    }

    public static class b<T extends RecipeSingleItem>
    implements RecipeSerializer<T> {
        private final MapCodec<T> codec = RecordCodecBuilder.mapCodec(var1 -> var1.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(RecipeSingleItem::group), (App)RecipeItemStack.CODEC.fieldOf("ingredient").forGetter(RecipeSingleItem::input), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(RecipeSingleItem::result)).apply((Applicative)var1, var0::create));
        private final StreamCodec<RegistryFriendlyByteBuf, T> streamCodec = StreamCodec.composite(ByteBufCodecs.STRING_UTF8, RecipeSingleItem::group, RecipeItemStack.CONTENTS_STREAM_CODEC, RecipeSingleItem::input, ItemStack.STREAM_CODEC, RecipeSingleItem::result, var0::create);

        protected b(a<T> var0) {
        }

        @Override
        public MapCodec<T> codec() {
            return this.codec;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
            return this.streamCodec;
        }
    }
}

