/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.MinecartTrackLogic;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyTrackPosition;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public abstract class BlockMinecartTrackAbstract
extends Block
implements IBlockWaterlogged {
    public static final BlockStateBoolean WATERLOGGED = BlockProperties.WATERLOGGED;
    private static final VoxelShape SHAPE_FLAT = Block.column(16.0, 0.0, 2.0);
    private static final VoxelShape SHAPE_SLOPE = Block.column(16.0, 0.0, 8.0);
    private final boolean isStraight;

    public static boolean isRail(World var0, BlockPosition var1) {
        return BlockMinecartTrackAbstract.isRail(var0.getBlockState(var1));
    }

    public static boolean isRail(IBlockData var0) {
        return var0.is(TagsBlock.RAILS) && var0.getBlock() instanceof BlockMinecartTrackAbstract;
    }

    protected BlockMinecartTrackAbstract(boolean var0, BlockBase.Info var1) {
        super(var1);
        this.isStraight = var0;
    }

    protected abstract MapCodec<? extends BlockMinecartTrackAbstract> codec();

    public boolean isStraight() {
        return this.isStraight;
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return var0.getValue(this.getShapeProperty()).isSlope() ? SHAPE_SLOPE : SHAPE_FLAT;
    }

    @Override
    protected boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        return BlockMinecartTrackAbstract.canSupportRigidBlock(var1, var2.below());
    }

    @Override
    protected void onPlace(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        if (var3.is(var0.getBlock())) {
            return;
        }
        this.updateState(var0, var1, var2, var4);
    }

    protected IBlockData updateState(IBlockData var0, World var1, BlockPosition var2, boolean var3) {
        var0 = this.updateDir(var1, var2, var0, true);
        if (this.isStraight) {
            var1.neighborChanged(var0, var2, this, null, var3);
        }
        return var0;
    }

    @Override
    protected void neighborChanged(IBlockData var0, World var1, BlockPosition var2, Block var3, @Nullable Orientation var4, boolean var5) {
        if (var1.isClientSide || !var1.getBlockState(var2).is(this)) {
            return;
        }
        BlockPropertyTrackPosition var6 = var0.getValue(this.getShapeProperty());
        if (BlockMinecartTrackAbstract.shouldBeRemoved(var2, var1, var6)) {
            BlockMinecartTrackAbstract.dropResources(var0, var1, var2);
            var1.removeBlock(var2, var5);
        } else {
            this.updateState(var0, var1, var2, var3);
        }
    }

    private static boolean shouldBeRemoved(BlockPosition var0, World var1, BlockPropertyTrackPosition var2) {
        if (!BlockMinecartTrackAbstract.canSupportRigidBlock(var1, var0.below())) {
            return true;
        }
        switch (var2) {
            case ASCENDING_EAST: {
                return !BlockMinecartTrackAbstract.canSupportRigidBlock(var1, var0.east());
            }
            case ASCENDING_WEST: {
                return !BlockMinecartTrackAbstract.canSupportRigidBlock(var1, var0.west());
            }
            case ASCENDING_NORTH: {
                return !BlockMinecartTrackAbstract.canSupportRigidBlock(var1, var0.north());
            }
            case ASCENDING_SOUTH: {
                return !BlockMinecartTrackAbstract.canSupportRigidBlock(var1, var0.south());
            }
        }
        return false;
    }

    protected void updateState(IBlockData var0, World var1, BlockPosition var2, Block var3) {
    }

    protected IBlockData updateDir(World var0, BlockPosition var1, IBlockData var2, boolean var3) {
        if (var0.isClientSide) {
            return var2;
        }
        BlockPropertyTrackPosition var4 = var2.getValue(this.getShapeProperty());
        return new MinecartTrackLogic(var0, var1, var2).place(var0.hasNeighborSignal(var1), var3, var4).getState();
    }

    @Override
    protected void affectNeighborsAfterRemoval(IBlockData var0, WorldServer var1, BlockPosition var2, boolean var3) {
        if (var3) {
            return;
        }
        if (var0.getValue(this.getShapeProperty()).isSlope()) {
            var1.updateNeighborsAt(var2.above(), this);
        }
        if (this.isStraight) {
            var1.updateNeighborsAt(var2, this);
            var1.updateNeighborsAt(var2.below(), this);
        }
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        Fluid var1 = var0.getLevel().getFluidState(var0.getClickedPos());
        boolean var2 = var1.getType() == FluidTypes.WATER;
        IBlockData var3 = super.defaultBlockState();
        EnumDirection var4 = var0.getHorizontalDirection();
        boolean var5 = var4 == EnumDirection.EAST || var4 == EnumDirection.WEST;
        return (IBlockData)((IBlockData)var3.setValue(this.getShapeProperty(), var5 ? BlockPropertyTrackPosition.EAST_WEST : BlockPropertyTrackPosition.NORTH_SOUTH)).setValue(WATERLOGGED, var2);
    }

    public abstract IBlockState<BlockPropertyTrackPosition> getShapeProperty();

    protected BlockPropertyTrackPosition rotate(BlockPropertyTrackPosition var0, EnumBlockRotation var1) {
        return switch (var1) {
            case EnumBlockRotation.CLOCKWISE_180 -> {
                switch (var0) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case NORTH_SOUTH: {
                        yield BlockPropertyTrackPosition.NORTH_SOUTH;
                    }
                    case EAST_WEST: {
                        yield BlockPropertyTrackPosition.EAST_WEST;
                    }
                    case ASCENDING_EAST: {
                        yield BlockPropertyTrackPosition.ASCENDING_WEST;
                    }
                    case ASCENDING_WEST: {
                        yield BlockPropertyTrackPosition.ASCENDING_EAST;
                    }
                    case ASCENDING_NORTH: {
                        yield BlockPropertyTrackPosition.ASCENDING_SOUTH;
                    }
                    case ASCENDING_SOUTH: {
                        yield BlockPropertyTrackPosition.ASCENDING_NORTH;
                    }
                    case SOUTH_EAST: {
                        yield BlockPropertyTrackPosition.NORTH_WEST;
                    }
                    case SOUTH_WEST: {
                        yield BlockPropertyTrackPosition.NORTH_EAST;
                    }
                    case NORTH_WEST: {
                        yield BlockPropertyTrackPosition.SOUTH_EAST;
                    }
                    case NORTH_EAST: 
                }
                yield BlockPropertyTrackPosition.SOUTH_WEST;
            }
            case EnumBlockRotation.COUNTERCLOCKWISE_90 -> {
                switch (var0) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case NORTH_SOUTH: {
                        yield BlockPropertyTrackPosition.EAST_WEST;
                    }
                    case EAST_WEST: {
                        yield BlockPropertyTrackPosition.NORTH_SOUTH;
                    }
                    case ASCENDING_EAST: {
                        yield BlockPropertyTrackPosition.ASCENDING_NORTH;
                    }
                    case ASCENDING_WEST: {
                        yield BlockPropertyTrackPosition.ASCENDING_SOUTH;
                    }
                    case ASCENDING_NORTH: {
                        yield BlockPropertyTrackPosition.ASCENDING_WEST;
                    }
                    case ASCENDING_SOUTH: {
                        yield BlockPropertyTrackPosition.ASCENDING_EAST;
                    }
                    case SOUTH_EAST: {
                        yield BlockPropertyTrackPosition.NORTH_EAST;
                    }
                    case SOUTH_WEST: {
                        yield BlockPropertyTrackPosition.SOUTH_EAST;
                    }
                    case NORTH_WEST: {
                        yield BlockPropertyTrackPosition.SOUTH_WEST;
                    }
                    case NORTH_EAST: 
                }
                yield BlockPropertyTrackPosition.NORTH_WEST;
            }
            case EnumBlockRotation.CLOCKWISE_90 -> {
                switch (var0) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case NORTH_SOUTH: {
                        yield BlockPropertyTrackPosition.EAST_WEST;
                    }
                    case EAST_WEST: {
                        yield BlockPropertyTrackPosition.NORTH_SOUTH;
                    }
                    case ASCENDING_EAST: {
                        yield BlockPropertyTrackPosition.ASCENDING_SOUTH;
                    }
                    case ASCENDING_WEST: {
                        yield BlockPropertyTrackPosition.ASCENDING_NORTH;
                    }
                    case ASCENDING_NORTH: {
                        yield BlockPropertyTrackPosition.ASCENDING_EAST;
                    }
                    case ASCENDING_SOUTH: {
                        yield BlockPropertyTrackPosition.ASCENDING_WEST;
                    }
                    case SOUTH_EAST: {
                        yield BlockPropertyTrackPosition.SOUTH_WEST;
                    }
                    case SOUTH_WEST: {
                        yield BlockPropertyTrackPosition.NORTH_WEST;
                    }
                    case NORTH_WEST: {
                        yield BlockPropertyTrackPosition.NORTH_EAST;
                    }
                    case NORTH_EAST: 
                }
                yield BlockPropertyTrackPosition.SOUTH_EAST;
            }
            default -> var0;
        };
    }

    protected BlockPropertyTrackPosition mirror(BlockPropertyTrackPosition var0, EnumBlockMirror var1) {
        return switch (var1) {
            case EnumBlockMirror.LEFT_RIGHT -> {
                switch (var0) {
                    case ASCENDING_NORTH: {
                        yield BlockPropertyTrackPosition.ASCENDING_SOUTH;
                    }
                    case ASCENDING_SOUTH: {
                        yield BlockPropertyTrackPosition.ASCENDING_NORTH;
                    }
                    case SOUTH_EAST: {
                        yield BlockPropertyTrackPosition.NORTH_EAST;
                    }
                    case SOUTH_WEST: {
                        yield BlockPropertyTrackPosition.NORTH_WEST;
                    }
                    case NORTH_WEST: {
                        yield BlockPropertyTrackPosition.SOUTH_WEST;
                    }
                    case NORTH_EAST: {
                        yield BlockPropertyTrackPosition.SOUTH_EAST;
                    }
                }
                yield var0;
            }
            case EnumBlockMirror.FRONT_BACK -> {
                switch (var0) {
                    case ASCENDING_EAST: {
                        yield BlockPropertyTrackPosition.ASCENDING_WEST;
                    }
                    case ASCENDING_WEST: {
                        yield BlockPropertyTrackPosition.ASCENDING_EAST;
                    }
                    case SOUTH_EAST: {
                        yield BlockPropertyTrackPosition.SOUTH_WEST;
                    }
                    case SOUTH_WEST: {
                        yield BlockPropertyTrackPosition.SOUTH_EAST;
                    }
                    case NORTH_WEST: {
                        yield BlockPropertyTrackPosition.NORTH_EAST;
                    }
                    case NORTH_EAST: {
                        yield BlockPropertyTrackPosition.NORTH_WEST;
                    }
                }
                yield var0;
            }
            default -> var0;
        };
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, IWorldReader var1, ScheduledTickAccess var2, BlockPosition var3, EnumDirection var4, BlockPosition var5, IBlockData var6, RandomSource var7) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            var2.scheduleTick(var3, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(var1));
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    @Override
    protected Fluid getFluidState(IBlockData var0) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            return FluidTypes.WATER.getSource(false);
        }
        return super.getFluidState(var0);
    }
}

