/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleParamRedstone;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ARGB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockObserver;
import net.minecraft.world.level.block.BlockRepeater;
import net.minecraft.world.level.block.BlockTrapdoor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyRedstoneSide;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.redstone.DefaultRedstoneWireEvaluator;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.ExperimentalRedstoneWireEvaluator;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.level.redstone.RedstoneWireEvaluator;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class BlockRedstoneWire
extends Block {
    public static final MapCodec<BlockRedstoneWire> CODEC = BlockRedstoneWire.simpleCodec(BlockRedstoneWire::new);
    public static final BlockStateEnum<BlockPropertyRedstoneSide> NORTH = BlockProperties.NORTH_REDSTONE;
    public static final BlockStateEnum<BlockPropertyRedstoneSide> EAST = BlockProperties.EAST_REDSTONE;
    public static final BlockStateEnum<BlockPropertyRedstoneSide> SOUTH = BlockProperties.SOUTH_REDSTONE;
    public static final BlockStateEnum<BlockPropertyRedstoneSide> WEST = BlockProperties.WEST_REDSTONE;
    public static final BlockStateInteger POWER = BlockProperties.POWER;
    public static final Map<EnumDirection, BlockStateEnum<BlockPropertyRedstoneSide>> PROPERTY_BY_DIRECTION = ImmutableMap.copyOf((Map)Maps.newEnumMap(Map.of(EnumDirection.NORTH, NORTH, EnumDirection.EAST, EAST, EnumDirection.SOUTH, SOUTH, EnumDirection.WEST, WEST)));
    private static final int[] COLORS = SystemUtils.make(new int[16], var0 -> {
        for (int var1 = 0; var1 <= 15; ++var1) {
            float var2;
            float var3 = var2 * 0.6f + ((var2 = (float)var1 / 15.0f) > 0.0f ? 0.4f : 0.3f);
            float var4 = MathHelper.clamp(var2 * var2 * 0.7f - 0.5f, 0.0f, 1.0f);
            float var5 = MathHelper.clamp(var2 * var2 * 0.6f - 0.7f, 0.0f, 1.0f);
            var0[var1] = ARGB.colorFromFloat(1.0f, var3, var4, var5);
        }
    });
    private static final float PARTICLE_DENSITY = 0.2f;
    private final Function<IBlockData, VoxelShape> shapes;
    private final IBlockData crossState;
    private final RedstoneWireEvaluator evaluator = new DefaultRedstoneWireEvaluator(this);
    private boolean shouldSignal = true;

    public MapCodec<BlockRedstoneWire> codec() {
        return CODEC;
    }

    public BlockRedstoneWire(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(NORTH, BlockPropertyRedstoneSide.NONE)).setValue(EAST, BlockPropertyRedstoneSide.NONE)).setValue(SOUTH, BlockPropertyRedstoneSide.NONE)).setValue(WEST, BlockPropertyRedstoneSide.NONE)).setValue(POWER, 0));
        this.shapes = this.makeShapes();
        this.crossState = (IBlockData)((IBlockData)((IBlockData)((IBlockData)this.defaultBlockState().setValue(NORTH, BlockPropertyRedstoneSide.SIDE)).setValue(EAST, BlockPropertyRedstoneSide.SIDE)).setValue(SOUTH, BlockPropertyRedstoneSide.SIDE)).setValue(WEST, BlockPropertyRedstoneSide.SIDE);
    }

    private Function<IBlockData, VoxelShape> makeShapes() {
        boolean var0 = true;
        int var1 = 10;
        VoxelShape var2 = Block.column(10.0, 0.0, 1.0);
        Map<EnumDirection, VoxelShape> var32 = VoxelShapes.rotateHorizontal(Block.boxZ(10.0, 0.0, 1.0, 0.0, 8.0));
        Map<EnumDirection, VoxelShape> var4 = VoxelShapes.rotateHorizontal(Block.boxZ(10.0, 16.0, 0.0, 1.0));
        return this.getShapeForEachState(var3 -> {
            VoxelShape var4 = var2;
            for (Map.Entry<EnumDirection, BlockStateEnum<BlockPropertyRedstoneSide>> var6 : PROPERTY_BY_DIRECTION.entrySet()) {
                var4 = switch ((BlockPropertyRedstoneSide)var3.getValue(var6.getValue())) {
                    default -> throw new MatchException(null, null);
                    case BlockPropertyRedstoneSide.UP -> VoxelShapes.or(var4, (VoxelShape)var32.get(var6.getKey()), (VoxelShape)var4.get(var6.getKey()));
                    case BlockPropertyRedstoneSide.SIDE -> VoxelShapes.or(var4, (VoxelShape)var32.get(var6.getKey()));
                    case BlockPropertyRedstoneSide.NONE -> var4;
                };
            }
            return var4;
        }, POWER);
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return this.shapes.apply(var0);
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        return this.getConnectionState(var0.getLevel(), this.crossState, var0.getClickedPos());
    }

    private IBlockData getConnectionState(IBlockAccess var0, IBlockData var1, BlockPosition var2) {
        boolean var9;
        boolean var3 = BlockRedstoneWire.isDot(var1);
        var1 = this.getMissingConnections(var0, (IBlockData)this.defaultBlockState().setValue(POWER, var1.getValue(POWER)), var2);
        if (var3 && BlockRedstoneWire.isDot(var1)) {
            return var1;
        }
        boolean var4 = var1.getValue(NORTH).isConnected();
        boolean var5 = var1.getValue(SOUTH).isConnected();
        boolean var6 = var1.getValue(EAST).isConnected();
        boolean var7 = var1.getValue(WEST).isConnected();
        boolean var8 = !var4 && !var5;
        boolean bl = var9 = !var6 && !var7;
        if (!var7 && var8) {
            var1 = (IBlockData)var1.setValue(WEST, BlockPropertyRedstoneSide.SIDE);
        }
        if (!var6 && var8) {
            var1 = (IBlockData)var1.setValue(EAST, BlockPropertyRedstoneSide.SIDE);
        }
        if (!var4 && var9) {
            var1 = (IBlockData)var1.setValue(NORTH, BlockPropertyRedstoneSide.SIDE);
        }
        if (!var5 && var9) {
            var1 = (IBlockData)var1.setValue(SOUTH, BlockPropertyRedstoneSide.SIDE);
        }
        return var1;
    }

    private IBlockData getMissingConnections(IBlockAccess var0, IBlockData var1, BlockPosition var2) {
        boolean var3 = !var0.getBlockState(var2.above()).isRedstoneConductor(var0, var2);
        for (EnumDirection var5 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            if (((BlockPropertyRedstoneSide)var1.getValue(PROPERTY_BY_DIRECTION.get(var5))).isConnected()) continue;
            BlockPropertyRedstoneSide var6 = this.getConnectingSide(var0, var2, var5, var3);
            var1 = (IBlockData)var1.setValue(PROPERTY_BY_DIRECTION.get(var5), var6);
        }
        return var1;
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, IWorldReader var1, ScheduledTickAccess var2, BlockPosition var3, EnumDirection var4, BlockPosition var5, IBlockData var6, RandomSource var7) {
        if (var4 == EnumDirection.DOWN) {
            if (!this.canSurviveOn(var1, var5, var6)) {
                return Blocks.AIR.defaultBlockState();
            }
            return var0;
        }
        if (var4 == EnumDirection.UP) {
            return this.getConnectionState(var1, var0, var3);
        }
        BlockPropertyRedstoneSide var8 = this.getConnectingSide(var1, var3, var4);
        if (var8.isConnected() == ((BlockPropertyRedstoneSide)var0.getValue(PROPERTY_BY_DIRECTION.get(var4))).isConnected() && !BlockRedstoneWire.isCross(var0)) {
            return (IBlockData)var0.setValue(PROPERTY_BY_DIRECTION.get(var4), var8);
        }
        return this.getConnectionState(var1, (IBlockData)((IBlockData)this.crossState.setValue(POWER, var0.getValue(POWER))).setValue(PROPERTY_BY_DIRECTION.get(var4), var8), var3);
    }

    private static boolean isCross(IBlockData var0) {
        return var0.getValue(NORTH).isConnected() && var0.getValue(SOUTH).isConnected() && var0.getValue(EAST).isConnected() && var0.getValue(WEST).isConnected();
    }

    private static boolean isDot(IBlockData var0) {
        return !var0.getValue(NORTH).isConnected() && !var0.getValue(SOUTH).isConnected() && !var0.getValue(EAST).isConnected() && !var0.getValue(WEST).isConnected();
    }

    @Override
    protected void updateIndirectNeighbourShapes(IBlockData var0, GeneratorAccess var1, BlockPosition var2, int var3, int var4) {
        BlockPosition.MutableBlockPosition var5 = new BlockPosition.MutableBlockPosition();
        for (EnumDirection var7 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            Object var10;
            BlockPropertyRedstoneSide var8 = (BlockPropertyRedstoneSide)var0.getValue(PROPERTY_BY_DIRECTION.get(var7));
            if (var8 == BlockPropertyRedstoneSide.NONE || var1.getBlockState(var5.setWithOffset((BaseBlockPosition)var2, var7)).is(this)) continue;
            var5.move(EnumDirection.DOWN);
            IBlockData var9 = var1.getBlockState(var5);
            if (var9.is(this)) {
                var10 = var5.relative(var7.getOpposite());
                var1.neighborShapeChanged(var7.getOpposite(), var5, (BlockPosition)var10, var1.getBlockState((BlockPosition)var10), var3, var4);
            }
            var5.setWithOffset((BaseBlockPosition)var2, var7).move(EnumDirection.UP);
            var10 = var1.getBlockState(var5);
            if (!((BlockBase.BlockData)var10).is(this)) continue;
            BaseBlockPosition var11 = var5.relative(var7.getOpposite());
            var1.neighborShapeChanged(var7.getOpposite(), var5, (BlockPosition)var11, var1.getBlockState((BlockPosition)var11), var3, var4);
        }
    }

    private BlockPropertyRedstoneSide getConnectingSide(IBlockAccess var0, BlockPosition var1, EnumDirection var2) {
        return this.getConnectingSide(var0, var1, var2, !var0.getBlockState(var1.above()).isRedstoneConductor(var0, var1));
    }

    private BlockPropertyRedstoneSide getConnectingSide(IBlockAccess var0, BlockPosition var1, EnumDirection var2, boolean var3) {
        BlockPosition var4 = var1.relative(var2);
        IBlockData var5 = var0.getBlockState(var4);
        if (var3) {
            boolean var6;
            boolean bl = var6 = var5.getBlock() instanceof BlockTrapdoor || this.canSurviveOn(var0, var4, var5);
            if (var6 && BlockRedstoneWire.shouldConnectTo(var0.getBlockState(var4.above()))) {
                if (var5.isFaceSturdy(var0, var4, var2.getOpposite())) {
                    return BlockPropertyRedstoneSide.UP;
                }
                return BlockPropertyRedstoneSide.SIDE;
            }
        }
        if (BlockRedstoneWire.shouldConnectTo(var5, var2) || !var5.isRedstoneConductor(var0, var4) && BlockRedstoneWire.shouldConnectTo(var0.getBlockState(var4.below()))) {
            return BlockPropertyRedstoneSide.SIDE;
        }
        return BlockPropertyRedstoneSide.NONE;
    }

    @Override
    protected boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        BlockPosition var3 = var2.below();
        IBlockData var4 = var1.getBlockState(var3);
        return this.canSurviveOn(var1, var3, var4);
    }

    private boolean canSurviveOn(IBlockAccess var0, BlockPosition var1, IBlockData var2) {
        return var2.isFaceSturdy(var0, var1, EnumDirection.UP) || var2.is(Blocks.HOPPER);
    }

    private void updatePowerStrength(World var0, BlockPosition var1, IBlockData var2, @Nullable Orientation var3, boolean var4) {
        if (BlockRedstoneWire.useExperimentalEvaluator(var0)) {
            new ExperimentalRedstoneWireEvaluator(this).updatePowerStrength(var0, var1, var2, var3, var4);
        } else {
            this.evaluator.updatePowerStrength(var0, var1, var2, var3, var4);
        }
    }

    public int getBlockSignal(World var0, BlockPosition var1) {
        this.shouldSignal = false;
        int var2 = var0.getBestNeighborSignal(var1);
        this.shouldSignal = true;
        return var2;
    }

    private void checkCornerChangeAt(World var0, BlockPosition var1) {
        if (!var0.getBlockState(var1).is(this)) {
            return;
        }
        var0.updateNeighborsAt(var1, this);
        for (EnumDirection var5 : EnumDirection.values()) {
            var0.updateNeighborsAt(var1.relative(var5), this);
        }
    }

    @Override
    protected void onPlace(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        if (var3.is(var0.getBlock()) || var1.isClientSide) {
            return;
        }
        this.updatePowerStrength(var1, var2, var0, null, true);
        for (EnumDirection var6 : EnumDirection.EnumDirectionLimit.VERTICAL) {
            var1.updateNeighborsAt(var2.relative(var6), this);
        }
        this.updateNeighborsOfNeighboringWires(var1, var2);
    }

    @Override
    protected void affectNeighborsAfterRemoval(IBlockData var0, WorldServer var1, BlockPosition var2, boolean var3) {
        if (var3) {
            return;
        }
        for (EnumDirection var7 : EnumDirection.values()) {
            var1.updateNeighborsAt(var2.relative(var7), this);
        }
        this.updatePowerStrength(var1, var2, var0, null, false);
        this.updateNeighborsOfNeighboringWires(var1, var2);
    }

    private void updateNeighborsOfNeighboringWires(World var0, BlockPosition var1) {
        for (EnumDirection var3 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            this.checkCornerChangeAt(var0, var1.relative(var3));
        }
        for (EnumDirection var3 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            BlockPosition var4 = var1.relative(var3);
            if (var0.getBlockState(var4).isRedstoneConductor(var0, var4)) {
                this.checkCornerChangeAt(var0, var4.above());
                continue;
            }
            this.checkCornerChangeAt(var0, var4.below());
        }
    }

    @Override
    protected void neighborChanged(IBlockData var0, World var1, BlockPosition var2, Block var3, @Nullable Orientation var4, boolean var5) {
        if (var1.isClientSide) {
            return;
        }
        if (var3 == this && BlockRedstoneWire.useExperimentalEvaluator(var1)) {
            return;
        }
        if (var0.canSurvive(var1, var2)) {
            this.updatePowerStrength(var1, var2, var0, var4, false);
        } else {
            BlockRedstoneWire.dropResources(var0, var1, var2);
            var1.removeBlock(var2, false);
        }
    }

    private static boolean useExperimentalEvaluator(World var0) {
        return var0.enabledFeatures().contains(FeatureFlags.REDSTONE_EXPERIMENTS);
    }

    @Override
    protected int getDirectSignal(IBlockData var0, IBlockAccess var1, BlockPosition var2, EnumDirection var3) {
        if (!this.shouldSignal) {
            return 0;
        }
        return var0.getSignal(var1, var2, var3);
    }

    @Override
    protected int getSignal(IBlockData var0, IBlockAccess var1, BlockPosition var2, EnumDirection var3) {
        if (!this.shouldSignal || var3 == EnumDirection.DOWN) {
            return 0;
        }
        int var4 = var0.getValue(POWER);
        if (var4 == 0) {
            return 0;
        }
        if (var3 == EnumDirection.UP || ((BlockPropertyRedstoneSide)this.getConnectionState(var1, var0, var2).getValue(PROPERTY_BY_DIRECTION.get(var3.getOpposite()))).isConnected()) {
            return var4;
        }
        return 0;
    }

    protected static boolean shouldConnectTo(IBlockData var0) {
        return BlockRedstoneWire.shouldConnectTo(var0, null);
    }

    protected static boolean shouldConnectTo(IBlockData var0, @Nullable EnumDirection var1) {
        if (var0.is(Blocks.REDSTONE_WIRE)) {
            return true;
        }
        if (var0.is(Blocks.REPEATER)) {
            EnumDirection var2 = (EnumDirection)var0.getValue(BlockRepeater.FACING);
            return var2 == var1 || var2.getOpposite() == var1;
        }
        if (var0.is(Blocks.OBSERVER)) {
            return var1 == var0.getValue(BlockObserver.FACING);
        }
        return var0.isSignalSource() && var1 != null;
    }

    @Override
    protected boolean isSignalSource(IBlockData var0) {
        return this.shouldSignal;
    }

    public static int getColorForPower(int var0) {
        return COLORS[var0];
    }

    private static void spawnParticlesAlongLine(World var0, RandomSource var1, BlockPosition var2, int var3, EnumDirection var4, EnumDirection var5, float var6, float var7) {
        float var8 = var7 - var6;
        if (var1.nextFloat() >= 0.2f * var8) {
            return;
        }
        float var9 = 0.4375f;
        float var10 = var6 + var8 * var1.nextFloat();
        double var11 = 0.5 + (double)(0.4375f * (float)var4.getStepX()) + (double)(var10 * (float)var5.getStepX());
        double var13 = 0.5 + (double)(0.4375f * (float)var4.getStepY()) + (double)(var10 * (float)var5.getStepY());
        double var15 = 0.5 + (double)(0.4375f * (float)var4.getStepZ()) + (double)(var10 * (float)var5.getStepZ());
        var0.addParticle(new ParticleParamRedstone(var3, 1.0f), (double)var2.getX() + var11, (double)var2.getY() + var13, (double)var2.getZ() + var15, 0.0, 0.0, 0.0);
    }

    @Override
    public void animateTick(IBlockData var0, World var1, BlockPosition var2, RandomSource var3) {
        int var4 = var0.getValue(POWER);
        if (var4 == 0) {
            return;
        }
        block4: for (EnumDirection var6 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            BlockPropertyRedstoneSide var7 = (BlockPropertyRedstoneSide)var0.getValue(PROPERTY_BY_DIRECTION.get(var6));
            switch (var7) {
                case UP: {
                    BlockRedstoneWire.spawnParticlesAlongLine(var1, var3, var2, COLORS[var4], var6, EnumDirection.UP, -0.5f, 0.5f);
                }
                case SIDE: {
                    BlockRedstoneWire.spawnParticlesAlongLine(var1, var3, var2, COLORS[var4], EnumDirection.DOWN, var6, 0.0f, 0.5f);
                    continue block4;
                }
            }
            BlockRedstoneWire.spawnParticlesAlongLine(var1, var3, var2, COLORS[var4], EnumDirection.DOWN, var6, 0.0f, 0.3f);
        }
    }

    @Override
    protected IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        switch (var1) {
            case CLOCKWISE_180: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)var0.setValue(NORTH, var0.getValue(SOUTH))).setValue(EAST, var0.getValue(WEST))).setValue(SOUTH, var0.getValue(NORTH))).setValue(WEST, var0.getValue(EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)var0.setValue(NORTH, var0.getValue(EAST))).setValue(EAST, var0.getValue(SOUTH))).setValue(SOUTH, var0.getValue(WEST))).setValue(WEST, var0.getValue(NORTH));
            }
            case CLOCKWISE_90: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)var0.setValue(NORTH, var0.getValue(WEST))).setValue(EAST, var0.getValue(NORTH))).setValue(SOUTH, var0.getValue(EAST))).setValue(WEST, var0.getValue(SOUTH));
            }
        }
        return var0;
    }

    @Override
    protected IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        switch (var1) {
            case LEFT_RIGHT: {
                return (IBlockData)((IBlockData)var0.setValue(NORTH, var0.getValue(SOUTH))).setValue(SOUTH, var0.getValue(NORTH));
            }
            case FRONT_BACK: {
                return (IBlockData)((IBlockData)var0.setValue(EAST, var0.getValue(WEST))).setValue(WEST, var0.getValue(EAST));
            }
        }
        return super.mirror(var0, var1);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(NORTH, EAST, SOUTH, WEST, POWER);
    }

    @Override
    protected EnumInteractionResult useWithoutItem(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, MovingObjectPositionBlock var4) {
        if (!var3.getAbilities().mayBuild) {
            return EnumInteractionResult.PASS;
        }
        if (BlockRedstoneWire.isCross(var0) || BlockRedstoneWire.isDot(var0)) {
            IBlockData var5 = BlockRedstoneWire.isCross(var0) ? this.defaultBlockState() : this.crossState;
            var5 = (IBlockData)var5.setValue(POWER, var0.getValue(POWER));
            if ((var5 = this.getConnectionState(var1, var5, var2)) != var0) {
                var1.setBlock(var2, var5, 3);
                this.updatesOnShapeChange(var1, var2, var0, var5);
                return EnumInteractionResult.SUCCESS;
            }
        }
        return EnumInteractionResult.PASS;
    }

    private void updatesOnShapeChange(World var0, BlockPosition var1, IBlockData var2, IBlockData var3) {
        Orientation var4 = ExperimentalRedstoneUtils.initialOrientation(var0, null, EnumDirection.UP);
        for (EnumDirection var6 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            BlockPosition var7 = var1.relative(var6);
            if (((BlockPropertyRedstoneSide)var2.getValue(PROPERTY_BY_DIRECTION.get(var6))).isConnected() == ((BlockPropertyRedstoneSide)var3.getValue(PROPERTY_BY_DIRECTION.get(var6))).isConnected() || !var0.getBlockState(var7).isRedstoneConductor(var0, var7)) continue;
            var0.updateNeighborsAtExceptFromFacing(var7, var3.getBlock(), var6.getOpposite(), ExperimentalRedstoneUtils.withFront(var4, var6));
        }
    }
}

