/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockSign;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyWood;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class BlockWallSign
extends BlockSign {
    public static final MapCodec<BlockWallSign> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)BlockPropertyWood.CODEC.fieldOf("wood_type").forGetter(BlockSign::type), BlockWallSign.propertiesCodec()).apply((Applicative)var0, BlockWallSign::new));
    public static final BlockStateEnum<EnumDirection> FACING = BlockFacingHorizontal.FACING;
    private static final Map<EnumDirection, VoxelShape> SHAPES = VoxelShapes.rotateHorizontal(Block.boxZ(16.0, 4.5, 12.5, 14.0, 16.0));

    public MapCodec<BlockWallSign> codec() {
        return CODEC;
    }

    public BlockWallSign(BlockPropertyWood var0, BlockBase.Info var1) {
        super(var0, var1.sound(var0.soundType()));
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(FACING, EnumDirection.NORTH)).setValue(WATERLOGGED, false));
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPES.get(var0.getValue(FACING));
    }

    @Override
    protected boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        return var1.getBlockState(var2.relative(var0.getValue(FACING).getOpposite())).isSolid();
    }

    @Override
    @Nullable
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        EnumDirection[] var5;
        IBlockData var1 = this.defaultBlockState();
        Fluid var2 = var0.getLevel().getFluidState(var0.getClickedPos());
        World var3 = var0.getLevel();
        BlockPosition var4 = var0.getClickedPos();
        for (EnumDirection var9 : var5 = var0.getNearestLookingDirections()) {
            EnumDirection var10;
            if (!var9.getAxis().isHorizontal() || !(var1 = (IBlockData)var1.setValue(FACING, var10 = var9.getOpposite())).canSurvive(var3, var4)) continue;
            return (IBlockData)var1.setValue(WATERLOGGED, var2.getType() == FluidTypes.WATER);
        }
        return null;
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, IWorldReader var1, ScheduledTickAccess var2, BlockPosition var3, EnumDirection var4, BlockPosition var5, IBlockData var6, RandomSource var7) {
        if (var4.getOpposite() == var0.getValue(FACING) && !var0.canSurvive(var1, var3)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    @Override
    public float getYRotationDegrees(IBlockData var0) {
        return var0.getValue(FACING).toYRot();
    }

    @Override
    public Vec3D getSignHitboxCenterPosition(IBlockData var0) {
        return SHAPES.get(var0.getValue(FACING)).bounds().getCenter();
    }

    @Override
    protected IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        return (IBlockData)var0.setValue(FACING, var1.rotate(var0.getValue(FACING)));
    }

    @Override
    protected IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        return var0.rotate(var1.getRotation(var0.getValue(FACING)));
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(FACING, WATERLOGGED);
    }
}

