/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.RodBlock;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;

public class LightningRodBlock
extends RodBlock
implements IBlockWaterlogged {
    public static final MapCodec<LightningRodBlock> CODEC = LightningRodBlock.simpleCodec(LightningRodBlock::new);
    public static final BlockStateBoolean WATERLOGGED = BlockProperties.WATERLOGGED;
    public static final BlockStateBoolean POWERED = BlockProperties.POWERED;
    private static final int ACTIVATION_TICKS = 8;
    public static final int RANGE = 128;
    private static final int SPARK_CYCLE = 200;

    public MapCodec<LightningRodBlock> codec() {
        return CODEC;
    }

    public LightningRodBlock(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(FACING, EnumDirection.UP)).setValue(WATERLOGGED, false)).setValue(POWERED, false));
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        Fluid var1 = var0.getLevel().getFluidState(var0.getClickedPos());
        boolean var2 = var1.getType() == FluidTypes.WATER;
        return (IBlockData)((IBlockData)this.defaultBlockState().setValue(FACING, var0.getClickedFace())).setValue(WATERLOGGED, var2);
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, IWorldReader var1, ScheduledTickAccess var2, BlockPosition var3, EnumDirection var4, BlockPosition var5, IBlockData var6, RandomSource var7) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            var2.scheduleTick(var3, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(var1));
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    @Override
    protected Fluid getFluidState(IBlockData var0) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            return FluidTypes.WATER.getSource(false);
        }
        return super.getFluidState(var0);
    }

    @Override
    protected int getSignal(IBlockData var0, IBlockAccess var1, BlockPosition var2, EnumDirection var3) {
        return var0.getValue(POWERED) != false ? 15 : 0;
    }

    @Override
    protected int getDirectSignal(IBlockData var0, IBlockAccess var1, BlockPosition var2, EnumDirection var3) {
        if (var0.getValue(POWERED).booleanValue() && var0.getValue(FACING) == var3) {
            return 15;
        }
        return 0;
    }

    public void onLightningStrike(IBlockData var0, World var1, BlockPosition var2) {
        var1.setBlock(var2, (IBlockData)var0.setValue(POWERED, true), 3);
        this.updateNeighbours(var0, var1, var2);
        var1.scheduleTick(var2, this, 8);
        var1.levelEvent(3002, var2, ((EnumDirection)var0.getValue(FACING)).getAxis().ordinal());
    }

    private void updateNeighbours(IBlockData var0, World var1, BlockPosition var2) {
        EnumDirection var3 = ((EnumDirection)var0.getValue(FACING)).getOpposite();
        var1.updateNeighborsAt(var2.relative(var3), this, ExperimentalRedstoneUtils.initialOrientation(var1, var3, null));
    }

    @Override
    protected void tick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        var1.setBlock(var2, (IBlockData)var0.setValue(POWERED, false), 3);
        this.updateNeighbours(var0, var1, var2);
    }

    @Override
    public void animateTick(IBlockData var0, World var1, BlockPosition var2, RandomSource var3) {
        if (!var1.isThundering() || (long)var1.random.nextInt(200) > var1.getGameTime() % 200L || var2.getY() != var1.getHeight(HeightMap.Type.WORLD_SURFACE, var2.getX(), var2.getZ()) - 1) {
            return;
        }
        ParticleUtils.spawnParticlesAlongAxis(((EnumDirection)var0.getValue(FACING)).getAxis(), var1, var2, 0.125, Particles.ELECTRIC_SPARK, UniformInt.of(1, 2));
    }

    @Override
    protected void affectNeighborsAfterRemoval(IBlockData var0, WorldServer var1, BlockPosition var2, boolean var3) {
        if (var0.getValue(POWERED).booleanValue()) {
            this.updateNeighbours(var0, var1, var2);
        }
    }

    @Override
    protected void onPlace(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        if (var0.is(var3.getBlock())) {
            return;
        }
        if (var0.getValue(POWERED).booleanValue() && !var1.getBlockTicks().hasScheduledTick(var2, this)) {
            var1.setBlock(var2, (IBlockData)var0.setValue(POWERED, false), 18);
        }
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(FACING, POWERED, WATERLOGGED);
    }

    @Override
    protected boolean isSignalSource(IBlockData var0) {
        return true;
    }
}

