/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.piston;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.piston.BlockPiston;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.EnumPistonReaction;

public class PistonExtendsChecker {
    public static final int MAX_PUSH_DEPTH = 12;
    private final World level;
    private final BlockPosition pistonPos;
    private final boolean extending;
    private final BlockPosition startPos;
    private final EnumDirection pushDirection;
    private final List<BlockPosition> toPush = Lists.newArrayList();
    private final List<BlockPosition> toDestroy = Lists.newArrayList();
    private final EnumDirection pistonDirection;

    public PistonExtendsChecker(World var0, BlockPosition var1, EnumDirection var2, boolean var3) {
        this.level = var0;
        this.pistonPos = var1;
        this.pistonDirection = var2;
        this.extending = var3;
        if (var3) {
            this.pushDirection = var2;
            this.startPos = var1.relative(var2);
        } else {
            this.pushDirection = var2.getOpposite();
            this.startPos = var1.relative(var2, 2);
        }
    }

    public boolean resolve() {
        this.toPush.clear();
        this.toDestroy.clear();
        IBlockData var0 = this.level.getBlockState(this.startPos);
        if (!BlockPiston.isPushable(var0, this.level, this.startPos, this.pushDirection, false, this.pistonDirection)) {
            if (this.extending && var0.getPistonPushReaction() == EnumPistonReaction.DESTROY) {
                this.toDestroy.add(this.startPos);
                return true;
            }
            return false;
        }
        if (!this.addBlockLine(this.startPos, this.pushDirection)) {
            return false;
        }
        for (int var1 = 0; var1 < this.toPush.size(); ++var1) {
            BlockPosition var2 = this.toPush.get(var1);
            if (!PistonExtendsChecker.isSticky(this.level.getBlockState(var2)) || this.addBranchingBlocks(var2)) continue;
            return false;
        }
        return true;
    }

    private static boolean isSticky(IBlockData var0) {
        return var0.is(Blocks.SLIME_BLOCK) || var0.is(Blocks.HONEY_BLOCK);
    }

    private static boolean canStickToEachOther(IBlockData var0, IBlockData var1) {
        if (var0.is(Blocks.HONEY_BLOCK) && var1.is(Blocks.SLIME_BLOCK)) {
            return false;
        }
        if (var0.is(Blocks.SLIME_BLOCK) && var1.is(Blocks.HONEY_BLOCK)) {
            return false;
        }
        return PistonExtendsChecker.isSticky(var0) || PistonExtendsChecker.isSticky(var1);
    }

    private boolean addBlockLine(BlockPosition var0, EnumDirection var1) {
        int var5;
        IBlockData var2 = this.level.getBlockState(var0);
        if (var2.isAir()) {
            return true;
        }
        if (!BlockPiston.isPushable(var2, this.level, var0, this.pushDirection, false, var1)) {
            return true;
        }
        if (var0.equals(this.pistonPos)) {
            return true;
        }
        if (this.toPush.contains(var0)) {
            return true;
        }
        int var3 = 1;
        if (var3 + this.toPush.size() > 12) {
            return false;
        }
        while (PistonExtendsChecker.isSticky(var2)) {
            BlockPosition var4 = var0.relative(this.pushDirection.getOpposite(), var3);
            IBlockData var52 = var2;
            var2 = this.level.getBlockState(var4);
            if (var2.isAir() || !PistonExtendsChecker.canStickToEachOther(var52, var2) || !BlockPiston.isPushable(var2, this.level, var4, this.pushDirection, false, this.pushDirection.getOpposite()) || var4.equals(this.pistonPos)) break;
            if (++var3 + this.toPush.size() <= 12) continue;
            return false;
        }
        int var4 = 0;
        for (var5 = var3 - 1; var5 >= 0; --var5) {
            this.toPush.add(var0.relative(this.pushDirection.getOpposite(), var5));
            ++var4;
        }
        var5 = 1;
        while (true) {
            BlockPosition var6;
            int var7;
            if ((var7 = this.toPush.indexOf(var6 = var0.relative(this.pushDirection, var5))) > -1) {
                this.reorderListAtCollision(var4, var7);
                for (int var8 = 0; var8 <= var7 + var4; ++var8) {
                    BlockPosition var9 = this.toPush.get(var8);
                    if (!PistonExtendsChecker.isSticky(this.level.getBlockState(var9)) || this.addBranchingBlocks(var9)) continue;
                    return false;
                }
                return true;
            }
            var2 = this.level.getBlockState(var6);
            if (var2.isAir()) {
                return true;
            }
            if (!BlockPiston.isPushable(var2, this.level, var6, this.pushDirection, true, this.pushDirection) || var6.equals(this.pistonPos)) {
                return false;
            }
            if (var2.getPistonPushReaction() == EnumPistonReaction.DESTROY) {
                this.toDestroy.add(var6);
                return true;
            }
            if (this.toPush.size() >= 12) {
                return false;
            }
            this.toPush.add(var6);
            ++var4;
            ++var5;
        }
    }

    private void reorderListAtCollision(int var0, int var1) {
        ArrayList var2 = Lists.newArrayList();
        ArrayList var3 = Lists.newArrayList();
        ArrayList var4 = Lists.newArrayList();
        var2.addAll(this.toPush.subList(0, var1));
        var3.addAll(this.toPush.subList(this.toPush.size() - var0, this.toPush.size()));
        var4.addAll(this.toPush.subList(var1, this.toPush.size() - var0));
        this.toPush.clear();
        this.toPush.addAll(var2);
        this.toPush.addAll(var3);
        this.toPush.addAll(var4);
    }

    private boolean addBranchingBlocks(BlockPosition var0) {
        IBlockData var1 = this.level.getBlockState(var0);
        for (EnumDirection var5 : EnumDirection.values()) {
            BlockPosition var6;
            IBlockData var7;
            if (var5.getAxis() == this.pushDirection.getAxis() || !PistonExtendsChecker.canStickToEachOther(var7 = this.level.getBlockState(var6 = var0.relative(var5)), var1) || this.addBlockLine(var6, var5)) continue;
            return false;
        }
        return true;
    }

    public EnumDirection getPushDirection() {
        return this.pushDirection;
    }

    public List<BlockPosition> getToPush() {
        return this.toPush;
    }

    public List<BlockPosition> getToDestroy() {
        return this.toDestroy;
    }
}

