/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state.properties;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.util.INamable;
import net.minecraft.world.level.block.state.properties.IBlockState;

public final class BlockStateEnum<T extends Enum<T>>
extends IBlockState<T> {
    private final List<T> values;
    private final Map<String, T> names;
    private final int[] ordinalToIndex;

    private BlockStateEnum(String var0, Class<T> var1, List<T> var2) {
        super(var0, var1);
        if (var2.isEmpty()) {
            throw new IllegalArgumentException("Trying to make empty EnumProperty '" + var0 + "'");
        }
        this.values = List.copyOf(var2);
        Enum[] var3 = (Enum[])var1.getEnumConstants();
        this.ordinalToIndex = new int[var3.length];
        for (Enum enum_ : var3) {
            this.ordinalToIndex[enum_.ordinal()] = var2.indexOf(enum_);
        }
        ImmutableMap.Builder var4 = ImmutableMap.builder();
        for (Enum var6 : var2) {
            String string = ((INamable)((Object)var6)).getSerializedName();
            var4.put((Object)string, (Object)var6);
        }
        this.names = var4.buildOrThrow();
    }

    @Override
    public List<T> getPossibleValues() {
        return this.values;
    }

    @Override
    public Optional<T> getValue(String var0) {
        return Optional.ofNullable((Enum)this.names.get(var0));
    }

    @Override
    public String getName(T var0) {
        return ((INamable)var0).getSerializedName();
    }

    @Override
    public int getInternalIndex(T var0) {
        return this.ordinalToIndex[((Enum)var0).ordinal()];
    }

    @Override
    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 instanceof BlockStateEnum) {
            BlockStateEnum var1 = (BlockStateEnum)var0;
            if (super.equals(var0)) {
                return this.values.equals(var1.values);
            }
        }
        return false;
    }

    @Override
    public int generateHashCode() {
        int var0 = super.generateHashCode();
        var0 = 31 * var0 + this.values.hashCode();
        return var0;
    }

    public static <T extends Enum<T>> BlockStateEnum<T> create(String var02, Class<T> var1) {
        return BlockStateEnum.create(var02, var1, (T var0) -> true);
    }

    public static <T extends Enum<T>> BlockStateEnum<T> create(String var0, Class<T> var1, Predicate<T> var2) {
        return BlockStateEnum.create(var0, var1, Arrays.stream((Enum[])var1.getEnumConstants()).filter(var2).collect(Collectors.toList()));
    }

    @SafeVarargs
    public static <T extends Enum<T>> BlockStateEnum<T> create(String var0, Class<T> var1, T ... var2) {
        return BlockStateEnum.create(var0, var1, List.of(var2));
    }

    public static <T extends Enum<T>> BlockStateEnum<T> create(String var0, Class<T> var1, List<T> var2) {
        return new BlockStateEnum<T>(var0, var1, var2);
    }

    @Override
    public /* synthetic */ int getInternalIndex(Comparable comparable) {
        return this.getInternalIndex((Enum)((Object)comparable));
    }

    @Override
    public /* synthetic */ String getName(Comparable comparable) {
        return this.getName((Enum)((Object)comparable));
    }
}

