/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.border;

import com.google.common.collect.Lists;
import com.mojang.serialization.DynamicLike;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.border.BorderStatus;
import net.minecraft.world.level.border.IWorldBorderListener;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class WorldBorder {
    public static final double MAX_SIZE = 5.9999968E7;
    public static final double MAX_CENTER_COORDINATE = 2.9999984E7;
    private final List<IWorldBorderListener> listeners = Lists.newArrayList();
    private double damagePerBlock = 0.2;
    private double damageSafeZone = 5.0;
    private int warningTime = 15;
    private int warningBlocks = 5;
    private double centerX;
    private double centerZ;
    int absoluteMaxSize = 29999984;
    private a extent = new e(5.9999968E7);
    public static final d DEFAULT_SETTINGS = new d(0.0, 0.0, 0.2, 5.0, 5, 15, 5.9999968E7, 0L, 0.0);

    public boolean isWithinBounds(BlockPosition var0) {
        return this.isWithinBounds(var0.getX(), var0.getZ());
    }

    public boolean isWithinBounds(Vec3D var0) {
        return this.isWithinBounds(var0.x, var0.z);
    }

    public boolean isWithinBounds(ChunkCoordIntPair var0) {
        return this.isWithinBounds(var0.getMinBlockX(), var0.getMinBlockZ()) && this.isWithinBounds(var0.getMaxBlockX(), var0.getMaxBlockZ());
    }

    public boolean isWithinBounds(AxisAlignedBB var0) {
        return this.isWithinBounds(var0.minX, var0.minZ, var0.maxX - (double)1.0E-5f, var0.maxZ - (double)1.0E-5f);
    }

    private boolean isWithinBounds(double var0, double var2, double var4, double var6) {
        return this.isWithinBounds(var0, var2) && this.isWithinBounds(var4, var6);
    }

    public boolean isWithinBounds(double var0, double var2) {
        return this.isWithinBounds(var0, var2, 0.0);
    }

    public boolean isWithinBounds(double var0, double var2, double var4) {
        return var0 >= this.getMinX() - var4 && var0 < this.getMaxX() + var4 && var2 >= this.getMinZ() - var4 && var2 < this.getMaxZ() + var4;
    }

    public BlockPosition clampToBounds(BlockPosition var0) {
        return this.clampToBounds(var0.getX(), var0.getY(), var0.getZ());
    }

    public BlockPosition clampToBounds(Vec3D var0) {
        return this.clampToBounds(var0.x(), var0.y(), var0.z());
    }

    public BlockPosition clampToBounds(double var0, double var2, double var4) {
        return BlockPosition.containing(this.clampVec3ToBound(var0, var2, var4));
    }

    public Vec3D clampVec3ToBound(Vec3D var0) {
        return this.clampVec3ToBound(var0.x, var0.y, var0.z);
    }

    public Vec3D clampVec3ToBound(double var0, double var2, double var4) {
        return new Vec3D(MathHelper.clamp(var0, this.getMinX(), this.getMaxX() - (double)1.0E-5f), var2, MathHelper.clamp(var4, this.getMinZ(), this.getMaxZ() - (double)1.0E-5f));
    }

    public double getDistanceToBorder(Entity var0) {
        return this.getDistanceToBorder(var0.getX(), var0.getZ());
    }

    public VoxelShape getCollisionShape() {
        return this.extent.getCollisionShape();
    }

    public double getDistanceToBorder(double var0, double var2) {
        double var4 = var2 - this.getMinZ();
        double var6 = this.getMaxZ() - var2;
        double var8 = var0 - this.getMinX();
        double var10 = this.getMaxX() - var0;
        double var12 = Math.min(var8, var10);
        var12 = Math.min(var12, var4);
        return Math.min(var12, var6);
    }

    public List<b> closestBorder(double var02, double var2) {
        b[] var4 = new b[]{new b(EnumDirection.NORTH, var2 - this.getMinZ()), new b(EnumDirection.SOUTH, this.getMaxZ() - var2), new b(EnumDirection.WEST, var02 - this.getMinX()), new b(EnumDirection.EAST, this.getMaxX() - var02)};
        return Arrays.stream(var4).sorted(Comparator.comparingDouble(var0 -> var0.distance)).toList();
    }

    public boolean isInsideCloseToBorder(Entity var0, AxisAlignedBB var1) {
        double var2 = Math.max(MathHelper.absMax(var1.getXsize(), var1.getZsize()), 1.0);
        return this.getDistanceToBorder(var0) < var2 * 2.0 && this.isWithinBounds(var0.getX(), var0.getZ(), var2);
    }

    public BorderStatus getStatus() {
        return this.extent.getStatus();
    }

    public double getMinX() {
        return this.extent.getMinX();
    }

    public double getMinZ() {
        return this.extent.getMinZ();
    }

    public double getMaxX() {
        return this.extent.getMaxX();
    }

    public double getMaxZ() {
        return this.extent.getMaxZ();
    }

    public double getCenterX() {
        return this.centerX;
    }

    public double getCenterZ() {
        return this.centerZ;
    }

    public void setCenter(double var0, double var2) {
        this.centerX = var0;
        this.centerZ = var2;
        this.extent.onCenterChange();
        for (IWorldBorderListener var5 : this.getListeners()) {
            var5.onBorderCenterSet(this, var0, var2);
        }
    }

    public double getSize() {
        return this.extent.getSize();
    }

    public long getLerpRemainingTime() {
        return this.extent.getLerpRemainingTime();
    }

    public double getLerpTarget() {
        return this.extent.getLerpTarget();
    }

    public void setSize(double var0) {
        this.extent = new e(var0);
        for (IWorldBorderListener var3 : this.getListeners()) {
            var3.onBorderSizeSet(this, var0);
        }
    }

    public void lerpSizeBetween(double var0, double var2, long var4) {
        this.extent = var0 == var2 ? new e(var2) : new c(var0, var2, var4);
        for (IWorldBorderListener var7 : this.getListeners()) {
            var7.onBorderSizeLerping(this, var0, var2, var4);
        }
    }

    protected List<IWorldBorderListener> getListeners() {
        return Lists.newArrayList(this.listeners);
    }

    public void addListener(IWorldBorderListener var0) {
        this.listeners.add(var0);
    }

    public void removeListener(IWorldBorderListener var0) {
        this.listeners.remove(var0);
    }

    public void setAbsoluteMaxSize(int var0) {
        this.absoluteMaxSize = var0;
        this.extent.onAbsoluteMaxSizeChange();
    }

    public int getAbsoluteMaxSize() {
        return this.absoluteMaxSize;
    }

    public double getDamageSafeZone() {
        return this.damageSafeZone;
    }

    public void setDamageSafeZone(double var0) {
        this.damageSafeZone = var0;
        for (IWorldBorderListener var3 : this.getListeners()) {
            var3.onBorderSetDamageSafeZOne(this, var0);
        }
    }

    public double getDamagePerBlock() {
        return this.damagePerBlock;
    }

    public void setDamagePerBlock(double var0) {
        this.damagePerBlock = var0;
        for (IWorldBorderListener var3 : this.getListeners()) {
            var3.onBorderSetDamagePerBlock(this, var0);
        }
    }

    public double getLerpSpeed() {
        return this.extent.getLerpSpeed();
    }

    public int getWarningTime() {
        return this.warningTime;
    }

    public void setWarningTime(int var0) {
        this.warningTime = var0;
        for (IWorldBorderListener var2 : this.getListeners()) {
            var2.onBorderSetWarningTime(this, var0);
        }
    }

    public int getWarningBlocks() {
        return this.warningBlocks;
    }

    public void setWarningBlocks(int var0) {
        this.warningBlocks = var0;
        for (IWorldBorderListener var2 : this.getListeners()) {
            var2.onBorderSetWarningBlocks(this, var0);
        }
    }

    public void tick() {
        this.extent = this.extent.update();
    }

    public d createSettings() {
        return new d(this);
    }

    public void applySettings(d var0) {
        this.setCenter(var0.getCenterX(), var0.getCenterZ());
        this.setDamagePerBlock(var0.getDamagePerBlock());
        this.setDamageSafeZone(var0.getSafeZone());
        this.setWarningBlocks(var0.getWarningBlocks());
        this.setWarningTime(var0.getWarningTime());
        if (var0.getSizeLerpTime() > 0L) {
            this.lerpSizeBetween(var0.getSize(), var0.getSizeLerpTarget(), var0.getSizeLerpTime());
        } else {
            this.setSize(var0.getSize());
        }
    }

    class e
    implements a {
        private final double size;
        private double minX;
        private double minZ;
        private double maxX;
        private double maxZ;
        private VoxelShape shape;

        public e(double var1) {
            this.size = var1;
            this.updateBox();
        }

        @Override
        public double getMinX() {
            return this.minX;
        }

        @Override
        public double getMaxX() {
            return this.maxX;
        }

        @Override
        public double getMinZ() {
            return this.minZ;
        }

        @Override
        public double getMaxZ() {
            return this.maxZ;
        }

        @Override
        public double getSize() {
            return this.size;
        }

        @Override
        public BorderStatus getStatus() {
            return BorderStatus.STATIONARY;
        }

        @Override
        public double getLerpSpeed() {
            return 0.0;
        }

        @Override
        public long getLerpRemainingTime() {
            return 0L;
        }

        @Override
        public double getLerpTarget() {
            return this.size;
        }

        private void updateBox() {
            this.minX = MathHelper.clamp(WorldBorder.this.getCenterX() - this.size / 2.0, (double)(-WorldBorder.this.absoluteMaxSize), (double)WorldBorder.this.absoluteMaxSize);
            this.minZ = MathHelper.clamp(WorldBorder.this.getCenterZ() - this.size / 2.0, (double)(-WorldBorder.this.absoluteMaxSize), (double)WorldBorder.this.absoluteMaxSize);
            this.maxX = MathHelper.clamp(WorldBorder.this.getCenterX() + this.size / 2.0, (double)(-WorldBorder.this.absoluteMaxSize), (double)WorldBorder.this.absoluteMaxSize);
            this.maxZ = MathHelper.clamp(WorldBorder.this.getCenterZ() + this.size / 2.0, (double)(-WorldBorder.this.absoluteMaxSize), (double)WorldBorder.this.absoluteMaxSize);
            this.shape = VoxelShapes.join(VoxelShapes.INFINITY, VoxelShapes.box(Math.floor(this.getMinX()), Double.NEGATIVE_INFINITY, Math.floor(this.getMinZ()), Math.ceil(this.getMaxX()), Double.POSITIVE_INFINITY, Math.ceil(this.getMaxZ())), OperatorBoolean.ONLY_FIRST);
        }

        @Override
        public void onAbsoluteMaxSizeChange() {
            this.updateBox();
        }

        @Override
        public void onCenterChange() {
            this.updateBox();
        }

        @Override
        public a update() {
            return this;
        }

        @Override
        public VoxelShape getCollisionShape() {
            return this.shape;
        }
    }

    static interface a {
        public double getMinX();

        public double getMaxX();

        public double getMinZ();

        public double getMaxZ();

        public double getSize();

        public double getLerpSpeed();

        public long getLerpRemainingTime();

        public double getLerpTarget();

        public BorderStatus getStatus();

        public void onAbsoluteMaxSizeChange();

        public void onCenterChange();

        public a update();

        public VoxelShape getCollisionShape();
    }

    public static final class b
    extends Record {
        private final EnumDirection direction;
        final double distance;

        public b(EnumDirection var0, double var1) {
            this.direction = var0;
            this.distance = var1;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "direction;distance", "direction", "distance"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "direction;distance", "direction", "distance"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "direction;distance", "direction", "distance"}, this, var0);
        }

        public EnumDirection direction() {
            return this.direction;
        }

        public double distance() {
            return this.distance;
        }
    }

    class c
    implements a {
        private final double from;
        private final double to;
        private final long lerpEnd;
        private final long lerpBegin;
        private final double lerpDuration;

        c(double var1, double var3, long var5) {
            this.from = var1;
            this.to = var3;
            this.lerpDuration = var5;
            this.lerpBegin = SystemUtils.getMillis();
            this.lerpEnd = this.lerpBegin + var5;
        }

        @Override
        public double getMinX() {
            return MathHelper.clamp(WorldBorder.this.getCenterX() - this.getSize() / 2.0, (double)(-WorldBorder.this.absoluteMaxSize), (double)WorldBorder.this.absoluteMaxSize);
        }

        @Override
        public double getMinZ() {
            return MathHelper.clamp(WorldBorder.this.getCenterZ() - this.getSize() / 2.0, (double)(-WorldBorder.this.absoluteMaxSize), (double)WorldBorder.this.absoluteMaxSize);
        }

        @Override
        public double getMaxX() {
            return MathHelper.clamp(WorldBorder.this.getCenterX() + this.getSize() / 2.0, (double)(-WorldBorder.this.absoluteMaxSize), (double)WorldBorder.this.absoluteMaxSize);
        }

        @Override
        public double getMaxZ() {
            return MathHelper.clamp(WorldBorder.this.getCenterZ() + this.getSize() / 2.0, (double)(-WorldBorder.this.absoluteMaxSize), (double)WorldBorder.this.absoluteMaxSize);
        }

        @Override
        public double getSize() {
            double var0 = (double)(SystemUtils.getMillis() - this.lerpBegin) / this.lerpDuration;
            return var0 < 1.0 ? MathHelper.lerp(var0, this.from, this.to) : this.to;
        }

        @Override
        public double getLerpSpeed() {
            return Math.abs(this.from - this.to) / (double)(this.lerpEnd - this.lerpBegin);
        }

        @Override
        public long getLerpRemainingTime() {
            return this.lerpEnd - SystemUtils.getMillis();
        }

        @Override
        public double getLerpTarget() {
            return this.to;
        }

        @Override
        public BorderStatus getStatus() {
            return this.to < this.from ? BorderStatus.SHRINKING : BorderStatus.GROWING;
        }

        @Override
        public void onCenterChange() {
        }

        @Override
        public void onAbsoluteMaxSizeChange() {
        }

        @Override
        public a update() {
            if (this.getLerpRemainingTime() <= 0L) {
                return new e(this.to);
            }
            return this;
        }

        @Override
        public VoxelShape getCollisionShape() {
            return VoxelShapes.join(VoxelShapes.INFINITY, VoxelShapes.box(Math.floor(this.getMinX()), Double.NEGATIVE_INFINITY, Math.floor(this.getMinZ()), Math.ceil(this.getMaxX()), Double.POSITIVE_INFINITY, Math.ceil(this.getMaxZ())), OperatorBoolean.ONLY_FIRST);
        }
    }

    public static class d {
        private final double centerX;
        private final double centerZ;
        private final double damagePerBlock;
        private final double safeZone;
        private final int warningBlocks;
        private final int warningTime;
        private final double size;
        private final long sizeLerpTime;
        private final double sizeLerpTarget;

        d(double var0, double var2, double var4, double var6, int var8, int var9, double var10, long var12, double var14) {
            this.centerX = var0;
            this.centerZ = var2;
            this.damagePerBlock = var4;
            this.safeZone = var6;
            this.warningBlocks = var8;
            this.warningTime = var9;
            this.size = var10;
            this.sizeLerpTime = var12;
            this.sizeLerpTarget = var14;
        }

        d(WorldBorder var0) {
            this.centerX = var0.getCenterX();
            this.centerZ = var0.getCenterZ();
            this.damagePerBlock = var0.getDamagePerBlock();
            this.safeZone = var0.getDamageSafeZone();
            this.warningBlocks = var0.getWarningBlocks();
            this.warningTime = var0.getWarningTime();
            this.size = var0.getSize();
            this.sizeLerpTime = var0.getLerpRemainingTime();
            this.sizeLerpTarget = var0.getLerpTarget();
        }

        public double getCenterX() {
            return this.centerX;
        }

        public double getCenterZ() {
            return this.centerZ;
        }

        public double getDamagePerBlock() {
            return this.damagePerBlock;
        }

        public double getSafeZone() {
            return this.safeZone;
        }

        public int getWarningBlocks() {
            return this.warningBlocks;
        }

        public int getWarningTime() {
            return this.warningTime;
        }

        public double getSize() {
            return this.size;
        }

        public long getSizeLerpTime() {
            return this.sizeLerpTime;
        }

        public double getSizeLerpTarget() {
            return this.sizeLerpTarget;
        }

        public static d read(DynamicLike<?> var0, d var1) {
            double var2 = MathHelper.clamp(var0.get("BorderCenterX").asDouble(var1.centerX), -2.9999984E7, 2.9999984E7);
            double var4 = MathHelper.clamp(var0.get("BorderCenterZ").asDouble(var1.centerZ), -2.9999984E7, 2.9999984E7);
            double var6 = var0.get("BorderSize").asDouble(var1.size);
            long var8 = var0.get("BorderSizeLerpTime").asLong(var1.sizeLerpTime);
            double var10 = var0.get("BorderSizeLerpTarget").asDouble(var1.sizeLerpTarget);
            double var12 = var0.get("BorderSafeZone").asDouble(var1.safeZone);
            double var14 = var0.get("BorderDamagePerBlock").asDouble(var1.damagePerBlock);
            int var16 = var0.get("BorderWarningBlocks").asInt(var1.warningBlocks);
            int var17 = var0.get("BorderWarningTime").asInt(var1.warningTime);
            return new d(var2, var4, var14, var12, var16, var17, var6, var8, var10);
        }

        public void write(NBTTagCompound var0) {
            var0.putDouble("BorderCenterX", this.centerX);
            var0.putDouble("BorderCenterZ", this.centerZ);
            var0.putDouble("BorderSize", this.size);
            var0.putLong("BorderSizeLerpTime", this.sizeLerpTime);
            var0.putDouble("BorderSafeZone", this.safeZone);
            var0.putDouble("BorderDamagePerBlock", this.damagePerBlock);
            var0.putDouble("BorderSizeLerpTarget", this.sizeLerpTarget);
            var0.putDouble("BorderWarningBlocks", this.warningBlocks);
            var0.putDouble("BorderWarningTime", this.warningTime);
        }
    }
}

