/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.status;

import com.mojang.logging.LogUtils;
import java.util.EnumSet;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.LightEngineThreaded;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.StaticCache2D;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.ProtoChunkExtension;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkStep;
import net.minecraft.world.level.chunk.status.WorldGenContext;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import org.slf4j.Logger;

public class ChunkStatusTasks {
    private static final Logger LOGGER = LogUtils.getLogger();

    private static boolean isLighted(IChunkAccess var0) {
        return var0.getPersistedStatus().isOrAfter(ChunkStatus.LIGHT) && var0.isLightCorrect();
    }

    static CompletableFuture<IChunkAccess> passThrough(WorldGenContext var0, ChunkStep var1, StaticCache2D<GenerationChunkHolder> var2, IChunkAccess var3) {
        return CompletableFuture.completedFuture(var3);
    }

    static CompletableFuture<IChunkAccess> generateStructureStarts(WorldGenContext var0, ChunkStep var1, StaticCache2D<GenerationChunkHolder> var2, IChunkAccess var3) {
        WorldServer var4 = var0.level();
        if (var4.getServer().getWorldData().worldGenOptions().generateStructures()) {
            var0.generator().createStructures(var4.registryAccess(), var4.getChunkSource().getGeneratorState(), var4.structureManager(), var3, var0.structureManager(), var4.dimension());
        }
        var4.onStructureStartsAvailable(var3);
        return CompletableFuture.completedFuture(var3);
    }

    static CompletableFuture<IChunkAccess> loadStructureStarts(WorldGenContext var0, ChunkStep var1, StaticCache2D<GenerationChunkHolder> var2, IChunkAccess var3) {
        var0.level().onStructureStartsAvailable(var3);
        return CompletableFuture.completedFuture(var3);
    }

    static CompletableFuture<IChunkAccess> generateStructureReferences(WorldGenContext var0, ChunkStep var1, StaticCache2D<GenerationChunkHolder> var2, IChunkAccess var3) {
        WorldServer var4 = var0.level();
        RegionLimitedWorldAccess var5 = new RegionLimitedWorldAccess(var4, var2, var1, var3);
        var0.generator().createReferences(var5, var4.structureManager().forWorldGenRegion(var5), var3);
        return CompletableFuture.completedFuture(var3);
    }

    static CompletableFuture<IChunkAccess> generateBiomes(WorldGenContext var0, ChunkStep var1, StaticCache2D<GenerationChunkHolder> var2, IChunkAccess var3) {
        WorldServer var4 = var0.level();
        RegionLimitedWorldAccess var5 = new RegionLimitedWorldAccess(var4, var2, var1, var3);
        return var0.generator().createBiomes(var4.getChunkSource().randomState(), Blender.of(var5), var4.structureManager().forWorldGenRegion(var5), var3);
    }

    static CompletableFuture<IChunkAccess> generateNoise(WorldGenContext var02, ChunkStep var1, StaticCache2D<GenerationChunkHolder> var2, IChunkAccess var3) {
        WorldServer var4 = var02.level();
        RegionLimitedWorldAccess var5 = new RegionLimitedWorldAccess(var4, var2, var1, var3);
        return var02.generator().fillFromNoise(Blender.of(var5), var4.getChunkSource().randomState(), var4.structureManager().forWorldGenRegion(var5), var3).thenApply(var0 -> {
            ProtoChunk var1;
            BelowZeroRetrogen var2;
            if (var0 instanceof ProtoChunk && (var2 = (var1 = (ProtoChunk)var0).getBelowZeroRetrogen()) != null) {
                BelowZeroRetrogen.replaceOldBedrock(var1);
                if (var2.hasBedrockHoles()) {
                    var2.applyBedrockMask(var1);
                }
            }
            return var0;
        });
    }

    static CompletableFuture<IChunkAccess> generateSurface(WorldGenContext var0, ChunkStep var1, StaticCache2D<GenerationChunkHolder> var2, IChunkAccess var3) {
        WorldServer var4 = var0.level();
        RegionLimitedWorldAccess var5 = new RegionLimitedWorldAccess(var4, var2, var1, var3);
        var0.generator().buildSurface(var5, var4.structureManager().forWorldGenRegion(var5), var4.getChunkSource().randomState(), var3);
        return CompletableFuture.completedFuture(var3);
    }

    static CompletableFuture<IChunkAccess> generateCarvers(WorldGenContext var0, ChunkStep var1, StaticCache2D<GenerationChunkHolder> var2, IChunkAccess var3) {
        WorldServer var4 = var0.level();
        RegionLimitedWorldAccess var5 = new RegionLimitedWorldAccess(var4, var2, var1, var3);
        if (var3 instanceof ProtoChunk) {
            ProtoChunk var6 = (ProtoChunk)var3;
            Blender.addAroundOldChunksCarvingMaskFilter(var5, var6);
        }
        var0.generator().applyCarvers(var5, var4.getSeed(), var4.getChunkSource().randomState(), var4.getBiomeManager(), var4.structureManager().forWorldGenRegion(var5), var3);
        return CompletableFuture.completedFuture(var3);
    }

    static CompletableFuture<IChunkAccess> generateFeatures(WorldGenContext var0, ChunkStep var1, StaticCache2D<GenerationChunkHolder> var2, IChunkAccess var3) {
        WorldServer var4 = var0.level();
        HeightMap.primeHeightmaps(var3, EnumSet.of(HeightMap.Type.MOTION_BLOCKING, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, HeightMap.Type.OCEAN_FLOOR, HeightMap.Type.WORLD_SURFACE));
        RegionLimitedWorldAccess var5 = new RegionLimitedWorldAccess(var4, var2, var1, var3);
        var0.generator().applyBiomeDecoration(var5, var3, var4.structureManager().forWorldGenRegion(var5));
        Blender.generateBorderTicks(var5, var3);
        return CompletableFuture.completedFuture(var3);
    }

    static CompletableFuture<IChunkAccess> initializeLight(WorldGenContext var0, ChunkStep var1, StaticCache2D<GenerationChunkHolder> var2, IChunkAccess var3) {
        LightEngineThreaded var4 = var0.lightEngine();
        var3.initializeLightSources();
        ((ProtoChunk)var3).setLightEngine(var4);
        boolean var5 = ChunkStatusTasks.isLighted(var3);
        return var4.initializeLight(var3, var5);
    }

    static CompletableFuture<IChunkAccess> light(WorldGenContext var0, ChunkStep var1, StaticCache2D<GenerationChunkHolder> var2, IChunkAccess var3) {
        boolean var4 = ChunkStatusTasks.isLighted(var3);
        return var0.lightEngine().lightChunk(var3, var4);
    }

    static CompletableFuture<IChunkAccess> generateSpawn(WorldGenContext var0, ChunkStep var1, StaticCache2D<GenerationChunkHolder> var2, IChunkAccess var3) {
        if (!var3.isUpgrading()) {
            var0.generator().spawnOriginalMobs(new RegionLimitedWorldAccess(var0.level(), var2, var1, var3));
        }
        return CompletableFuture.completedFuture(var3);
    }

    static CompletableFuture<IChunkAccess> full(WorldGenContext var0, ChunkStep var1, StaticCache2D<GenerationChunkHolder> var2, IChunkAccess var3) {
        ChunkCoordIntPair var4 = var3.getPos();
        GenerationChunkHolder var5 = var2.get(var4.x, var4.z);
        return CompletableFuture.supplyAsync(() -> {
            Chunk var4;
            ProtoChunk var32 = (ProtoChunk)var3;
            WorldServer var5 = var0.level();
            if (var32 instanceof ProtoChunkExtension) {
                ProtoChunkExtension var6 = (ProtoChunkExtension)var32;
                var4 = var6.getWrapped();
            } else {
                var4 = new Chunk(var5, var32, var3 -> {
                    try (ProblemReporter.j var4 = new ProblemReporter.j(var3.problemPath(), LOGGER);){
                        ChunkStatusTasks.postLoadProtoChunk(var5, TagValueInput.create((ProblemReporter)var4, (HolderLookup.a)var5.registryAccess(), var32.getEntities()));
                    }
                });
                var5.replaceProtoChunk(new ProtoChunkExtension(var4, false));
            }
            var4.setFullStatus(var5::getFullStatus);
            var4.runPostLoad();
            var4.setLoaded(true);
            var4.registerAllBlockEntitiesAfterLevelLoad();
            var4.registerTickContainerInLevel(var5);
            var4.setUnsavedListener(var0.unsavedListener());
            return var4;
        }, var0.mainThreadExecutor());
    }

    private static void postLoadProtoChunk(WorldServer var0, ValueInput.b var1) {
        if (!var1.isEmpty()) {
            var0.addWorldGenChunkEntities(EntityTypes.loadEntitiesRecursive(var1, var0, EntitySpawnReason.LOAD));
        }
    }
}

