/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.gameevent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPosition;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.GameEventListenerRegistry;
import net.minecraft.world.phys.Vec3D;

public class GameEventDispatcher {
    private final WorldServer level;

    public GameEventDispatcher(WorldServer var0) {
        this.level = var0;
    }

    public void post(Holder<GameEvent> var0, Vec3D var1, GameEvent.a var2) {
        int var3 = var0.value().notificationRadius();
        BlockPosition var42 = BlockPosition.containing(var1);
        int var52 = SectionPosition.blockToSectionCoord(var42.getX() - var3);
        int var6 = SectionPosition.blockToSectionCoord(var42.getY() - var3);
        int var7 = SectionPosition.blockToSectionCoord(var42.getZ() - var3);
        int var8 = SectionPosition.blockToSectionCoord(var42.getX() + var3);
        int var9 = SectionPosition.blockToSectionCoord(var42.getY() + var3);
        int var10 = SectionPosition.blockToSectionCoord(var42.getZ() + var3);
        ArrayList<GameEvent.b> var11 = new ArrayList<GameEvent.b>();
        GameEventListenerRegistry.a var12 = (var4, var5) -> {
            if (var4.getDeliveryMode() == GameEventListener.a.BY_DISTANCE) {
                var11.add(new GameEvent.b(var0, var1, var2, var4, var5));
            } else {
                var4.handleGameEvent(this.level, var0, var2, var1);
            }
        };
        boolean var13 = false;
        for (int var14 = var52; var14 <= var8; ++var14) {
            for (int var15 = var7; var15 <= var10; ++var15) {
                Chunk var16 = this.level.getChunkSource().getChunkNow(var14, var15);
                if (var16 == null) continue;
                for (int var17 = var6; var17 <= var9; ++var17) {
                    var13 |= ((IChunkAccess)var16).getListenerRegistry(var17).visitInRangeListeners(var0, var1, var2, var12);
                }
            }
        }
        if (!var11.isEmpty()) {
            this.handleGameEventMessagesInQueue(var11);
        }
        if (var13) {
            PacketDebug.sendGameEventInfo(this.level, var0, var1);
        }
    }

    private void handleGameEventMessagesInQueue(List<GameEvent.b> var0) {
        Collections.sort(var0);
        for (GameEvent.b var2 : var0) {
            GameEventListener var3 = var2.recipient();
            var3.handleGameEvent(this.level, var2.gameEvent(), var2.context(), var2.source());
        }
    }
}

