/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import java.util.function.Predicate;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityMobSpawner;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureEmptyConfiguration;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.storage.loot.LootTables;
import org.slf4j.Logger;

public class WorldGenDungeons
extends WorldGenerator<WorldGenFeatureEmptyConfiguration> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final EntityTypes<?>[] MOBS = new EntityTypes[]{EntityTypes.SKELETON, EntityTypes.ZOMBIE, EntityTypes.ZOMBIE, EntityTypes.SPIDER};
    private static final IBlockData AIR = Blocks.CAVE_AIR.defaultBlockState();

    public WorldGenDungeons(Codec<WorldGenFeatureEmptyConfiguration> var0) {
        super(var0);
    }

    @Override
    public boolean place(FeaturePlaceContext<WorldGenFeatureEmptyConfiguration> var0) {
        BlockPosition var18;
        int var17;
        int var16;
        int var15;
        Predicate<IBlockData> var1 = WorldGenerator.isReplaceable(TagsBlock.FEATURES_CANNOT_REPLACE);
        BlockPosition var2 = var0.origin();
        RandomSource var3 = var0.random();
        GeneratorAccessSeed var4 = var0.level();
        int var5 = 3;
        int var6 = var3.nextInt(2) + 2;
        int var7 = -var6 - 1;
        int var8 = var6 + 1;
        int var9 = -1;
        int var10 = 4;
        int var11 = var3.nextInt(2) + 2;
        int var12 = -var11 - 1;
        int var13 = var11 + 1;
        int var14 = 0;
        for (var15 = var7; var15 <= var8; ++var15) {
            for (var16 = -1; var16 <= 4; ++var16) {
                for (var17 = var12; var17 <= var13; ++var17) {
                    var18 = var2.offset(var15, var16, var17);
                    boolean var19 = var4.getBlockState(var18).isSolid();
                    if (var16 == -1 && !var19) {
                        return false;
                    }
                    if (var16 == 4 && !var19) {
                        return false;
                    }
                    if (var15 != var7 && var15 != var8 && var17 != var12 && var17 != var13 || var16 != 0 || !var4.isEmptyBlock(var18) || !var4.isEmptyBlock(var18.above())) continue;
                    ++var14;
                }
            }
        }
        if (var14 < 1 || var14 > 5) {
            return false;
        }
        for (var15 = var7; var15 <= var8; ++var15) {
            for (var16 = 3; var16 >= -1; --var16) {
                for (var17 = var12; var17 <= var13; ++var17) {
                    var18 = var2.offset(var15, var16, var17);
                    IBlockData var19 = var4.getBlockState(var18);
                    if (var15 == var7 || var16 == -1 || var17 == var12 || var15 == var8 || var16 == 4 || var17 == var13) {
                        if (var18.getY() >= var4.getMinY() && !var4.getBlockState(var18.below()).isSolid()) {
                            var4.setBlock(var18, AIR, 2);
                            continue;
                        }
                        if (!var19.isSolid() || var19.is(Blocks.CHEST)) continue;
                        if (var16 == -1 && var3.nextInt(4) != 0) {
                            this.safeSetBlock(var4, var18, Blocks.MOSSY_COBBLESTONE.defaultBlockState(), var1);
                            continue;
                        }
                        this.safeSetBlock(var4, var18, Blocks.COBBLESTONE.defaultBlockState(), var1);
                        continue;
                    }
                    if (var19.is(Blocks.CHEST) || var19.is(Blocks.SPAWNER)) continue;
                    this.safeSetBlock(var4, var18, AIR, var1);
                }
            }
        }
        block6: for (var15 = 0; var15 < 2; ++var15) {
            for (var16 = 0; var16 < 3; ++var16) {
                int var19;
                int var182;
                var17 = var2.getX() + var3.nextInt(var6 * 2 + 1) - var6;
                BlockPosition var20 = new BlockPosition(var17, var182 = var2.getY(), var19 = var2.getZ() + var3.nextInt(var11 * 2 + 1) - var11);
                if (!var4.isEmptyBlock(var20)) continue;
                int var21 = 0;
                for (EnumDirection var23 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
                    if (!var4.getBlockState(var20.relative(var23)).isSolid()) continue;
                    ++var21;
                }
                if (var21 != 1) continue;
                this.safeSetBlock(var4, var20, StructurePiece.reorient(var4, var20, Blocks.CHEST.defaultBlockState()), var1);
                RandomizableContainer.setBlockEntityLootTable(var4, var3, var20, LootTables.SIMPLE_DUNGEON);
                continue block6;
            }
        }
        this.safeSetBlock(var4, var2, Blocks.SPAWNER.defaultBlockState(), var1);
        TileEntity var152 = var4.getBlockEntity(var2);
        if (var152 instanceof TileEntityMobSpawner) {
            TileEntityMobSpawner var162 = (TileEntityMobSpawner)var152;
            var162.setEntityId(this.randomEntityId(var3), var3);
        } else {
            LOGGER.error("Failed to fetch mob spawner entity at ({}, {}, {})", new Object[]{var2.getX(), var2.getY(), var2.getZ()});
        }
        return true;
    }

    private EntityTypes<?> randomEntityId(RandomSource var0) {
        return SystemUtils.getRandom(MOBS, var0);
    }
}

