/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.treedecorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.VegetationFeatures;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HangingMossBlock;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.feature.treedecorators.WorldGenFeatureTree;
import net.minecraft.world.level.levelgen.feature.treedecorators.WorldGenFeatureTrees;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public class PaleMossDecorator
extends WorldGenFeatureTree {
    public static final MapCodec<PaleMossDecorator> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("leaves_probability").forGetter(var0 -> Float.valueOf(var0.leavesProbability)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("trunk_probability").forGetter(var0 -> Float.valueOf(var0.trunkProbability)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("ground_probability").forGetter(var0 -> Float.valueOf(var0.groundProbability))).apply((Applicative)var02, PaleMossDecorator::new));
    private final float leavesProbability;
    private final float trunkProbability;
    private final float groundProbability;

    @Override
    protected WorldGenFeatureTrees<?> type() {
        return WorldGenFeatureTrees.PALE_MOSS;
    }

    public PaleMossDecorator(float var0, float var1, float var2) {
        this.leavesProbability = var0;
        this.trunkProbability = var1;
        this.groundProbability = var2;
    }

    @Override
    public void place(WorldGenFeatureTree.a var02) {
        RandomSource var1 = var02.random();
        GeneratorAccessSeed var22 = (GeneratorAccessSeed)var02.level();
        List<BlockPosition> var32 = SystemUtils.shuffledCopy(var02.logs(), var1);
        if (var32.isEmpty()) {
            return;
        }
        MutableObject var4 = new MutableObject((Object)var32.getFirst());
        var32.forEach(arg_0 -> PaleMossDecorator.a((Mutable)var4, arg_0));
        BlockPosition var5 = (BlockPosition)var4.getValue();
        if (var1.nextFloat() < this.groundProbability) {
            var22.registryAccess().lookup(Registries.CONFIGURED_FEATURE).flatMap(var0 -> var0.get(VegetationFeatures.PALE_MOSS_PATCH)).ifPresent(var3 -> ((WorldGenFeatureConfigured)var3.value()).place(var22, var22.getLevel().getChunkSource().getGenerator(), var1, var5.above()));
        }
        var02.logs().forEach(var2 -> {
            BlockPosition var3;
            if (var1.nextFloat() < this.trunkProbability && var02.isAir(var3 = var2.below())) {
                PaleMossDecorator.addMossHanger(var3, var02);
            }
        });
        var02.leaves().forEach(var2 -> {
            BlockPosition var3;
            if (var1.nextFloat() < this.leavesProbability && var02.isAir(var3 = var2.below())) {
                PaleMossDecorator.addMossHanger(var3, var02);
            }
        });
    }

    private static void addMossHanger(BlockPosition var0, WorldGenFeatureTree.a var1) {
        while (var1.isAir(var0.below()) && !((double)var1.random().nextFloat() < 0.5)) {
            var1.setBlock(var0, (IBlockData)Blocks.PALE_HANGING_MOSS.defaultBlockState().setValue(HangingMossBlock.TIP, false));
            var0 = var0.below();
        }
        var1.setBlock(var0, (IBlockData)Blocks.PALE_HANGING_MOSS.defaultBlockState().setValue(HangingMossBlock.TIP, true));
    }

    private static /* synthetic */ void a(Mutable var0, BlockPosition var1) {
        if (var1.getY() < ((BlockPosition)var0.getValue()).getY()) {
            var0.setValue((Object)var1);
        }
    }
}

