/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.providers.nbt;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.LootNbtProviderType;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.StorageNbtProvider;

public class NbtProviders {
    private static final Codec<NbtProvider> TYPED_CODEC = BuiltInRegistries.LOOT_NBT_PROVIDER_TYPE.byNameCodec().dispatch(NbtProvider::getType, LootNbtProviderType::codec);
    public static final Codec<NbtProvider> CODEC = Codec.lazyInitialized(() -> Codec.either(ContextNbtProvider.INLINE_CODEC, TYPED_CODEC).xmap(Either::unwrap, var0 -> {
        Either either;
        if (var0 instanceof ContextNbtProvider) {
            ContextNbtProvider var1 = (ContextNbtProvider)var0;
            either = Either.left((Object)var1);
        } else {
            either = Either.right((Object)var0);
        }
        return either;
    }));
    public static final LootNbtProviderType STORAGE = NbtProviders.register("storage", StorageNbtProvider.CODEC);
    public static final LootNbtProviderType CONTEXT = NbtProviders.register("context", ContextNbtProvider.CODEC);

    private static LootNbtProviderType register(String var0, MapCodec<? extends NbtProvider> var1) {
        return IRegistry.register(BuiltInRegistries.LOOT_NBT_PROVIDER_TYPE, MinecraftKey.withDefaultNamespace(var0), new LootNbtProviderType(var1));
    }
}

